/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.Widget;

public class SplitLayoutPanel
extends DockLayoutPanel {
    private static final int SPLITTER_SIZE = 4;

    public SplitLayoutPanel() {
        super(Style.Unit.PX);
    }

    public void insert(Widget child, DockLayoutPanel.Direction direction, double size, Widget before) {
        super.insert(child, direction, size, before);
        if (direction != DockLayoutPanel.Direction.CENTER) {
            this.insertSplitter(before);
        }
    }

    public boolean remove(Widget child) {
        assert (!(child instanceof Splitter)) : "Splitters may not be directly removed";
        if (super.remove(child)) {
            int idx = this.getWidgetIndex(child);
            if (idx < this.getWidgetCount() - 1) {
                this.remove(idx + 1);
            }
            return true;
        }
        return false;
    }

    public void setWidgetMinSize(Widget child, int minSize) {
        Splitter splitter = this.getAssociatedSplitter(child);
        splitter.setMinSize(minSize);
    }

    private Splitter getAssociatedSplitter(Widget child) {
        int idx = this.getWidgetIndex(child);
        if (idx < this.getWidgetCount() - 2) {
            Widget splitter = this.getWidget(idx + 1);
            assert (splitter instanceof Splitter) : "Expected child widget to be splitter";
            return (Splitter)splitter;
        }
        return null;
    }

    private void insertSplitter(Widget before) {
        assert (this.getChildren().size() > 0) : "Can't add a splitter before any children";
        assert (this.getCenter() == null) : "Can't add a splitter after the CENTER widget";
        Widget lastChild = this.getChildren().get(this.getChildren().size() - 1);
        DockLayoutPanel.LayoutData lastChildLayout = (DockLayoutPanel.LayoutData)lastChild.getLayoutData();
        Splitter splitter = null;
        switch (lastChildLayout.direction) {
            case WEST: {
                splitter = new HSplitter(lastChild, false);
                break;
            }
            case EAST: {
                splitter = new HSplitter(lastChild, true);
                break;
            }
            case NORTH: {
                splitter = new VSplitter(lastChild, false);
                break;
            }
            case SOUTH: {
                splitter = new VSplitter(lastChild, true);
                break;
            }
            default: {
                assert (false) : "Unexpected direction";
                break;
            }
        }
        super.insert((Widget)splitter, lastChildLayout.direction, 4.0, before);
    }

    private class VSplitter
    extends Splitter {
        public VSplitter(Widget target, boolean reverse) {
            super(target, reverse);
            this.getElement().getStyle().setPropertyPx("height", 4);
            this.setStyleName("LayoutPanel-VDragger");
        }

        protected int getAbsolutePosition() {
            return this.getAbsoluteTop();
        }

        protected int getEventPosition(Event event) {
            return event.getClientY();
        }

        protected int getTargetPosition() {
            return this.target.getAbsoluteTop();
        }

        protected int getTargetSize() {
            return this.target.getOffsetHeight();
        }
    }

    private abstract class Splitter
    extends Widget {
        protected final Widget target;
        private int offset;
        private boolean mouseDown;
        private Command layoutCommand;
        private final boolean reverse;
        private int minSize;

        public Splitter(Widget target, boolean reverse) {
            this.target = target;
            this.reverse = reverse;
            this.setElement(Document.get().createDivElement());
            this.sinkEvents(78);
            this.getElement().getStyle().setBackgroundColor("white");
        }

        public void onBrowserEvent(Event event) {
            switch (event.getTypeInt()) {
                case 4: {
                    this.mouseDown = true;
                    this.offset = this.getEventPosition(event) - this.getAbsolutePosition();
                    Event.setCapture(this.getElement());
                    event.preventDefault();
                    break;
                }
                case 8: {
                    this.mouseDown = false;
                    Event.releaseCapture(this.getElement());
                    event.preventDefault();
                    break;
                }
                case 64: {
                    if (!this.mouseDown) break;
                    int size = this.reverse ? this.getTargetPosition() + this.getTargetSize() - this.getEventPosition(event) - this.offset : this.getEventPosition(event) - this.getTargetPosition() - this.offset;
                    this.setAssociatedWidgetSize(size);
                    event.preventDefault();
                }
            }
        }

        public void setMinSize(int minSize) {
            this.minSize = minSize;
            DockLayoutPanel.LayoutData layout = (DockLayoutPanel.LayoutData)this.target.getLayoutData();
            this.setAssociatedWidgetSize((int)layout.size);
        }

        protected abstract int getAbsolutePosition();

        protected abstract int getEventPosition(Event var1);

        protected abstract int getTargetPosition();

        protected abstract int getTargetSize();

        private void setAssociatedWidgetSize(int size) {
            if (size < this.minSize) {
                size = this.minSize;
            }
            DockLayoutPanel.LayoutData layout = (DockLayoutPanel.LayoutData)this.target.getLayoutData();
            if ((double)size == layout.size) {
                return;
            }
            layout.size = size;
            if (this.layoutCommand == null) {
                this.layoutCommand = new Command(){

                    public void execute() {
                        Splitter.this.layoutCommand = null;
                        SplitLayoutPanel.this.forceLayout();
                    }
                };
                DeferredCommand.addCommand(this.layoutCommand);
            }
        }
    }

    private class HSplitter
    extends Splitter {
        public HSplitter(Widget target, boolean reverse) {
            super(target, reverse);
            this.getElement().getStyle().setPropertyPx("width", 4);
            this.setStyleName("LayoutPanel-HDragger");
        }

        protected int getAbsolutePosition() {
            return this.getAbsoluteLeft();
        }

        protected int getEventPosition(Event event) {
            return event.getClientX();
        }

        protected int getTargetPosition() {
            return this.target.getAbsoluteLeft();
        }

        protected int getTargetSize() {
            return this.target.getOffsetWidth();
        }
    }
}

