/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.benchmarks.client.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermutationIterator
implements Iterator<Permutation> {
    private boolean firstRun = true;
    private List<Iterator<?>> iterators;
    private boolean maybeHaveMore = true;
    private List<? extends Iterable<?>> iterables;
    private boolean rangeSkipped = false;
    private List<Object> values;

    public static void main(String[] args) {
        ArrayList<List<String>> iterables = new ArrayList<List<String>>(3);
        iterables.add(Arrays.asList("a", "b", "c"));
        iterables.add(Arrays.asList("1", "2", "3"));
        iterables.add(Arrays.asList("alpha", "beta", "gamma", "delta"));
        System.out.println("Testing normal iteration.");
        PermutationIterator it = new PermutationIterator(iterables);
        while (it.hasNext()) {
            Permutation p = (Permutation)it.next();
            System.out.println(p);
        }
        System.out.println("\nTesting skipping iteration.");
        Iterator<String> skipIterator = Arrays.asList("alpha", "beta", "gamma", "delta").iterator();
        boolean skipped = true;
        String skipValue = null;
        PermutationIterator it2 = new PermutationIterator(iterables);
        while (it2.hasNext()) {
            Permutation p = it2.next();
            if (skipped && skipIterator.hasNext()) {
                skipValue = skipIterator.next();
                skipped = false;
            }
            System.out.println(p);
            Object value = p.getValues().get(p.getValues().size() - 1);
            if (!value.equals(skipValue)) continue;
            it2.skipCurrentRange();
            skipped = true;
        }
    }

    public PermutationIterator(List<? extends Iterable<?>> iterables) {
        this.iterables = iterables;
        this.iterators = new ArrayList();
        for (Iterable<?> iterable : iterables) {
            this.iterators.add(iterable.iterator());
        }
        this.values = new ArrayList<Object>();
    }

    @Override
    public boolean hasNext() {
        if (!this.maybeHaveMore) {
            return false;
        }
        for (int currentIterator = this.iterators.size() - 1; currentIterator >= 0; --currentIterator) {
            Iterator<?> it = this.iterators.get(currentIterator);
            if (!it.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Permutation next() {
        assert (this.hasNext()) : "No more available permutations in this iterator.";
        if (this.firstRun) {
            for (Iterator<?> it : this.iterators) {
                this.values.add(it.next());
            }
            this.firstRun = false;
            return new Permutation(this.values);
        }
        if (this.rangeSkipped) {
            this.rangeSkipped = false;
            return new Permutation(this.values);
        }
        for (int currentIteratorIndex = this.iterators.size() - 1; currentIteratorIndex >= 0; --currentIteratorIndex) {
            Iterator<?> it = this.iterators.get(currentIteratorIndex);
            if (!it.hasNext()) continue;
            this.values.set(currentIteratorIndex, it.next());
            for (int i = currentIteratorIndex + 1; i < this.iterators.size(); ++i) {
                Iterable<?> resetIterable = this.iterables.get(i);
                Iterator<?> resetIterator = resetIterable.iterator();
                this.iterators.set(i, resetIterator);
                this.values.set(i, resetIterator.next());
            }
            return new Permutation(this.values);
        }
        throw new AssertionError((Object)"Assertion failed - Couldn't find a non-empty iterator.");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void skipCurrentRange() {
        this.rangeSkipped = true;
        for (int currentIteratorIndex = this.iterators.size() - 2; currentIteratorIndex >= 0; --currentIteratorIndex) {
            Iterator<?> it = this.iterators.get(currentIteratorIndex);
            if (!it.hasNext()) continue;
            this.values.set(currentIteratorIndex, it.next());
            for (int i = currentIteratorIndex + 1; i < this.iterators.size(); ++i) {
                Iterable<?> resetIterable = this.iterables.get(i);
                Iterator<?> resetIterator = resetIterable.iterator();
                this.iterators.set(i, resetIterator);
                this.values.set(i, resetIterator.next());
            }
            return;
        }
        this.maybeHaveMore = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Permutation {
        private List<Object> values;

        public Permutation(List<?> values) {
            this.values = new ArrayList(values);
        }

        public List<Object> getValues() {
            return this.values;
        }

        public String toString() {
            return this.values.toString();
        }
    }
}

