/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.layout.client.Layout;
import com.google.gwt.user.client.ui.AnimatedLayout;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.LayoutCommand;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.WidgetCollection;

public class DockLayoutPanel
extends ComplexPanel
implements AnimatedLayout,
RequiresResize,
ProvidesResize {
    private final Style.Unit unit;
    private Widget center;
    private final Layout layout;
    private final LayoutCommand layoutCmd;

    public DockLayoutPanel(Style.Unit unit) {
        this.unit = unit;
        this.setElement(Document.get().createDivElement());
        this.layout = new Layout(this.getElement());
        this.layoutCmd = new DockAnimateCommand(this.layout);
    }

    public void add(Widget widget) {
        this.insert(widget, Direction.CENTER, 0.0, null);
    }

    public void addEast(Widget widget, double size) {
        this.insert(widget, Direction.EAST, size, null);
    }

    public void addNorth(Widget widget, double size) {
        this.insert(widget, Direction.NORTH, size, null);
    }

    public void addSouth(Widget widget, double size) {
        this.insert(widget, Direction.SOUTH, size, null);
    }

    public void addWest(Widget widget, double size) {
        this.insert(widget, Direction.WEST, size, null);
    }

    public void animate(int duration) {
        this.animate(duration, null);
    }

    public void animate(int duration, Layout.AnimationCallback callback) {
        this.layoutCmd.schedule(duration, callback);
    }

    public void forceLayout() {
        this.layoutCmd.cancel();
        this.doLayout();
        this.layout.layout();
        this.onResize();
    }

    public Element getWidgetContainerElement(Widget child) {
        this.assertIsChild(child);
        return ((LayoutData)child.getLayoutData()).layer.getContainerElement();
    }

    public Direction getWidgetDirection(Widget child) {
        this.assertIsChild(child);
        if (child.getParent() != this) {
            return null;
        }
        return ((LayoutData)child.getLayoutData()).direction;
    }

    public void insertEast(Widget widget, double size, Widget before) {
        this.insert(widget, Direction.EAST, size, before);
    }

    public void insertNorth(Widget widget, double size, Widget before) {
        this.insert(widget, Direction.NORTH, size, before);
    }

    public void insertSouth(Widget widget, double size, Widget before) {
        this.insert(widget, Direction.SOUTH, size, before);
    }

    public void insertWest(Widget widget, double size, Widget before) {
        this.insert(widget, Direction.WEST, size, before);
    }

    public void onResize() {
        for (Widget child : this.getChildren()) {
            if (!(child instanceof RequiresResize)) continue;
            ((RequiresResize)((Object)child)).onResize();
        }
    }

    public boolean remove(Widget w) {
        boolean removed = super.remove(w);
        if (removed) {
            if (w == this.center) {
                this.center = null;
            }
            LayoutData data = (LayoutData)w.getLayoutData();
            this.layout.removeChild(data.layer);
        }
        return removed;
    }

    protected Widget getCenter() {
        return this.center;
    }

    protected Style.Unit getUnit() {
        return this.unit;
    }

    protected void insert(Widget widget, Direction direction, double size, Widget before) {
        this.assertIsChild(before);
        if (before == null) {
            assert (this.center == null) : "No widget may be added after the CENTER widget";
        } else assert (direction != Direction.CENTER) : "A CENTER widget must always be added last";
        widget.removeFromParent();
        WidgetCollection children = this.getChildren();
        if (before == null) {
            children.add(widget);
        } else {
            int index = children.indexOf(before);
            children.insert(widget, index);
        }
        if (direction == Direction.CENTER) {
            this.center = widget;
        }
        Layout.Layer layer = this.layout.attachChild(widget.getElement(), before != null ? before.getElement() : null, widget);
        LayoutData data = new LayoutData(direction, size, layer);
        widget.setLayoutData(data);
        this.adopt(widget);
        this.animate(0);
    }

    protected void onLoad() {
        this.layout.onAttach();
    }

    protected void onUnload() {
        this.layout.onDetach();
    }

    private void assertIsChild(Widget widget) {
        assert (widget == null || widget.getParent() == this) : "The specified widget is not a child of this panel";
    }

    private void doLayout() {
        int left = 0;
        int top = 0;
        int right = 0;
        int bottom = 0;
        for (Widget child : this.getChildren()) {
            LayoutData data = (LayoutData)child.getLayoutData();
            Layout.Layer layer = data.layer;
            switch (data.direction) {
                case NORTH: {
                    layer.setLeftRight(left, this.unit, right, this.unit);
                    layer.setTopHeight(top, this.unit, data.size, this.unit);
                    top = (int)((double)top + data.size);
                    break;
                }
                case SOUTH: {
                    layer.setLeftRight(left, this.unit, right, this.unit);
                    layer.setBottomHeight(bottom, this.unit, data.size, this.unit);
                    bottom = (int)((double)bottom + data.size);
                    break;
                }
                case WEST: {
                    layer.setTopBottom(top, this.unit, bottom, this.unit);
                    layer.setLeftWidth(left, this.unit, data.size, this.unit);
                    left = (int)((double)left + data.size);
                    break;
                }
                case EAST: {
                    layer.setTopBottom(top, this.unit, bottom, this.unit);
                    layer.setRightWidth(right, this.unit, data.size, this.unit);
                    right = (int)((double)right + data.size);
                    break;
                }
                case CENTER: {
                    layer.setLeftRight(left, this.unit, right, this.unit);
                    layer.setTopBottom(top, this.unit, bottom, this.unit);
                }
            }
        }
    }

    private class DockAnimateCommand
    extends LayoutCommand {
        public DockAnimateCommand(Layout layout) {
            super(layout);
        }

        protected void doBeforeLayout() {
            DockLayoutPanel.this.doLayout();
        }
    }

    protected static class LayoutData {
        public Direction direction;
        public double oldSize;
        public double size;
        public double originalSize;
        public boolean hidden;
        public Layout.Layer layer;

        public LayoutData(Direction direction, double size, Layout.Layer layer) {
            this.direction = direction;
            this.size = size;
            this.layer = layer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        NORTH,
        EAST,
        SOUTH,
        WEST,
        CENTER,
        LINE_START,
        LINE_END;

    }
}

