/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.cell.client;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.HasVerticalAlignment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconCellDecorator<C>
extends AbstractCell<C> {
    private final Cell<C> cell;
    private final String iconHtml;
    private final int imageWidth;
    private final String placeHolderHtml;

    public IconCellDecorator(ImageResource icon, Cell<C> cell) {
        this(icon, cell, HasVerticalAlignment.ALIGN_MIDDLE, 6);
    }

    public IconCellDecorator(ImageResource icon, Cell<C> cell, HasVerticalAlignment.VerticalAlignmentConstant valign, int spacing) {
        this.cell = cell;
        this.iconHtml = this.getImageHtml(icon, valign, false);
        this.imageWidth = icon.getWidth() + 6;
        this.placeHolderHtml = this.getImageHtml(icon, valign, true);
    }

    @Override
    public boolean consumesEvents() {
        return this.cell.consumesEvents();
    }

    @Override
    public boolean dependsOnSelection() {
        return this.cell.dependsOnSelection();
    }

    @Override
    public Object onBrowserEvent(Element parent, C value, Object viewData, NativeEvent event, ValueUpdater<C> valueUpdater) {
        return this.cell.onBrowserEvent(this.getCellParent(parent), value, viewData, event, valueUpdater);
    }

    @Override
    public void render(C value, Object viewData, StringBuilder sb) {
        sb.append("<div style='position:relative;padding-left:");
        sb.append(this.imageWidth);
        sb.append("px;'>");
        if (this.isIconUsed(value)) {
            sb.append(this.getIconHtml(value));
        } else {
            sb.append(this.placeHolderHtml);
        }
        sb.append("<div>");
        this.cell.render(value, viewData, sb);
        sb.append("</div></div>");
    }

    @Override
    public void setValue(Element parent, C value, Object viewData) {
        this.cell.setValue(this.getCellParent(parent), value, viewData);
    }

    protected String getIconHtml(C value) {
        return this.iconHtml;
    }

    protected boolean isIconUsed(C value) {
        return true;
    }

    private Element getCellParent(Element parent) {
        return (Element)parent.getFirstChildElement().getChild(1).cast();
    }

    private String getImageHtml(ImageResource res, HasVerticalAlignment.VerticalAlignmentConstant valign, boolean isPlaceholder) {
        StringBuilder sb = new StringBuilder();
        sb.append("<div style=\"position:absolute;left:0px;top:0px;height:100%;");
        sb.append("width:").append(res.getWidth()).append("px;");
        if (!isPlaceholder) {
            String vert = valign == HasVerticalAlignment.ALIGN_MIDDLE ? "center" : valign.getVerticalAlignString();
            sb.append("background:url('").append(res.getURL()).append("') ");
            sb.append("no-repeat scroll ").append(vert).append(" center transparent;");
        }
        sb.append("\"></div>");
        return sb.toString();
    }
}

