/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.cell.client;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.SelectElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionCell
extends AbstractCell<String> {
    private HashMap<String, Integer> indexForOption = new HashMap();
    private final List<String> options;

    public SelectionCell(List<String> options) {
        this.options = new ArrayList<String>(options);
        int index = 0;
        for (String option : options) {
            this.indexForOption.put(option, index++);
        }
    }

    @Override
    public Object onBrowserEvent(Element parent, String value, Object viewData, NativeEvent event, ValueUpdater<String> valueUpdater) {
        String type = event.getType();
        if (valueUpdater != null && "change".equals(type)) {
            SelectElement select = (SelectElement)parent.getFirstChild().cast();
            valueUpdater.update(this.options.get(select.getSelectedIndex()));
        }
        return viewData;
    }

    @Override
    public void render(String value, Object viewData, StringBuilder sb) {
        int selectedIndex = this.getSelectedIndex(value);
        sb.append("<select>");
        int index = 0;
        for (String option : this.options) {
            if (index++ == selectedIndex) {
                sb.append("<option selected='selected'>");
            } else {
                sb.append("<option>");
            }
            sb.append(option);
            sb.append("</option>");
        }
        sb.append("</select>");
    }

    private int getSelectedIndex(String value) {
        Integer index = this.indexForOption.get(value);
        if (index == null) {
            return -1;
        }
        return index;
    }
}

