/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.logging.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.logging.client.ConsoleLogHandler;
import com.google.gwt.logging.client.DefaultLevel;
import com.google.gwt.logging.client.DevelopmentModeLogHandler;
import com.google.gwt.logging.client.FirebugLogHandler;
import com.google.gwt.logging.client.HasWidgetsLogHandler;
import com.google.gwt.logging.client.LoggingPopup;
import com.google.gwt.logging.client.NullLogHandler;
import com.google.gwt.logging.client.NullLoggingPopup;
import com.google.gwt.logging.client.SystemLogHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HasWidgets;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogConfiguration
implements EntryPoint {
    private static LogConfigurationImpl impl = (LogConfigurationImpl)GWT.create(LogConfigurationImplNull.class);

    public void onModuleLoad() {
        impl.configureClientSideLogging();
    }

    private static class LogConfigurationImplRegular
    implements LogConfigurationImpl {
        private LogConfigurationImplRegular() {
        }

        public void configureClientSideLogging() {
            Logger root = Logger.getLogger("");
            this.setLevels(root);
            this.setDefaultHandlers(root);
        }

        private void addHandlerIfNotNull(Logger l, Handler h) {
            if (!(h instanceof NullLogHandler)) {
                l.addHandler(h);
            }
        }

        private Level parseLevel(String s) {
            if (s == null) {
                return null;
            }
            if (s.equals(Level.OFF.getName())) {
                return Level.OFF;
            }
            if (s.equals(Level.SEVERE.getName())) {
                return Level.SEVERE;
            }
            if (s.equals(Level.WARNING.getName())) {
                return Level.WARNING;
            }
            if (s.equals(Level.INFO.getName())) {
                return Level.INFO;
            }
            if (s.equals(Level.CONFIG.getName())) {
                return Level.CONFIG;
            }
            if (s.equals(Level.FINE.getName())) {
                return Level.FINE;
            }
            if (s.equals(Level.FINER.getName())) {
                return Level.FINER;
            }
            if (s.equals(Level.FINEST.getName())) {
                return Level.FINEST;
            }
            if (s.equals(Level.ALL.getName())) {
                return Level.ALL;
            }
            return null;
        }

        private void setDefaultHandlers(Logger l) {
            Handler console = (Handler)GWT.create(ConsoleLogHandler.class);
            this.addHandlerIfNotNull(l, console);
            Handler dev = (Handler)GWT.create(DevelopmentModeLogHandler.class);
            this.addHandlerIfNotNull(l, dev);
            Handler firebug = (Handler)GWT.create(FirebugLogHandler.class);
            this.addHandlerIfNotNull(l, firebug);
            Handler system = (Handler)GWT.create(SystemLogHandler.class);
            this.addHandlerIfNotNull(l, system);
            HasWidgets loggingWidget = (HasWidgets)GWT.create(LoggingPopup.class);
            if (!(loggingWidget instanceof NullLoggingPopup)) {
                this.addHandlerIfNotNull(l, new HasWidgetsLogHandler(loggingWidget));
            }
        }

        private void setLevels(Logger l) {
            Level paramLevel = this.parseLevel(Window.Location.getParameter("logLevel"));
            if (paramLevel != null) {
                l.setLevel(paramLevel);
            } else {
                DefaultLevel defaultLevel = (DefaultLevel)GWT.create(DefaultLevel.class);
                l.setLevel(defaultLevel.getLevel());
            }
        }
    }

    private static class LogConfigurationImplNull
    implements LogConfigurationImpl {
        private LogConfigurationImplNull() {
        }

        public void configureClientSideLogging() {
        }
    }

    private static interface LogConfigurationImpl {
        public void configureClientSideLogging();
    }
}

