/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.TableCellElement;
import com.google.gwt.dom.client.TableColElement;
import com.google.gwt.dom.client.TableElement;
import com.google.gwt.dom.client.TableRowElement;
import com.google.gwt.dom.client.TableSectionElement;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.cellview.client.CellListImpl;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextHeader;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListView;
import com.google.gwt.view.client.PagingListView;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.Range;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellTable<T>
extends Widget
implements PagingListView<T> {
    private static final int DEFAULT_PAGESIZE = 15;
    private static Resources DEFAULT_RESOURCES;
    private static Impl TABLE_IMPL;
    private final TableColElement colgroup;
    private List<Column<T, ?>> columns = new ArrayList();
    private List<Header<?>> footers = new ArrayList();
    private List<Header<?>> headers = new ArrayList();
    private boolean headersStale;
    private TableRowElement hoveringRow;
    private final CellListImpl<T> impl;
    private boolean isSelectionEnabled;
    private ProvidesKey<T> providesKey;
    private final Style style;
    private final TableElement table;
    private TableSectionElement tbody;
    private final TableSectionElement tbodyLoading;
    private TableSectionElement tfoot;
    private TableSectionElement thead;

    private static Resources getDefaultResources() {
        if (DEFAULT_RESOURCES == null) {
            DEFAULT_RESOURCES = (Resources)GWT.create(CleanResources.class);
        }
        return DEFAULT_RESOURCES;
    }

    public CellTable() {
        this(15);
    }

    public CellTable(int pageSize) {
        this(pageSize, CellTable.getDefaultResources());
    }

    public CellTable(int pageSize, Resources resources) {
        if (TABLE_IMPL == null) {
            TABLE_IMPL = (Impl)GWT.create(Impl.class);
        }
        this.style = resources.cellTableStyle();
        this.style.ensureInjected();
        this.table = Document.get().createTableElement();
        this.setElement(this.table);
        this.table.setCellSpacing(0);
        this.colgroup = Document.get().createColGroupElement();
        this.table.appendChild(this.colgroup);
        this.thead = this.table.createTHead();
        this.tbody = Document.get().createTBodyElement();
        this.table.appendChild(this.tbody);
        this.tbodyLoading = Document.get().createTBodyElement();
        this.table.appendChild(this.tbodyLoading);
        this.tfoot = this.table.createTFoot();
        this.setStyleName(this.style.cellTable());
        TableCellElement td = Document.get().createTDElement();
        TableRowElement tr = Document.get().createTRElement();
        this.tbodyLoading.appendChild(tr);
        tr.appendChild(td);
        td.setAlign("center");
        td.setInnerHTML("<div class='" + this.style.loading() + "'></div>");
        this.impl = new CellListImpl<T>(this, pageSize, this.tbody){

            @Override
            public void setData(List<T> values, int start) {
                CellTable.this.createHeadersAndFooters();
                super.setData(values, start);
            }

            @Override
            protected Element convertToElements(String html) {
                return TABLE_IMPL.convertToSectionElement("tbody", html);
            }

            @Override
            protected boolean dependsOnSelection() {
                for (Column column : CellTable.this.columns) {
                    if (!column.dependsOnSelection()) continue;
                    return true;
                }
                return false;
            }

            @Override
            protected void emitHtml(StringBuilder sb, List<T> values, int start, SelectionModel<? super T> selectionModel) {
                CellTable.this.setLoadingIconVisible(false);
                String firstColumnStyle = CellTable.this.style.firstColumn();
                String lastColumnStyle = CellTable.this.style.lastColumn();
                int columnCount = CellTable.this.columns.size();
                int length = values.size();
                int end = start + length;
                for (int i = start; i < end; ++i) {
                    Object value = values.get(i - start);
                    boolean isSelected = selectionModel == null || value == null ? false : selectionModel.isSelected(value);
                    sb.append("<tr onclick='' __idx='").append(i).append("'");
                    sb.append(" class='");
                    sb.append(i % 2 == 0 ? CellTable.this.style.evenRow() : CellTable.this.style.oddRow());
                    if (isSelected) {
                        sb.append(" ").append(CellTable.this.style.selectedRow());
                    }
                    sb.append("'>");
                    int curColumn = 0;
                    for (Column column : CellTable.this.columns) {
                        sb.append("<td class='").append(CellTable.this.style.cell());
                        if (curColumn == 0) {
                            sb.append(" ").append(firstColumnStyle);
                        }
                        if (curColumn == columnCount - 1) {
                            sb.append(" ").append(lastColumnStyle);
                        }
                        sb.append("'>");
                        int bufferLength = sb.length();
                        if (value != null) {
                            column.render(value, CellTable.this.providesKey, sb);
                        }
                        if (bufferLength == sb.length()) {
                            sb.append("&nbsp");
                        }
                        sb.append("</td>");
                        ++curColumn;
                    }
                    sb.append("</tr>");
                }
            }

            @Override
            protected Element renderChildContents(String html) {
                return CellTable.this.tbody = TABLE_IMPL.renderSectionContents(CellTable.this.tbody, html);
            }

            @Override
            protected void setSelected(Element elem, boolean selected) {
                CellTable.setStyleName(elem, CellTable.this.style.selectedRow(), selected);
            }

            @Override
            protected void updateSelection() {
                for (Header header : CellTable.this.headers) {
                    if (header == null || !header.dependsOnSelection()) continue;
                    CellTable.this.createHeaders(false);
                    break;
                }
                for (Header footer : CellTable.this.footers) {
                    if (footer == null || !footer.dependsOnSelection()) continue;
                    CellTable.this.createHeaders(true);
                    break;
                }
                super.updateSelection();
            }
        };
        this.setPageSize(pageSize);
        this.sinkEvents(8189);
        this.setLoadingIconVisible(true);
    }

    public void addColumn(Column<T, ?> col) {
        this.addColumn(col, (Header)null, (Header)null);
    }

    public void addColumn(Column<T, ?> col, Header<?> header) {
        this.addColumn(col, header, null);
    }

    public void addColumn(Column<T, ?> col, Header<?> header, Header<?> footer) {
        this.headers.add(header);
        this.footers.add(footer);
        this.columns.add(col);
        this.headersStale = true;
        this.redraw();
    }

    public void addColumn(Column<T, ?> col, String headerString) {
        this.addColumn(col, new TextHeader(headerString), null);
    }

    public void addColumn(Column<T, ?> col, String headerString, String footerString) {
        this.addColumn(col, new TextHeader(headerString), new TextHeader(footerString));
    }

    public void addColumnStyleName(int index, String styleName) {
        this.ensureTableColElement(index).addClassName(styleName);
    }

    public int getBodyHeight() {
        int height = this.getClientHeight(this.tbody);
        return height;
    }

    @Override
    public int getDataSize() {
        return this.impl.getDataSize();
    }

    public T getDisplayedItem(int indexOnPage) {
        this.checkRowBounds(indexOnPage);
        return this.impl.getData().get(indexOnPage);
    }

    public List<T> getDisplayedItems() {
        return new ArrayList<T>(this.impl.getData());
    }

    public int getHeaderHeight() {
        int height = this.getClientHeight(this.thead);
        return height;
    }

    public ProvidesKey<T> getKeyProvider() {
        return this.providesKey;
    }

    public int getNumDisplayedItems() {
        return this.impl.getDisplayedItemCount();
    }

    @Override
    public int getPageSize() {
        return this.impl.getPageSize();
    }

    @Override
    public int getPageStart() {
        return this.impl.getPageStart();
    }

    @Override
    public Range getRange() {
        return this.impl.getRange();
    }

    public TableRowElement getRowElement(int row) {
        this.checkRowBounds(row);
        NodeList<TableRowElement> rows = this.tbody.getRows();
        return rows.getLength() > row ? rows.getItem(row) : null;
    }

    public int getSize() {
        return this.impl.getDataSize();
    }

    @Override
    public boolean isDataSizeExact() {
        return this.impl.dataSizeIsExact();
    }

    public boolean isSelectionEnabled() {
        return this.isSelectionEnabled;
    }

    @Override
    public void onBrowserEvent(Event event) {
        super.onBrowserEvent(event);
        EventTarget eventTarget = event.getEventTarget();
        Node cell = null;
        if (eventTarget != null && Element.is(eventTarget)) {
            cell = this.findNearestParentCell(Element.as(eventTarget));
        }
        if (cell == null) {
            return;
        }
        TableRowElement tr = TableRowElement.as(cell.getParentElement());
        TableSectionElement section = TableSectionElement.as(tr.getParentElement());
        int col = ((TableCellElement)cell).getCellIndex();
        if (section == this.thead) {
            Header<?> header = this.headers.get(col);
            if (header != null) {
                header.onBrowserEvent((Element)cell, event);
            }
        } else if (section == this.tfoot) {
            Header<?> footer = this.footers.get(col);
            if (footer != null) {
                footer.onBrowserEvent((Element)cell, event);
            }
        } else if (section == this.tbody) {
            SelectionModel<T> selectionModel;
            int row = tr.getSectionRowIndex();
            if (event.getType().equals("mouseover")) {
                if (this.hoveringRow != null) {
                    this.hoveringRow.removeClassName(this.style.hoveredRow());
                }
                this.hoveringRow = tr;
                tr.addClassName(this.style.hoveredRow());
            } else if (event.getType().equals("mouseout")) {
                this.hoveringRow = null;
                tr.removeClassName(this.style.hoveredRow());
            }
            T value = this.impl.getData().get(row);
            Column<T, ?> column = this.columns.get(col);
            column.onBrowserEvent((Element)cell, this.impl.getPageStart() + row, value, event, this.providesKey);
            if (this.isSelectionEnabled && event.getTypeInt() == 1 && (selectionModel = this.impl.getSelectionModel()) != null) {
                selectionModel.setSelected(value, true);
            }
        }
    }

    public void redraw() {
        this.setLoadingIconVisible(false);
        this.impl.redraw();
    }

    public void refresh() {
        this.setLoadingIconVisible(true);
        this.impl.refresh();
    }

    public void refreshFooters() {
        this.createHeaders(true);
    }

    public void refreshHeaders() {
        this.createHeaders(false);
    }

    public void removeColumnStyleName(int index, String styleName) {
        if (index >= this.colgroup.getChildCount()) {
            return;
        }
        this.ensureTableColElement(index).removeClassName(styleName);
    }

    @Override
    public void setData(int start, int length, List<T> values) {
        this.impl.setData(values, start);
    }

    @Override
    public void setDataSize(int size, boolean isExact) {
        this.impl.setDataSize(size, isExact);
        if (size <= 0) {
            this.setLoadingIconVisible(false);
        }
    }

    @Override
    public void setDelegate(ListView.Delegate<T> delegate) {
        this.impl.setDelegate(delegate);
    }

    public void setKeyProvider(ProvidesKey<T> providesKey) {
        this.providesKey = providesKey;
    }

    @Override
    public void setPager(PagingListView.Pager<T> pager) {
        this.impl.setPager(pager);
    }

    @Override
    public void setPageSize(int pageSize) {
        this.impl.setPageSize(pageSize);
    }

    @Override
    public void setPageStart(int pageStart) {
        this.setLoadingIconVisible(true);
        this.impl.setPageStart(pageStart);
    }

    public void setSelectionEnabled(boolean isSelectionEnabled) {
        this.isSelectionEnabled = isSelectionEnabled;
    }

    @Override
    public void setSelectionModel(SelectionModel<? super T> selectionModel) {
        this.impl.setSelectionModel(selectionModel, true);
    }

    protected void checkRowBounds(int row) {
        int rowSize = this.impl.getDisplayedItemCount();
        if (row >= rowSize || row < 0) {
            throw new IndexOutOfBoundsException("Row index: " + row + ", Row size: " + rowSize);
        }
    }

    private void createHeaders(boolean isFooter) {
        List<Header<?>> theHeaders = isFooter ? this.footers : this.headers;
        TableSectionElement section = isFooter ? this.tfoot : this.thead;
        String className = isFooter ? this.style.footer() : this.style.header();
        boolean hasHeader = false;
        StringBuilder sb = new StringBuilder();
        sb.append("<tr>");
        int columnCount = this.columns.size();
        int curColumn = 0;
        for (Header<?> header : theHeaders) {
            sb.append("<th class='").append(className);
            if (curColumn == 0) {
                sb.append(" ");
                sb.append(isFooter ? this.style.firstColumnFooter() : this.style.firstColumnHeader());
            }
            if (curColumn == columnCount - 1) {
                sb.append(" ");
                sb.append(isFooter ? this.style.lastColumnFooter() : this.style.lastColumnHeader());
            }
            sb.append("'>");
            if (header != null) {
                hasHeader = true;
                header.render(sb);
            }
            sb.append("</th>");
            ++curColumn;
        }
        sb.append("</tr>");
        section = TABLE_IMPL.renderSectionContents(section, sb.toString());
        if (isFooter) {
            this.tfoot = section;
        } else {
            this.thead = section;
        }
        CellTable.setVisible(section, hasHeader);
    }

    private void createHeadersAndFooters() {
        if (this.headersStale) {
            this.headersStale = false;
            this.createHeaders(false);
            this.createHeaders(true);
        }
    }

    private TableColElement ensureTableColElement(int index) {
        for (int i = this.colgroup.getChildCount(); i <= index; ++i) {
            this.colgroup.appendChild(Document.get().createColElement());
        }
        return (TableColElement)this.colgroup.getChild(index).cast();
    }

    private TableCellElement findNearestParentCell(Element elem) {
        while (elem != null && elem != this.table) {
            String tagName = elem.getTagName();
            if ("td".equalsIgnoreCase(tagName) || "th".equalsIgnoreCase(tagName)) {
                return (TableCellElement)elem.cast();
            }
            elem = elem.getParentElement();
        }
        return null;
    }

    private native int getClientHeight(Element var1);

    private void setLoadingIconVisible(boolean visible) {
        if (visible) {
            this.tbody.setInnerText("");
        }
        TableCellElement td = this.tbodyLoading.getRows().getItem(0).getCells().getItem(0);
        td.setColSpan(Math.max(1, this.columns.size()));
        CellTable.setVisible(this.tbodyLoading, visible);
    }

    private static class ImplTrident
    extends Impl {
        private ImplTrident() {
        }

        protected TableSectionElement renderSectionContents(TableSectionElement section, String html) {
            TableSectionElement newSection = this.convertToSectionElement(section.getTagName(), html);
            section.getParentElement().replaceChild(newSection, section);
            return newSection;
        }
    }

    private static class Impl {
        final Element tmpElem = Document.get().createDivElement();

        private Impl() {
        }

        protected TableSectionElement convertToSectionElement(String sectionTag, String rowHtml) {
            sectionTag = sectionTag.toLowerCase();
            String innerHtml = "<table><" + sectionTag + ">" + rowHtml + "</" + sectionTag + "></table>";
            this.tmpElem.setInnerHTML(innerHtml);
            TableElement tableElem = (TableElement)this.tmpElem.getFirstChildElement().cast();
            if ("tbody".equals(sectionTag)) {
                return tableElem.getTBodies().getItem(0);
            }
            if ("thead".equals(sectionTag)) {
                return tableElem.getTHead();
            }
            if ("tfoot".equals(sectionTag)) {
                return tableElem.getTFoot();
            }
            throw new IllegalArgumentException("Invalid table section tag: " + sectionTag);
        }

        protected TableSectionElement renderSectionContents(TableSectionElement section, String html) {
            section.setInnerHTML(html);
            return section;
        }
    }

    public static interface Style
    extends CssResource {
        public String cell();

        public String cellTable();

        public String evenRow();

        public String firstColumn();

        public String firstColumnFooter();

        public String firstColumnHeader();

        public String footer();

        public String header();

        public String hoveredRow();

        public String lastColumn();

        public String lastColumnFooter();

        public String lastColumnHeader();

        public String loading();

        public String oddRow();

        public String selectedRow();
    }

    public static interface Resources
    extends ClientBundle {
        @ClientBundle.Source(value={"cellTableHeaderBackground.png"})
        @ImageResource.ImageOptions(repeatStyle=ImageResource.RepeatStyle.Horizontal)
        public ImageResource cellTableFooterBackground();

        @ImageResource.ImageOptions(repeatStyle=ImageResource.RepeatStyle.Horizontal)
        public ImageResource cellTableHeaderBackground();

        public ImageResource cellTableLoading();

        @ClientBundle.Source(value={"cellListSelectedBackground.png"})
        @ImageResource.ImageOptions(repeatStyle=ImageResource.RepeatStyle.Horizontal)
        public ImageResource cellTableSelectedBackground();

        @ClientBundle.Source(value={"CellTable.css"})
        public Style cellTableStyle();
    }

    public static interface CleanStyle
    extends Style {
        public String footer();

        public String header();
    }

    public static interface CleanResources
    extends Resources {
        @ClientBundle.Source(value={"CellTableClean.css"})
        public CleanStyle cellTableStyle();
    }
}

