/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.animation.client.Animation;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.cellview.client.CellTreeNodeView;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasAnimation;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.view.client.TreeViewModel;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellTree
extends Composite
implements HasAnimation {
    private static final int DEFAULT_LIST_SIZE = 25;
    private static Resources DEFAULT_RESOURCES;
    private NodeAnimation animation;
    private final String closedImageHtml;
    private final String closedImageTopHtml;
    private int defaultNodeSize = 25;
    private final int imageWidth;
    private boolean isAnimationEnabled;
    private final String loadingImageHtml;
    private final String openImageHtml;
    private final String openImageTopHtml;
    private final CellTreeNodeView<?> rootNode;
    private final Style style;
    private final TreeViewModel viewModel;

    private static Resources getDefaultResources() {
        if (DEFAULT_RESOURCES == null) {
            DEFAULT_RESOURCES = (Resources)GWT.create(Resources.class);
        }
        return DEFAULT_RESOURCES;
    }

    public <T> CellTree(TreeViewModel viewModel, T rootValue) {
        this(viewModel, rootValue, CellTree.getDefaultResources());
    }

    public <T> CellTree(TreeViewModel viewModel, T rootValue, Resources resources) {
        this.viewModel = viewModel;
        this.style = resources.cellTreeStyle();
        this.style.ensureInjected();
        this.initWidget(new SimplePanel());
        this.setStyleName("gwt-StandardTreeView");
        ImageResource treeOpen = resources.cellTreeOpenItem();
        ImageResource treeClosed = resources.cellTreeClosedItem();
        ImageResource treeLoading = resources.cellTreeLoading();
        this.openImageHtml = this.getImageHtml(treeOpen, false);
        this.closedImageHtml = this.getImageHtml(treeClosed, false);
        this.openImageTopHtml = this.getImageHtml(treeOpen, true);
        this.closedImageTopHtml = this.getImageHtml(treeClosed, true);
        this.loadingImageHtml = this.getImageHtml(treeLoading, false);
        this.imageWidth = Math.max(Math.max(treeOpen.getWidth(), treeClosed.getWidth()), treeLoading.getWidth());
        this.setAnimation(SlideAnimation.create());
        this.sinkEvents(1149);
        CellTreeNodeView<T> root = new CellTreeNodeView<T>(this, null, null, this.getElement(), rootValue);
        this.rootNode = root;
        root.setOpen(true);
    }

    public NodeAnimation getAnimation() {
        return this.animation;
    }

    public int getDefaultNodeSize() {
        return this.defaultNodeSize;
    }

    public TreeViewModel getTreeViewModel() {
        return this.viewModel;
    }

    @Override
    public boolean isAnimationEnabled() {
        return this.isAnimationEnabled;
    }

    @Override
    public void onBrowserEvent(Event event) {
        super.onBrowserEvent(event);
        Element target = (Element)event.getEventTarget().cast();
        ArrayList<Element> chain = new ArrayList<Element>();
        this.collectElementChain(chain, this.getElement(), target);
        CellTreeNodeView<?> nodeView = this.findItemByChain(chain, 0, this.rootNode);
        if (nodeView != null && nodeView != this.rootNode) {
            boolean consumesEvent;
            if ("click".equals(event.getType())) {
                Element showMoreElem = nodeView.getShowMoreElement();
                if (nodeView.getImageElement().isOrHasChild(target)) {
                    nodeView.setOpen(!nodeView.isOpen());
                    return;
                }
                if (showMoreElem != null && showMoreElem.isOrHasChild(target)) {
                    nodeView.showMore();
                    return;
                }
            }
            if (nodeView.getCellParent().isOrHasChild(target) && !(consumesEvent = nodeView.fireEventToCell(event)) && "click".equals(event.getType())) {
                nodeView.select();
            }
        }
    }

    public void setAnimation(NodeAnimation animation) {
        assert (animation != null) : "animation cannot be null";
        this.animation = animation;
    }

    @Override
    public void setAnimationEnabled(boolean enable) {
        this.isAnimationEnabled = enable;
        if (!enable && this.animation != null) {
            this.animation.cancel();
        }
    }

    public void setDefaultNodeSize(int defaultNodeSize) {
        this.defaultNodeSize = defaultNodeSize;
    }

    String getClosedImageHtml(boolean isTop) {
        return isTop ? this.closedImageTopHtml : this.closedImageHtml;
    }

    int getImageWidth() {
        return this.imageWidth;
    }

    String getLoadingImageHtml() {
        return this.loadingImageHtml;
    }

    String getOpenImageHtml(boolean isTop) {
        return isTop ? this.openImageTopHtml : this.openImageHtml;
    }

    Style getStyle() {
        return this.style;
    }

    void maybeAnimateTreeNode(CellTreeNodeView<?> node) {
        if (this.animation != null) {
            this.animation.animate(node, node.consumeAnimate() && this.isAnimationEnabled() && !node.isRootNode());
        }
    }

    private void collectElementChain(ArrayList<Element> chain, Element hRoot, Element hElem) {
        if (hElem == null || hElem == hRoot) {
            return;
        }
        this.collectElementChain(chain, hRoot, hElem.getParentElement());
        chain.add(hElem);
    }

    private CellTreeNodeView<?> findItemByChain(ArrayList<Element> chain, int idx, CellTreeNodeView<?> parent) {
        if (idx == chain.size()) {
            return parent;
        }
        Element hCurElem = chain.get(idx);
        int n = parent.getChildCount();
        for (int i = 0; i < n; ++i) {
            CellTreeNodeView<?> child = parent.getChildNode(i);
            if (child.getElement() != hCurElem) continue;
            CellTreeNodeView<?> retItem = this.findItemByChain(chain, idx + 1, child);
            if (retItem == null) {
                return child;
            }
            return retItem;
        }
        return this.findItemByChain(chain, idx + 1, parent);
    }

    private String getImageHtml(ImageResource res, boolean isTop) {
        StringBuilder sb = new StringBuilder();
        sb.append("<div class='").append(this.style.itemImage());
        if (isTop) {
            sb.append(" ").append(this.style.topItemImage());
        }
        sb.append("' ");
        sb.append("style=\"position:absolute;left:0px;top:0px;");
        sb.append("height:").append(res.getHeight()).append("px;");
        sb.append("width:").append(res.getWidth()).append("px;");
        sb.append("background:url('").append(res.getURL()).append("') ");
        sb.append("no-repeat scroll center center transparent;");
        sb.append("\"></div>");
        return sb.toString();
    }

    public static interface CleanResources
    extends Resources {
        @ClientBundle.Source(value={"cellTreeClosedArrow.png"})
        public ImageResource cellTreeClosedItem();

        @ClientBundle.Source(value={"cellTreeLoadingClean.gif"})
        public ImageResource cellTreeLoading();

        @ClientBundle.Source(value={"cellTreeOpenArrow.png"})
        public ImageResource cellTreeOpenItem();

        @ClientBundle.Source(value={"CellTreeClean.css"})
        public CleanStyle cellTreeStyle();
    }

    public static interface CleanStyle
    extends Style {
        public String topItem();

        public String topItemImageValue();
    }

    public static interface Style
    extends CssResource {
        public String emptyMessage();

        public String item();

        public String itemImage();

        public String itemImageValue();

        public String itemValue();

        public String openItem();

        public String selectedItem();

        public String showMoreButton();

        public String topItem();

        public String topItemImage();

        public String topItemImageValue();
    }

    public static class SlideAnimation
    extends RevealAnimation {
        public static SlideAnimation create() {
            return new SlideAnimation();
        }

        private SlideAnimation() {
        }

        protected void onComplete() {
            this.contentContainer.getStyle().clearPosition();
            this.contentContainer.getStyle().clearTop();
            this.contentContainer.getStyle().clearWidth();
            super.onComplete();
        }

        protected void onStart() {
            super.onStart();
            if (this.opening) {
                this.contentContainer.getStyle().setTop(-this.height, Style.Unit.PX);
            } else {
                this.contentContainer.getStyle().setTop(0.0, Style.Unit.PX);
            }
            this.contentContainer.getStyle().setPosition(Style.Position.RELATIVE);
        }

        protected void onUpdate(double progress) {
            super.onUpdate(progress);
            if (this.opening) {
                double curTop = (1.0 - progress) * (double)(-this.height);
                this.contentContainer.getStyle().setTop(curTop, Style.Unit.PX);
            } else {
                double curTop = progress * (double)(-this.height);
                this.contentContainer.getStyle().setTop(curTop, Style.Unit.PX);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RevealAnimation
    extends NodeAnimation {
        Element contentContainer;
        int height;
        boolean opening;
        private Element animFrame;
        private Element childContainer;

        public static RevealAnimation create() {
            return new RevealAnimation();
        }

        private RevealAnimation() {
        }

        @Override
        protected void onComplete() {
            this.cleanup();
        }

        @Override
        protected void onStart() {
            if (this.opening) {
                this.animFrame.getStyle().setHeight(1.0, Style.Unit.PX);
                this.animFrame.getStyle().clearDisplay();
                this.height = this.contentContainer.getScrollHeight();
            } else {
                this.height = this.contentContainer.getOffsetHeight();
            }
        }

        @Override
        protected void onUpdate(double progress) {
            if (this.opening) {
                double curHeight = progress * (double)this.height;
                this.animFrame.getStyle().setHeight(curHeight, Style.Unit.PX);
            } else {
                double curHeight = (1.0 - progress) * (double)this.height;
                this.animFrame.getStyle().setHeight(curHeight, Style.Unit.PX);
            }
        }

        @Override
        void animate(CellTreeNodeView<?> node, boolean isAnimationEnabled) {
            this.cancel();
            this.opening = node.isOpen();
            this.animFrame = node.ensureAnimationFrame();
            this.contentContainer = node.ensureContentContainer();
            this.childContainer = node.ensureChildContainer();
            if (isAnimationEnabled) {
                int duration = this.getDuration();
                int childCount = this.childContainer.getChildCount();
                if (childCount < 4) {
                    duration = (int)((double)childCount / 4.0 * (double)duration);
                }
                this.run(duration);
            } else {
                this.cleanup();
            }
        }

        private void cleanup() {
            if (this.opening) {
                this.animFrame.getStyle().clearDisplay();
            } else {
                this.animFrame.getStyle().setDisplay(Style.Display.NONE);
                this.childContainer.setInnerHTML("");
            }
            this.animFrame.getStyle().clearHeight();
            this.contentContainer = null;
            this.childContainer = null;
            this.animFrame = null;
        }
    }

    public static interface Resources
    extends ClientBundle {
        public ImageResource cellTreeClosedItem();

        public ImageResource cellTreeLoading();

        public ImageResource cellTreeOpenItem();

        @ImageResource.ImageOptions(repeatStyle=ImageResource.RepeatStyle.Horizontal)
        public ImageResource cellTreeSelectedBackground();

        @ClientBundle.Source(value={"CellTree.css"})
        public Style cellTreeStyle();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class NodeAnimation
    extends Animation {
        private static final int DEFAULT_ANIMATION_DURATION = 450;
        private int duration = 450;

        NodeAnimation() {
        }

        public int getDuration() {
            return this.duration;
        }

        public void setDuration(int duration) {
            this.duration = duration;
        }

        abstract void animate(CellTreeNodeView<?> var1, boolean var2);
    }
}

