/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.HasCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.view.client.HasViewData;
import com.google.gwt.view.client.ProvidesKey;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Column<T, C>
implements HasViewData,
HasCell<T, C> {
    protected final Cell<C> cell;
    protected FieldUpdater<T, C> fieldUpdater;
    protected Map<Object, Object> viewDataMap = new HashMap<Object, Object>();
    private final DelayedValueUpdater<C> delayedValueUpdater = new DelayedValueUpdater();

    public Column(Cell<C> cell) {
        this.cell = cell;
    }

    public boolean consumesEvents() {
        return this.cell.consumesEvents();
    }

    public boolean dependsOnSelection() {
        return false;
    }

    @Override
    public Cell<C> getCell() {
        return this.cell;
    }

    @Override
    public FieldUpdater<T, C> getFieldUpdater() {
        return this.fieldUpdater;
    }

    @Override
    public abstract C getValue(T var1);

    @Override
    public Object getViewData(Object key) {
        return this.viewDataMap.get(key);
    }

    public void onBrowserEvent(Element elem, int index, T object, NativeEvent event, ProvidesKey<T> providesKey) {
        Object key = this.getKey(object, providesKey);
        Object viewData = this.getViewData(key);
        this.delayedValueUpdater.reset();
        Object newViewData = this.cell.onBrowserEvent(elem, this.getValue(object), viewData, event, this.fieldUpdater == null ? null : this.delayedValueUpdater);
        if (newViewData != viewData) {
            this.setViewData(key, newViewData);
        }
        if (this.delayedValueUpdater.hasNewValue()) {
            this.fieldUpdater.update(index, object, this.delayedValueUpdater.getNewValue());
        }
    }

    public void render(T object, ProvidesKey<T> keyProvider, StringBuilder sb) {
        Object key = this.getKey(object, keyProvider);
        this.cell.render(this.getValue(object), this.getViewData(key), sb);
    }

    public void setFieldUpdater(FieldUpdater<T, C> fieldUpdater) {
        this.fieldUpdater = fieldUpdater;
    }

    @Override
    public void setViewData(Object key, Object viewData) {
        if (viewData == null) {
            this.viewDataMap.remove(key);
        } else {
            this.viewDataMap.put(key, viewData);
        }
    }

    private Object getKey(T object, ProvidesKey<T> keyProvider) {
        return keyProvider == null ? object : keyProvider.getKey(object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelayedValueUpdater<C>
    implements ValueUpdater<C> {
        private C newValue;
        private boolean hasNewValue;

        private DelayedValueUpdater() {
        }

        public C getNewValue() {
            return this.newValue;
        }

        public boolean hasNewValue() {
            return this.hasNewValue;
        }

        public void reset() {
            this.newValue = null;
            this.hasNewValue = false;
        }

        @Override
        public void update(C value) {
            this.hasNewValue = true;
            this.newValue = value;
        }
    }
}

