/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.view.client.PagingListView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageSizePager<T>
extends Composite
implements PagingListView.Pager<T> {
    private final int increment;
    private final FlexTable layout = new FlexTable();
    private final Anchor showMoreButton = new Anchor("Show More");
    private final Anchor showLessButton = new Anchor("Show Less");

    @UiConstructor
    public PageSizePager(final PagingListView<T> listView, final int increment) {
        this.increment = increment;
        this.initWidget(this.layout);
        this.layout.setCellPadding(0);
        this.layout.setCellSpacing(0);
        this.showMoreButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                int pageSize = Math.min(listView.getPageSize() + increment, listView.getDataSize());
                listView.setPageSize(pageSize);
            }
        });
        this.showLessButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                int pageSize = Math.max(listView.getPageSize() - increment, increment);
                listView.setPageSize(pageSize);
            }
        });
        this.layout.setWidget(0, 0, this.showLessButton);
        this.layout.setText(0, 1, " | ");
        this.layout.setWidget(0, 2, this.showMoreButton);
        listView.setPager(this);
        this.onRangeOrSizeChanged(listView);
    }

    @Override
    public void onRangeOrSizeChanged(PagingListView<T> listView) {
        boolean hasLess = listView.getPageSize() > this.increment;
        boolean hasMore = listView.getPageSize() < listView.getDataSize();
        this.showLessButton.setVisible(hasLess);
        this.showMoreButton.setVisible(hasMore);
        this.layout.setText(0, 1, hasLess && hasMore ? " | " : "");
    }
}

