/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.user.cellview.client.AbstractPager;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.view.client.PagingListView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePager<T>
extends AbstractPager<T> {
    private static Resources DEFAULT_RESOURCES;
    private final Image fastForward;
    private final int fastForwardPages;
    private final Image firstPage;
    private final HTML label = new HTML();
    private final Image lastPage;
    private boolean nextDisabled;
    private final Image nextPage;
    private boolean prevDisabled;
    private final Image prevPage;
    private final Resources resources;
    private boolean showLastPageButton;
    private boolean showFastForwardButton;
    private final Style style;

    private static Resources getDefaultResources() {
        if (DEFAULT_RESOURCES == null) {
            DEFAULT_RESOURCES = (Resources)GWT.create(Resources.class);
        }
        return DEFAULT_RESOURCES;
    }

    public SimplePager(PagingListView<T> view) {
        this(view, TextLocation.CENTER);
    }

    @UiConstructor
    public SimplePager(PagingListView<T> view, TextLocation location) {
        this(view, location, SimplePager.getDefaultResources(), true, 1000 / view.getPageSize(), false);
    }

    public SimplePager(final PagingListView<T> view, TextLocation location, Resources resources, boolean showFastForwardButton, final int fastForwardPages, boolean showLastPageButton) {
        super(view);
        this.resources = resources;
        this.showFastForwardButton = showFastForwardButton;
        this.fastForwardPages = fastForwardPages;
        this.showLastPageButton = showLastPageButton;
        this.style = resources.simplePagerStyle();
        this.style.ensureInjected();
        this.fastForward = new Image(resources.simplePagerFastForward());
        this.firstPage = new Image(resources.simplePagerFirstPage());
        this.lastPage = new Image(resources.simplePagerLastPage());
        this.nextPage = new Image(resources.simplePagerNextPage());
        this.prevPage = new Image(resources.simplePagerPreviousPage());
        this.fastForward.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SimplePager.this.setPageStart(view.getPageStart() + view.getPageSize() * fastForwardPages);
            }
        });
        this.firstPage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SimplePager.this.firstPage();
            }
        });
        this.lastPage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SimplePager.this.lastPage();
            }
        });
        this.nextPage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SimplePager.this.nextPage();
            }
        });
        this.prevPage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SimplePager.this.previousPage();
            }
        });
        HorizontalPanel layout = new HorizontalPanel();
        layout.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.initWidget(layout);
        if (location == TextLocation.RIGHT) {
            layout.add(this.label);
        }
        layout.add(this.firstPage);
        layout.add(this.prevPage);
        if (location == TextLocation.CENTER) {
            layout.add(this.label);
        }
        layout.add(this.nextPage);
        if (showFastForwardButton) {
            layout.add(this.fastForward);
        }
        if (showLastPageButton) {
            layout.add(this.lastPage);
        }
        if (location == TextLocation.LEFT) {
            layout.add(this.label);
        }
        this.fastForward.getElement().getParentElement().addClassName(this.style.button());
        this.firstPage.getElement().getParentElement().addClassName(this.style.button());
        this.prevPage.getElement().getParentElement().addClassName(this.style.button());
        this.label.getElement().getParentElement().addClassName(this.style.pageDetails());
        this.nextPage.getElement().getParentElement().addClassName(this.style.button());
        this.lastPage.getElement().getParentElement().addClassName(this.style.button());
    }

    @Override
    public void onRangeOrSizeChanged(PagingListView<T> listView) {
        super.onRangeOrSizeChanged(listView);
        this.label.setText(this.createText());
        boolean hasPrev = this.hasPreviousPage();
        if (hasPrev && this.prevDisabled) {
            this.prevDisabled = false;
            this.firstPage.setResource(this.resources.simplePagerFirstPage());
            this.prevPage.setResource(this.resources.simplePagerPreviousPage());
            this.firstPage.getElement().getParentElement().removeClassName(this.style.disabledButton());
            this.prevPage.getElement().getParentElement().removeClassName(this.style.disabledButton());
        } else if (!hasPrev && !this.prevDisabled) {
            this.prevDisabled = true;
            this.firstPage.setResource(this.resources.simplePagerFirstPageDisabled());
            this.prevPage.setResource(this.resources.simplePagerPreviousPageDisabled());
            this.firstPage.getElement().getParentElement().addClassName(this.style.disabledButton());
            this.prevPage.getElement().getParentElement().addClassName(this.style.disabledButton());
        }
        if (this.isRangeLimited() || !listView.isDataSizeExact()) {
            boolean hasNext = this.hasNextPage();
            if (hasNext && this.nextDisabled) {
                this.nextDisabled = false;
                this.nextPage.setResource(this.resources.simplePagerNextPage());
                this.lastPage.setResource(this.resources.simplePagerLastPage());
                this.nextPage.getElement().getParentElement().removeClassName(this.style.disabledButton());
                if (this.showLastPageButton) {
                    this.lastPage.getElement().getParentElement().removeClassName(this.style.disabledButton());
                }
            } else if (!hasNext && !this.nextDisabled) {
                this.nextDisabled = true;
                this.nextPage.setResource(this.resources.simplePagerNextPageDisabled());
                this.lastPage.setResource(this.resources.simplePagerLastPageDisabled());
                this.nextPage.getElement().getParentElement().addClassName(this.style.disabledButton());
                if (this.showLastPageButton) {
                    this.lastPage.getElement().getParentElement().addClassName(this.style.disabledButton());
                }
            }
            if (this.showFastForwardButton) {
                if (this.hasNextPages(this.fastForwardPages)) {
                    this.fastForward.setResource(this.resources.simplePagerFastForward());
                    this.fastForward.getElement().getParentElement().removeClassName(this.style.disabledButton());
                } else {
                    this.fastForward.setResource(this.resources.simplePagerFastForwardDisabled());
                    this.fastForward.getElement().getParentElement().addClassName(this.style.disabledButton());
                }
            }
        }
    }

    public void startLoading() {
        this.getPagingListView().setDataSize(0, true);
        this.label.setHTML("");
    }

    protected String createText() {
        NumberFormat formatter = NumberFormat.getFormat("#,###");
        PagingListView view = this.getPagingListView();
        int pageStart = view.getPageStart() + 1;
        int pageSize = view.getPageSize();
        int dataSize = view.getDataSize();
        int endIndex = Math.min(dataSize, pageStart + pageSize - 1);
        endIndex = Math.max(pageStart, endIndex);
        boolean exact = view.isDataSizeExact();
        return formatter.format(pageStart) + "-" + formatter.format(endIndex) + (exact ? " of " : " of over ") + formatter.format(dataSize);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextLocation {
        CENTER,
        LEFT,
        RIGHT;

    }

    public static interface Style
    extends CssResource {
        public String button();

        public String disabledButton();

        public String pageDetails();
    }

    public static interface Resources
    extends ClientBundle {
        public ImageResource simplePagerFastForward();

        public ImageResource simplePagerFastForwardDisabled();

        public ImageResource simplePagerFirstPage();

        public ImageResource simplePagerFirstPageDisabled();

        public ImageResource simplePagerLastPage();

        public ImageResource simplePagerLastPageDisabled();

        public ImageResource simplePagerNextPage();

        public ImageResource simplePagerNextPageDisabled();

        public ImageResource simplePagerPreviousPage();

        public ImageResource simplePagerPreviousPageDisabled();

        @ClientBundle.Source(value={"SimplePager.css"})
        public Style simplePagerStyle();
    }
}

