/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.InsertPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;

public class StackPanel
extends ComplexPanel
implements InsertPanel {
    private static final String DEFAULT_STYLENAME = "gwt-StackPanel";
    private static final String DEFAULT_ITEM_STYLENAME = "gwt-StackPanelItem";
    private Element body;
    private int visibleStack = -1;

    public StackPanel() {
        Element table = DOM.createTable();
        this.setElement(table);
        this.body = DOM.createTBody();
        DOM.appendChild(table, this.body);
        DOM.setElementPropertyInt(table, "cellSpacing", 0);
        DOM.setElementPropertyInt(table, "cellPadding", 0);
        DOM.sinkEvents(table, 1);
        this.setStyleName(DEFAULT_STYLENAME);
    }

    public void add(Widget w) {
        this.insert(w, this.getWidgetCount());
    }

    public void add(Widget w, String stackText) {
        this.add(w, stackText, false);
    }

    public void add(Widget w, String stackText, boolean asHTML) {
        this.add(w);
        this.setStackText(this.getWidgetCount() - 1, stackText, asHTML);
    }

    public int getSelectedIndex() {
        return this.visibleStack;
    }

    public void insert(Widget w, int beforeIndex) {
        Element trh = DOM.createTR();
        Element tdh = DOM.createTD();
        DOM.appendChild(trh, tdh);
        DOM.appendChild(tdh, this.createHeaderElem());
        Element trb = DOM.createTR();
        Element tdb = DOM.createTD();
        DOM.appendChild(trb, tdb);
        beforeIndex = this.adjustIndex(w, beforeIndex);
        int effectiveIndex = beforeIndex * 2;
        DOM.insertChild(this.body, trb, effectiveIndex);
        DOM.insertChild(this.body, trh, effectiveIndex);
        StackPanel.setStyleName(tdh, DEFAULT_ITEM_STYLENAME, true);
        DOM.setElementPropertyInt(tdh, "__owner", this.hashCode());
        DOM.setElementProperty(tdh, "height", "1px");
        StackPanel.setStyleName(tdb, "gwt-StackPanelContent", true);
        DOM.setElementProperty(tdb, "height", "100%");
        DOM.setElementProperty(tdb, "vAlign", "top");
        this.insert(w, tdb, beforeIndex, false);
        this.updateIndicesFrom(beforeIndex);
        if (this.visibleStack == -1) {
            this.showStack(0);
        } else {
            this.setStackVisible(beforeIndex, false);
            if (this.visibleStack >= beforeIndex) {
                ++this.visibleStack;
            }
            this.setStackVisible(this.visibleStack, true);
        }
    }

    public void onBrowserEvent(Event event) {
        Element target;
        int index;
        if (DOM.eventGetType(event) == 1 && (index = this.findDividerIndex(target = DOM.eventGetTarget(event))) != -1) {
            this.showStack(index);
        }
        super.onBrowserEvent(event);
    }

    public boolean remove(int index) {
        return this.remove(this.getWidget(index), index);
    }

    public boolean remove(Widget child) {
        return this.remove(child, this.getWidgetIndex(child));
    }

    public void setStackText(int index, String text) {
        this.setStackText(index, text, false);
    }

    public void setStackText(int index, String text, boolean asHTML) {
        if (index >= this.getWidgetCount()) {
            return;
        }
        Element tdWrapper = DOM.getChild(DOM.getChild(this.body, index * 2), 0);
        Element headerElem = DOM.getFirstChild(tdWrapper);
        if (asHTML) {
            DOM.setInnerHTML(this.getHeaderTextElem(headerElem), text);
        } else {
            DOM.setInnerText(this.getHeaderTextElem(headerElem), text);
        }
    }

    public void showStack(int index) {
        if (index >= this.getWidgetCount() || index < 0 || index == this.visibleStack) {
            return;
        }
        if (this.visibleStack >= 0) {
            this.setStackVisible(this.visibleStack, false);
        }
        this.visibleStack = index;
        this.setStackVisible(this.visibleStack, true);
    }

    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        int numHeaders = DOM.getChildCount(this.body) >> 1;
        for (int i = 0; i < numHeaders; ++i) {
            Element tdWrapper = DOM.getFirstChild(DOM.getChild(this.body, 2 * i));
            Element headerElem = DOM.getFirstChild(tdWrapper);
            Element bodyElem = DOM.getFirstChild(DOM.getChild(this.body, 2 * i + 1));
            StackPanel.ensureDebugId(tdWrapper, baseID, "text-wrapper" + i);
            StackPanel.ensureDebugId(bodyElem, baseID, "content" + i);
            StackPanel.ensureDebugId(this.getHeaderTextElem(headerElem), baseID, "text" + i);
        }
    }

    Element createHeaderElem() {
        return DOM.createDiv();
    }

    Element getHeaderTextElem(Element headerElem) {
        return headerElem;
    }

    private int findDividerIndex(Element elem) {
        while (elem != null && elem != this.getElement()) {
            String expando = DOM.getElementProperty(elem, "__index");
            if (expando != null) {
                int ownerHash = DOM.getElementPropertyInt(elem, "__owner");
                if (ownerHash == this.hashCode()) {
                    return Integer.parseInt(expando);
                }
                return -1;
            }
            elem = DOM.getParent(elem);
        }
        return -1;
    }

    private boolean remove(Widget child, int index) {
        boolean removed = super.remove(child);
        if (removed) {
            int rowIndex = 2 * index;
            Element tr = DOM.getChild(this.body, rowIndex);
            DOM.removeChild(this.body, tr);
            tr = DOM.getChild(this.body, rowIndex);
            DOM.removeChild(this.body, tr);
            if (this.visibleStack == index) {
                this.visibleStack = -1;
            } else if (this.visibleStack > index) {
                --this.visibleStack;
            }
            this.updateIndicesFrom(index);
        }
        return removed;
    }

    private void setStackContentVisible(int index, boolean visible) {
        Element tr = DOM.getChild(this.body, index * 2 + 1);
        UIObject.setVisible(tr, visible);
        this.getWidget(index).setVisible(visible);
    }

    private void setStackVisible(int index, boolean visible) {
        Element tr = DOM.getChild(this.body, index * 2);
        if (tr == null) {
            return;
        }
        Element td = DOM.getFirstChild(tr);
        StackPanel.setStyleName(td, "gwt-StackPanelItem-selected", visible);
        this.setStackContentVisible(index, visible);
        Element trNext = DOM.getChild(this.body, (index + 1) * 2);
        if (trNext != null) {
            Element tdNext = DOM.getFirstChild(trNext);
            StackPanel.setStyleName(tdNext, "gwt-StackPanelItem-below-selected", visible);
        }
    }

    private void updateIndicesFrom(int beforeIndex) {
        int c = this.getWidgetCount();
        for (int i = beforeIndex; i < c; ++i) {
            Element childTR = DOM.getChild(this.body, i * 2);
            Element childTD = DOM.getFirstChild(childTR);
            DOM.setElementPropertyInt(childTD, "__index", i);
            if (beforeIndex == 0) {
                StackPanel.setStyleName(childTD, "gwt-StackPanelItem-first", true);
                continue;
            }
            StackPanel.setStyleName(childTD, "gwt-StackPanelItem-first", false);
        }
    }
}

