/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.view.client;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.view.client.AbstractListViewAdapter;
import com.google.gwt.view.client.ListView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListViewAdapter<T>
extends AbstractListViewAdapter<T> {
    private ListWrapper listWrapper;

    public ListViewAdapter() {
        this(new ArrayList());
    }

    public ListViewAdapter(List<T> wrappee) {
        this.listWrapper = new ListWrapper(wrappee);
    }

    public List<T> getList() {
        return this.listWrapper;
    }

    public void refresh() {
        this.updateViewData(0, this.listWrapper.size(), this.listWrapper);
    }

    public void setList(List<T> wrappee) {
        this.listWrapper = new ListWrapper(wrappee);
        this.listWrapper.flush();
    }

    @Override
    protected void onRangeChanged(ListView<T> view) {
        this.updateViewData(view, 0, this.listWrapper.size(), this.listWrapper);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListWrapper
    implements List<T> {
        private int curSize = 0;
        private Command flushCommand = new Command(){

            public void execute() {
                ListWrapper.this.flushPending = false;
                int newSize = ListWrapper.this.list.size();
                if (ListWrapper.this.curSize != newSize) {
                    ListWrapper.this.curSize = newSize;
                    ListViewAdapter.this.updateDataSize(ListWrapper.this.curSize, true);
                }
                if (ListWrapper.this.modified) {
                    int length = ListWrapper.this.maxModified - ListWrapper.this.minModified;
                    ListViewAdapter.this.updateViewData(ListWrapper.this.minModified, length, ListWrapper.this.list.subList(ListWrapper.this.minModified, ListWrapper.this.maxModified));
                    ListWrapper.this.modified = false;
                }
                ListWrapper.this.minModified = Integer.MAX_VALUE;
                ListWrapper.this.maxModified = Integer.MIN_VALUE;
            }
        };
        private boolean flushPending;
        private List<T> list;
        private int maxModified;
        private int minModified;
        private boolean modified;

        public ListWrapper(List<T> list) {
            this.list = list;
            this.minModified = 0;
            this.maxModified = list.size();
            this.modified = true;
        }

        @Override
        public void add(int index, T element) {
            try {
                this.list.add(index, element);
                this.minModified = Math.min(this.minModified, index);
                this.maxModified = this.size();
                this.modified = true;
                this.flush();
            }
            catch (IndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException(e.getMessage());
            }
        }

        @Override
        public boolean add(T e) {
            boolean toRet = this.list.add(e);
            this.minModified = Math.min(this.minModified, this.size() - 1);
            this.maxModified = this.size();
            this.modified = true;
            return this.flush(toRet);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            this.minModified = Math.min(this.minModified, this.size());
            boolean toRet = this.list.addAll(c);
            this.maxModified = this.size();
            this.modified = true;
            return this.flush(toRet);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            try {
                boolean toRet = this.list.addAll(index, c);
                this.minModified = Math.min(this.minModified, index);
                this.maxModified = this.size();
                this.modified = true;
                return this.flush(toRet);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException(e.getMessage());
            }
        }

        @Override
        public void clear() {
            this.list.clear();
            this.maxModified = 0;
            this.minModified = 0;
            this.modified = true;
            this.flush();
        }

        @Override
        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.list.containsAll(c);
        }

        @Override
        public boolean equals(Object o) {
            return ((Object)this.list).equals(o);
        }

        @Override
        public T get(int index) {
            return this.list.get(index);
        }

        @Override
        public int hashCode() {
            return ((Object)this.list).hashCode();
        }

        @Override
        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return this.list.iterator();
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        @Override
        public ListIterator<T> listIterator() {
            return new WrappedListIterator();
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            return new WrappedListIterator(index);
        }

        @Override
        public T remove(int index) {
            try {
                Object toRet = this.list.remove(index);
                this.minModified = Math.min(this.minModified, index);
                this.maxModified = this.size();
                this.modified = true;
                this.flush();
                return toRet;
            }
            catch (IndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException(e.getMessage());
            }
        }

        @Override
        public boolean remove(Object o) {
            int index = this.indexOf(o);
            if (index == -1) {
                return false;
            }
            this.remove(index);
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean toRet = this.list.removeAll(c);
            this.minModified = 0;
            this.maxModified = this.size();
            this.modified = true;
            return this.flush(toRet);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            boolean toRet = this.list.retainAll(c);
            this.minModified = 0;
            this.maxModified = this.size();
            this.modified = true;
            return this.flush(toRet);
        }

        @Override
        public T set(int index, T element) {
            Object toRet = this.list.set(index, element);
            this.minModified = Math.min(this.minModified, index);
            this.maxModified = Math.max(this.maxModified, index + 1);
            this.modified = true;
            this.flush();
            return toRet;
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            return this.list.subList(fromIndex, toIndex);
        }

        @Override
        public Object[] toArray() {
            return this.list.toArray();
        }

        @Override
        public <C> C[] toArray(C[] a) {
            return this.list.toArray(a);
        }

        private void flush() {
            if (!this.flushPending) {
                this.flushPending = true;
                DeferredCommand.addCommand(this.flushCommand);
            }
        }

        private boolean flush(boolean toRet) {
            this.flush();
            return toRet;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class WrappedListIterator
        implements ListIterator<T> {
            int i = 0;
            int last = -1;

            private WrappedListIterator() {
            }

            private WrappedListIterator(int start) {
                int size = ListWrapper.this.size();
                if (start < 0 || start > size) {
                    throw new IndexOutOfBoundsException("Index: " + start + ", Size: " + size);
                }
                this.i = start;
            }

            @Override
            public void add(T o) {
                ListWrapper.this.add(this.i++, o);
                this.last = -1;
            }

            @Override
            public boolean hasNext() {
                return this.i < ListWrapper.this.size();
            }

            @Override
            public boolean hasPrevious() {
                return this.i > 0;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.i++;
                return ListWrapper.this.get(this.last);
            }

            @Override
            public int nextIndex() {
                return this.i;
            }

            @Override
            public T previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.i;
                return ListWrapper.this.get(this.i);
            }

            @Override
            public int previousIndex() {
                return this.i - 1;
            }

            @Override
            public void remove() {
                if (this.last < 0) {
                    throw new IllegalStateException();
                }
                ListWrapper.this.remove(this.last);
                this.i = this.last;
                this.last = -1;
            }

            @Override
            public void set(T o) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                ListWrapper.this.set(this.last, o);
            }
        }
    }
}

