/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.requestfactory.client.impl;

import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.editor.client.impl.AbstractEditorDelegate;
import com.google.gwt.editor.client.impl.DelegateMap;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.requestfactory.client.RequestFactoryEditorDriver;
import com.google.gwt.requestfactory.client.impl.RequestFactoryEditorDelegate;
import com.google.gwt.requestfactory.shared.EntityProxy;
import com.google.gwt.requestfactory.shared.RequestContext;
import com.google.gwt.requestfactory.shared.RequestFactory;
import com.google.gwt.requestfactory.shared.Violation;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRequestFactoryEditorDriver<R, E extends Editor<R>>
implements RequestFactoryEditorDriver<R, E> {
    private static final DelegateMap.KeyMethod PROXY_ID_KEY = new DelegateMap.KeyMethod(){

        public Object key(Object object) {
            if (object instanceof EntityProxy) {
                return ((EntityProxy)object).stableId();
            }
            return null;
        }
    };
    private RequestFactoryEditorDelegate<R, E> delegate;
    private DelegateMap delegateMap = new DelegateMap(PROXY_ID_KEY);
    private E editor;
    private EventBus eventBus;
    private List<EditorError> errors;
    private List<String> paths = new ArrayList<String>();
    private RequestFactory requestFactory;
    private RequestContext saveRequest;

    @Override
    public void display(R object) {
        this.edit(object, (RequestContext)null);
    }

    @Override
    public void edit(R object, RequestContext saveRequest) {
        this.checkEditor();
        this.saveRequest = saveRequest;
        this.delegate = this.createDelegate();
        this.delegate.initialize(this.eventBus, this.requestFactory, "", object, this.editor, this.delegateMap, saveRequest);
        this.delegateMap.put(object, this.delegate);
    }

    @Override
    public RequestContext flush() {
        this.checkDelegate();
        this.checkSaveRequest();
        this.errors = new ArrayList<EditorError>();
        this.delegate.flush(this.errors);
        return this.saveRequest;
    }

    @Override
    public List<EditorError> getErrors() {
        return this.errors;
    }

    @Override
    public String[] getPaths() {
        return this.paths.toArray(new String[this.paths.size()]);
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    @Override
    public void initialize(E editor) {
        this.doInitialize(null, null, editor);
    }

    @Override
    public void initialize(EventBus eventBus, RequestFactory requestFactory, E editor) {
        assert (eventBus != null) : "eventBus must not be null";
        assert (requestFactory != null) : "requestFactory must not be null";
        this.doInitialize(eventBus, requestFactory, editor);
    }

    @Override
    public void initialize(RequestFactory requestFactory, E editor) {
        this.initialize(requestFactory.getEventBus(), requestFactory, editor);
    }

    @Override
    public boolean setViolations(Iterable<Violation> violations) {
        this.checkDelegate();
        for (Violation error : violations) {
            List<AbstractEditorDelegate<?, ?>> delegateList = this.delegateMap.getRaw(error.getProxyId());
            if (delegateList == null) continue;
            for (AbstractEditorDelegate<?, ?> baseDelegate : delegateList) {
                String basePath = baseDelegate.getPath();
                String absolutePath = (basePath.length() > 0 ? basePath + "." : "") + error.getPath();
                List<AbstractEditorDelegate<?, ?>> leafDelegates = this.delegateMap.getPath(absolutePath);
                if (leafDelegates != null) {
                    leafDelegates.get(0).recordError(error.getMessage(), null, error);
                    continue;
                }
                baseDelegate.recordError(error.getMessage(), null, error, error.getPath());
            }
        }
        this.errors = new ArrayList<EditorError>();
        this.delegate.flushErrors(this.errors);
        return !this.errors.isEmpty();
    }

    protected abstract RequestFactoryEditorDelegate<R, E> createDelegate();

    protected E getEditor() {
        return this.editor;
    }

    protected abstract void traverseEditors(List<String> var1);

    private void checkDelegate() {
        if (this.delegate == null) {
            throw new IllegalStateException("Must call edit() first");
        }
    }

    private void checkEditor() {
        if (this.editor == null) {
            throw new IllegalStateException("Must call initialize() first");
        }
    }

    private void checkSaveRequest() {
        if (this.saveRequest == null) {
            throw new IllegalStateException("edit() was called with a null Request");
        }
    }

    private void doInitialize(EventBus eventBus, RequestFactory requestFactory, E editor) {
        this.eventBus = eventBus;
        this.requestFactory = requestFactory;
        this.editor = editor;
        this.traverseEditors(this.paths);
    }
}

