/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.requestfactory.server;

import com.google.gwt.autobean.server.AutoBeanFactoryMagic;
import com.google.gwt.autobean.server.Configuration;
import com.google.gwt.autobean.server.impl.TypeUtils;
import com.google.gwt.autobean.shared.AutoBean;
import com.google.gwt.autobean.shared.AutoBeanCodex;
import com.google.gwt.autobean.shared.AutoBeanFactory;
import com.google.gwt.autobean.shared.AutoBeanUtils;
import com.google.gwt.autobean.shared.AutoBeanVisitor;
import com.google.gwt.autobean.shared.Splittable;
import com.google.gwt.autobean.shared.ValueCodex;
import com.google.gwt.requestfactory.server.DefaultExceptionHandler;
import com.google.gwt.requestfactory.server.ExceptionHandler;
import com.google.gwt.requestfactory.server.ReportableException;
import com.google.gwt.requestfactory.server.RequestState;
import com.google.gwt.requestfactory.server.ServiceLayer;
import com.google.gwt.requestfactory.server.UnexpectedException;
import com.google.gwt.requestfactory.shared.BaseProxy;
import com.google.gwt.requestfactory.shared.EntityProxyId;
import com.google.gwt.requestfactory.shared.InstanceRequest;
import com.google.gwt.requestfactory.shared.Request;
import com.google.gwt.requestfactory.shared.ServerFailure;
import com.google.gwt.requestfactory.shared.WriteOperation;
import com.google.gwt.requestfactory.shared.impl.BaseProxyCategory;
import com.google.gwt.requestfactory.shared.impl.EntityCodex;
import com.google.gwt.requestfactory.shared.impl.EntityProxyCategory;
import com.google.gwt.requestfactory.shared.impl.SimpleProxyId;
import com.google.gwt.requestfactory.shared.impl.ValueProxyCategory;
import com.google.gwt.requestfactory.shared.messages.IdMessage;
import com.google.gwt.requestfactory.shared.messages.InvocationMessage;
import com.google.gwt.requestfactory.shared.messages.MessageFactory;
import com.google.gwt.requestfactory.shared.messages.OperationMessage;
import com.google.gwt.requestfactory.shared.messages.RequestMessage;
import com.google.gwt.requestfactory.shared.messages.ResponseMessage;
import com.google.gwt.requestfactory.shared.messages.ServerFailureMessage;
import com.google.gwt.requestfactory.shared.messages.ViolationMessage;
import com.google.gwt.user.server.Base64Utils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRequestProcessor {
    static final Configuration CONFIGURATION = new Configuration.Builder().setCategories(EntityProxyCategory.class, ValueProxyCategory.class, BaseProxyCategory.class).setNoWrap(EntityProxyId.class).build();
    static final MessageFactory FACTORY = AutoBeanFactoryMagic.create(MessageFactory.class);
    private ExceptionHandler exceptionHandler = new DefaultExceptionHandler();
    private final ServiceLayer service;

    static String fromBase64(String encoded) {
        try {
            return new String(Base64Utils.fromBase64(encoded), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnexpectedException(e);
        }
    }

    static String toBase64(String data) {
        try {
            return Base64Utils.toBase64(data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new UnexpectedException(e);
        }
    }

    public SimpleRequestProcessor(ServiceLayer serviceLayer) {
        this.service = serviceLayer;
    }

    public String process(String payload) {
        RequestMessage req = AutoBeanCodex.decode((AutoBeanFactory)FACTORY, RequestMessage.class, payload).as();
        AutoBean<ResponseMessage> responseBean = FACTORY.response();
        try {
            this.process(req, responseBean.as());
        }
        catch (ReportableException e) {
            e.printStackTrace();
            responseBean = FACTORY.response();
            responseBean.as().setGeneralFailure(this.createFailureMessage(e).as());
        }
        return AutoBeanCodex.encode(responseBean).getPayload();
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    <T> Splittable createOobMessage(List<T> domainValues) {
        RequestState state = new RequestState(this.service);
        ArrayList<Splittable> encodedValues = new ArrayList<Splittable>(domainValues.size());
        for (T domainValue : domainValues) {
            Object clientValue;
            if (domainValue == null) {
                clientValue = null;
            } else {
                Class<BaseProxy> clientType = this.service.resolveClientType(domainValue.getClass(), BaseProxy.class, true);
                clientValue = state.getResolver().resolveClientValue(domainValue, clientType, Collections.<String>emptySet());
            }
            encodedValues.add(EntityCodex.encode(state, clientValue));
        }
        IdToEntityMap map = new IdToEntityMap();
        map.putAll(state.beans);
        ArrayList<OperationMessage> operations = new ArrayList<OperationMessage>();
        this.createReturnOperations(operations, state, map);
        InvocationMessage invocation = FACTORY.invocation().as();
        invocation.setParameters(encodedValues);
        AutoBean<RequestMessage> bean = FACTORY.request();
        RequestMessage resp = bean.as();
        resp.setInvocations(Collections.singletonList(invocation));
        resp.setOperations(operations);
        return AutoBeanCodex.encode(bean);
    }

    <T> List<T> decodeOobMessage(Class<T> domainClass, Splittable payload) {
        List<Object> decoded;
        Class<BaseProxy> proxyType = this.service.resolveClientType(domainClass, BaseProxy.class, true);
        RequestState state = new RequestState(this.service);
        RequestMessage message = AutoBeanCodex.decode((AutoBeanFactory)FACTORY, RequestMessage.class, payload).as();
        this.processOperationMessages(state, message);
        List<Object> toReturn = decoded = this.decodeInvocationArguments(state, message.getInvocations().get(0).getParameters(), new Class[]{proxyType}, new Type[]{domainClass});
        return toReturn;
    }

    void process(RequestMessage req, ResponseMessage resp) {
        RequestState source = new RequestState(this.service);
        this.processOperationMessages(source, req);
        List<ViolationMessage> errorMessages = this.validateEntities(source);
        if (!errorMessages.isEmpty()) {
            resp.setViolations(errorMessages);
            return;
        }
        RequestState returnState = new RequestState(source);
        ArrayList<Splittable> invocationResults = new ArrayList<Splittable>();
        ArrayList<Boolean> invocationSuccess = new ArrayList<Boolean>();
        List<InvocationMessage> invlist = req.getInvocations();
        this.processInvocationMessages(source, invlist, invocationResults, invocationSuccess, returnState);
        ArrayList<OperationMessage> operations = new ArrayList<OperationMessage>();
        IdToEntityMap toProcess = new IdToEntityMap();
        toProcess.putAll(source.beans);
        toProcess.putAll(returnState.beans);
        this.createReturnOperations(operations, returnState, toProcess);
        resp.setInvocationResults(invocationResults);
        resp.setStatusCodes(invocationSuccess);
        if (!operations.isEmpty()) {
            resp.setOperations(operations);
        }
    }

    private AutoBean<ServerFailureMessage> createFailureMessage(ReportableException e) {
        ServerFailure failure = this.exceptionHandler.createServerFailure(e.getCause() == null ? e : e.getCause());
        AutoBean<ServerFailureMessage> bean = FACTORY.failure();
        ServerFailureMessage msg = bean.as();
        msg.setExceptionType(failure.getExceptionType());
        msg.setMessage(failure.getMessage());
        msg.setStackTrace(failure.getStackTraceString());
        msg.setFatal(failure.isFatal());
        return bean;
    }

    private void createReturnOperations(List<OperationMessage> operations, RequestState returnState, IdToEntityMap toProcess) {
        for (Map.Entry entry : toProcess.entrySet()) {
            boolean inResponse;
            SimpleProxyId id = (SimpleProxyId)entry.getKey();
            AutoBean bean = (AutoBean)entry.getValue();
            Object domainObject = bean.getTag("domainObject");
            if (id.isEphemeral()) {
                returnState.getResolver().resolveClientValue(domainObject, id.getProxyClass(), Collections.<String>emptySet());
            }
            WriteOperation writeOperation = id.isEphemeral() || id.isSynthetic() || domainObject == null ? null : (!this.service.isLive(domainObject) ? WriteOperation.DELETE : (id.wasEphemeral() ? WriteOperation.PERSIST : WriteOperation.UPDATE));
            Splittable version = null;
            if (writeOperation == WriteOperation.PERSIST || writeOperation == WriteOperation.UPDATE) {
                Object domainVersion = this.service.getVersion(domainObject);
                if (domainVersion == null) {
                    throw new UnexpectedException("The persisted entity with id " + this.service.getId(domainObject) + " has a null version", null);
                }
                version = returnState.flatten(domainVersion);
            }
            boolean bl = inResponse = bean.getTag("inResponse") != null;
            if (WriteOperation.UPDATE.equals((Object)writeOperation) && !inResponse) {
                String previousVersion = (String)bean.getTag("version");
                if (version != null && previousVersion != null && version.equals(SimpleRequestProcessor.fromBase64(previousVersion))) continue;
            }
            OperationMessage op = FACTORY.operation().as();
            if (id.wasEphemeral()) {
                op.setClientId(id.getClientId());
            }
            op.setOperation(writeOperation);
            if (inResponse) {
                LinkedHashMap<String, Splittable> propertyMap = new LinkedHashMap<String, Splittable>();
                Map<String, Object> diff = AutoBeanUtils.getAllProperties(bean);
                for (Map.Entry<String, Object> d : diff.entrySet()) {
                    Object value = d.getValue();
                    if (value == null) continue;
                    propertyMap.put(d.getKey(), EntityCodex.encode(returnState, value));
                }
                op.setPropertyMap(propertyMap);
            }
            if (!id.isEphemeral() && !id.isSynthetic()) {
                op.setServerId(SimpleRequestProcessor.toBase64(id.getServerId()));
            }
            if (id.isSynthetic()) {
                op.setStrength(IdMessage.Strength.SYNTHETIC);
                op.setSyntheticId(id.getSyntheticId());
            } else if (id.isEphemeral()) {
                op.setStrength(IdMessage.Strength.EPHEMERAL);
            }
            op.setTypeToken(this.service.resolveTypeToken(id.getProxyClass()));
            if (version != null) {
                op.setVersion(SimpleRequestProcessor.toBase64(version.getPayload()));
            }
            operations.add(op);
        }
    }

    private List<Object> decodeInvocationArguments(RequestState source, InvocationMessage invocation, Method contextMethod) {
        boolean isStatic = Request.class.isAssignableFrom(contextMethod.getReturnType());
        int baseLength = contextMethod.getParameterTypes().length;
        int length = baseLength + (isStatic ? 0 : 1);
        int offset = isStatic ? 0 : 1;
        Class[] contextArgs = new Class[length];
        Type[] genericArgs = new Type[length];
        if (!isStatic) {
            genericArgs[0] = TypeUtils.getSingleParameterization(InstanceRequest.class, contextMethod.getGenericReturnType());
            contextArgs[0] = TypeUtils.ensureBaseType(genericArgs[0]);
        }
        System.arraycopy(contextMethod.getParameterTypes(), 0, contextArgs, offset, baseLength);
        System.arraycopy(contextMethod.getGenericParameterTypes(), 0, genericArgs, offset, baseLength);
        List<Object> args = this.decodeInvocationArguments(source, invocation.getParameters(), contextArgs, genericArgs);
        return args;
    }

    private List<Object> decodeInvocationArguments(RequestState source, List<Splittable> parameters, Class<?>[] contextArgs, Type[] genericArgs) {
        if (parameters == null) {
            return new ArrayList<Object>();
        }
        assert (parameters.size() == contextArgs.length);
        ArrayList<Object> args = new ArrayList<Object>(contextArgs.length);
        int j = contextArgs.length;
        for (int i = 0; i < j; ++i) {
            Splittable split;
            Class<?> type = contextArgs[i];
            Class<?> elementType = null;
            if (Collection.class.isAssignableFrom(type)) {
                elementType = TypeUtils.ensureBaseType(TypeUtils.getSingleParameterization(Collection.class, genericArgs[i]));
                split = parameters.get(i);
            } else {
                split = parameters.get(i);
            }
            Object arg = EntityCodex.decode((EntityCodex.EntitySource)source, type, elementType, split);
            arg = source.getResolver().resolveDomainValue(arg, !EntityProxyId.class.equals(contextArgs[i]));
            args.add(arg);
        }
        return args;
    }

    private void processInvocationMessages(RequestState state, List<InvocationMessage> invlist, List<Splittable> results, List<Boolean> success, RequestState returnState) {
        for (InvocationMessage invocation : invlist) {
            try {
                String[] operation = invocation.getOperation().split("::");
                Method contextMethod = this.service.resolveRequestContextMethod(operation[0], operation[1]);
                if (contextMethod == null) {
                    throw new UnexpectedException("Cannot resolve operation " + invocation.getOperation(), null);
                }
                Method domainMethod = this.service.resolveDomainMethod(contextMethod);
                if (domainMethod == null) {
                    throw new UnexpectedException("Cannot resolve domain method " + invocation.getOperation(), null);
                }
                List<Object> args = this.decodeInvocationArguments(state, invocation, contextMethod);
                if (this.service.requiresServiceLocator(contextMethod, domainMethod)) {
                    Object serviceInstance = this.service.createServiceInstance(contextMethod, domainMethod);
                    args.add(0, serviceInstance);
                }
                Object returnValue = this.service.invoke(domainMethod, args.toArray());
                Type requestReturnType = this.service.getRequestReturnType(contextMethod);
                returnValue = state.getResolver().resolveClientValue(returnValue, requestReturnType, invocation.getPropertyRefs());
                results.add(EntityCodex.encode(returnState, returnValue));
                success.add(true);
            }
            catch (ReportableException e) {
                results.add(AutoBeanCodex.encode(this.createFailureMessage(e)));
                success.add(false);
            }
        }
    }

    private void processOperationMessages(final RequestState state, RequestMessage req) {
        List<OperationMessage> operations = req.getOperations();
        if (operations == null) {
            return;
        }
        List<AutoBean<? extends BaseProxy>> beans = state.getBeansForPayload(operations);
        assert (operations.size() == beans.size());
        Iterator<OperationMessage> itOp = operations.iterator();
        for (AutoBean<? extends BaseProxy> bean : beans) {
            Map<String, Splittable> flatValueMap;
            OperationMessage operation = itOp.next();
            bean.setTag("version", operation.getVersion());
            final Object domain = bean.getTag("domainObject");
            if (domain == null || (flatValueMap = operation.getPropertyMap()) == null) continue;
            bean.accept(new AutoBeanVisitor(){

                @Override
                public boolean visitReferenceProperty(String propertyName, AutoBean<?> value, AutoBeanVisitor.PropertyContext ctx) {
                    if (flatValueMap.containsKey(propertyName)) {
                        Class<?> elementType = ctx instanceof AutoBeanVisitor.CollectionPropertyContext ? ((AutoBeanVisitor.CollectionPropertyContext)ctx).getElementType() : null;
                        Object newValue = EntityCodex.decode((EntityCodex.EntitySource)state, ctx.getType(), elementType, (Splittable)flatValueMap.get(propertyName));
                        Object resolved = state.getResolver().resolveDomainValue(newValue, false);
                        SimpleRequestProcessor.this.service.setProperty(domain, propertyName, SimpleRequestProcessor.this.service.resolveDomainClass(ctx.getType()), resolved);
                    }
                    return false;
                }

                @Override
                public boolean visitValueProperty(String propertyName, Object value, AutoBeanVisitor.PropertyContext ctx) {
                    if (flatValueMap.containsKey(propertyName)) {
                        Splittable split = (Splittable)flatValueMap.get(propertyName);
                        Object newValue = ValueCodex.decode(ctx.getType(), split);
                        Object resolved = state.getResolver().resolveDomainValue(newValue, false);
                        SimpleRequestProcessor.this.service.setProperty(domain, propertyName, ctx.getType(), resolved);
                    }
                    return false;
                }
            });
        }
    }

    private List<ViolationMessage> validateEntities(RequestState source) {
        ArrayList<ViolationMessage> errorMessages = new ArrayList<ViolationMessage>();
        for (Map.Entry entry : source.beans.entrySet()) {
            Set errors;
            AutoBean bean = (AutoBean)entry.getValue();
            Object domainObject = bean.getTag("domainObject");
            if (domainObject == null || (errors = this.service.validate(domainObject)) == null || errors.isEmpty()) continue;
            SimpleProxyId id = (SimpleProxyId)entry.getKey();
            for (ConstraintViolation error : errors) {
                ViolationMessage message = FACTORY.violation().as();
                message.setClientId(id.getClientId());
                message.setMessage(error.getMessage());
                message.setPath(error.getPropertyPath().toString());
                if (id.isEphemeral()) {
                    message.setClientId(id.getClientId());
                    message.setStrength(IdMessage.Strength.EPHEMERAL);
                } else {
                    message.setServerId(SimpleRequestProcessor.toBase64(id.getServerId()));
                }
                message.setTypeToken(this.service.resolveTypeToken(id.getProxyClass()));
                errorMessages.add(message);
            }
        }
        return errorMessages;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IdToEntityMap
    extends HashMap<SimpleProxyId<?>, AutoBean<? extends BaseProxy>> {
        IdToEntityMap() {
        }
    }
}

