/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.uibinder.elementparsers.ElementParser;
import com.google.gwt.uibinder.elementparsers.HtmlInterpreter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import com.google.gwt.user.client.ui.DialogBox;

public class DialogBoxParser
implements ElementParser {
    public void parse(XMLElement elem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        String caption = null;
        String body = null;
        for (XMLElement child : elem.consumeChildElements()) {
            if ("caption".equals(child.getLocalName())) {
                if (caption != null) {
                    writer.die(elem, "May have only one <%s:caption>", new Object[]{elem.getPrefix()});
                }
                HtmlInterpreter interpreter = HtmlInterpreter.newInterpreterForUiObject(writer, fieldName);
                caption = child.consumeInnerHtml((XMLElement.Interpreter)interpreter);
                continue;
            }
            if (body != null) {
                writer.die(elem, "May have only one widget, but found %s and %s", new Object[]{body, child});
            }
            if (!writer.isWidgetElement(child)) {
                writer.die(elem, "Found non-widget %s", new Object[]{child});
            }
            body = writer.parseElementToField(child);
        }
        this.handleConstructorArgs(elem, fieldName, type, writer);
        if (caption != null) {
            writer.addStatement("%s.setHTML(\"%s\");", new Object[]{fieldName, caption});
        }
        if (body != null) {
            writer.addStatement("%s.setWidget(%s);", new Object[]{fieldName, body});
        }
    }

    private void handleConstructorArgs(XMLElement elem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        boolean custom;
        boolean bl = custom = !type.equals((Object)writer.getOracle().findType(DialogBox.class.getCanonicalName()));
        if (!custom) {
            String autoHide = elem.consumeBooleanAttribute("autoHide", false);
            String modal = elem.consumeBooleanAttribute("modal", true);
            writer.setFieldInitializerAsConstructor(fieldName, writer.getOracle().findType(DialogBox.class.getCanonicalName()), new String[]{autoHide, modal});
        }
    }
}

