/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.requestfactory.client.impl;

import com.google.gwt.editor.client.AutoBean;
import com.google.gwt.editor.client.AutoBeanFactory;
import com.google.gwt.editor.client.AutoBeanUtils;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.requestfactory.client.DefaultRequestTransport;
import com.google.gwt.requestfactory.client.impl.AbstractRequest;
import com.google.gwt.requestfactory.client.impl.AbstractRequestContext;
import com.google.gwt.requestfactory.client.impl.EntityProxyCategory;
import com.google.gwt.requestfactory.client.impl.SimpleEntityProxyId;
import com.google.gwt.requestfactory.client.impl.messages.RequestData;
import com.google.gwt.requestfactory.shared.EntityProxy;
import com.google.gwt.requestfactory.shared.EntityProxyId;
import com.google.gwt.requestfactory.shared.Request;
import com.google.gwt.requestfactory.shared.RequestFactory;
import com.google.gwt.requestfactory.shared.RequestTransport;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRequestFactory
implements RequestFactory {
    protected static final String EPHEMERAL_SEPARATOR = "@IS@";
    protected static final String TOKEN_SEPARATOR = "@NO@";
    protected static final int ID_TOKEN_INDEX = 0;
    protected static final int TYPE_TOKEN_INDEX = 1;
    private static final int MAX_VERSION_ENTRIES = 10000;
    private EventBus eventBus;
    private final Map<String, SimpleEntityProxyId<?>> ephemeralIds = new HashMap();
    private final Map<String, Integer> version = new LinkedHashMap<String, Integer>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Integer> eldest) {
            return this.size() > 10000;
        }
    };
    private RequestTransport transport;

    public static String getHistoryToken(EntityProxy proxy) {
        AutoBean bean = AutoBeanUtils.getAutoBean(proxy);
        String historyToken = EntityProxyCategory.requestFactory(bean).getHistoryToken(proxy.stableId());
        return historyToken;
    }

    public <P extends EntityProxy> SimpleEntityProxyId<P> allocateId(Class<P> clazz) {
        SimpleEntityProxyId<P> toReturn = new SimpleEntityProxyId<P>(clazz, this.ephemeralIds.size() + 1);
        this.ephemeralIds.put(this.getHistoryToken(toReturn), toReturn);
        return toReturn;
    }

    public <T extends EntityProxy> AutoBean<T> createEntityProxy(Class<T> clazz, SimpleEntityProxyId<T> id) {
        AutoBean<T> created = this.getAutoBeanFactory().create(clazz);
        if (created == null) {
            throw new IllegalArgumentException("Unknown EntityProxy type " + clazz.getName());
        }
        created.setTag("requestFactory", this);
        created.setTag("stableId", id);
        return created;
    }

    @Override
    public <P extends EntityProxy> Request<P> find(final EntityProxyId<P> proxyId) {
        if (((SimpleEntityProxyId)proxyId).isEphemeral()) {
            throw new IllegalArgumentException("Cannot fetch unpersisted entity");
        }
        AbstractRequestContext context = new AbstractRequestContext(this);
        return new AbstractRequest<P>(context){
            {
                super(x0);
                this.requestContext.addInvocation(this);
            }

            @Override
            protected void handleResult(Object result) {
                this.succeed(this.decodeReturnObject(proxyId.getProxyClass(), result));
            }

            @Override
            protected RequestData makeRequestData() {
                return new RequestData("com.google.gwt.requestfactory.client.impl.FindRequest::find", new Object[]{AbstractRequestFactory.this.getHistoryToken(proxyId)}, this.propertyRefs);
            }
        };
    }

    @Override
    public EventBus getEventBus() {
        return this.eventBus;
    }

    @Override
    public String getHistoryToken(Class<? extends EntityProxy> clazz) {
        return this.getTypeToken(clazz);
    }

    @Override
    public String getHistoryToken(EntityProxyId<?> proxy) {
        SimpleEntityProxyId id = (SimpleEntityProxyId)proxy;
        if (id.isEphemeral()) {
            return id.getClientId() + EPHEMERAL_SEPARATOR + this.getHistoryToken(proxy.getProxyClass());
        }
        return id.getServerId() + TOKEN_SEPARATOR + this.getHistoryToken(proxy.getProxyClass());
    }

    @Override
    public Class<? extends EntityProxy> getProxyClass(String historyToken) {
        String[] parts = historyToken.split(TOKEN_SEPARATOR);
        if (parts.length == 2) {
            return this.getTypeFromToken(parts[1]);
        }
        parts = historyToken.split(EPHEMERAL_SEPARATOR);
        if (parts.length == 2) {
            return this.getTypeFromToken(parts[1]);
        }
        return this.getTypeFromToken(historyToken);
    }

    public <P extends EntityProxy> SimpleEntityProxyId<P> getProxyId(String historyToken) {
        String[] parts = historyToken.split(TOKEN_SEPARATOR);
        if (parts.length == 2) {
            return this.getId(parts[1], parts[0]);
        }
        parts = historyToken.split(EPHEMERAL_SEPARATOR);
        if (parts.length == 2) {
            SimpleEntityProxyId<Object> toReturn = this.ephemeralIds.get(historyToken);
            if (toReturn == null) {
                Class<P> clazz = this.checkTypeToken(parts[1]);
                toReturn = new SimpleEntityProxyId<P>(clazz, -1 * this.ephemeralIds.size());
                this.ephemeralIds.put(historyToken, toReturn);
            }
            return toReturn;
        }
        throw new IllegalArgumentException(historyToken);
    }

    public RequestTransport getRequestTransport() {
        return this.transport;
    }

    @Override
    public void initialize(EventBus eventBus) {
        this.initialize(eventBus, new DefaultRequestTransport(eventBus));
    }

    @Override
    public void initialize(EventBus eventBus, RequestTransport transport) {
        this.eventBus = eventBus;
        this.transport = transport;
    }

    protected abstract AutoBeanFactory getAutoBeanFactory();

    protected <P extends EntityProxy> SimpleEntityProxyId<P> getId(Class<P> clazz, String serverId) {
        return this.getId(this.getTypeToken(clazz), serverId);
    }

    protected <P extends EntityProxy> SimpleEntityProxyId<P> getId(String typeToken, String serverId) {
        return this.getId(typeToken, serverId, null);
    }

    protected <P extends EntityProxy> SimpleEntityProxyId<P> getId(String typeToken, String serverId, String clientId) {
        String ephemeralKey;
        SimpleEntityProxyId<?> toReturn;
        if (clientId != null && (toReturn = this.ephemeralIds.get(ephemeralKey = clientId + EPHEMERAL_SEPARATOR + typeToken)) != null) {
            if (toReturn.isEphemeral()) {
                assert (toReturn.getProxyClass().equals(this.getTypeFromToken(typeToken)));
                if (!"null".equals(serverId)) {
                    toReturn.setServerId(serverId);
                    String serverKey = serverId + TOKEN_SEPARATOR + typeToken;
                    this.ephemeralIds.put(serverKey, toReturn);
                }
            }
            return toReturn;
        }
        assert (serverId != null) : "serverId";
        String serverKey = serverId + TOKEN_SEPARATOR + typeToken;
        toReturn = this.ephemeralIds.get(serverKey);
        if (toReturn != null) {
            return toReturn;
        }
        Class<P> clazz = this.getTypeFromToken(typeToken);
        return new SimpleEntityProxyId<P>(clazz, serverId);
    }

    protected abstract <P extends EntityProxy> Class<P> getTypeFromToken(String var1);

    protected abstract String getTypeToken(Class<?> var1);

    protected boolean hasVersionChanged(SimpleEntityProxyId<?> id, int observedVersion) {
        boolean toReturn;
        Integer existingVersion = this.version.get(id.getServerId());
        boolean bl = toReturn = existingVersion == null || !existingVersion.equals(observedVersion);
        if (toReturn) {
            this.version.put(id.getServerId(), observedVersion);
        }
        return toReturn;
    }

    private <P> Class<P> checkTypeToken(String token) {
        Class<P> clazz = this.getTypeFromToken(token);
        if (clazz == null) {
            throw new IllegalArgumentException("Unknnown type");
        }
        return clazz;
    }
}

