/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.client.impl;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class WeakMapping {
    private static Map<IdentityWeakReference, Map<String, Object>> map = new HashMap<IdentityWeakReference, Map<String, Object>>();
    private static ReferenceQueue<Object> queue = new ReferenceQueue();

    public static synchronized Object get(Object instance, String key) {
        WeakMapping.cleanup();
        IdentityWeakReference ref = new IdentityWeakReference(instance, queue);
        Map<String, Object> m = map.get(ref);
        if (m == null) {
            return null;
        }
        return m.get(key);
    }

    public static synchronized void set(Object instance, String key, Object value) {
        WeakMapping.cleanup();
        if (instance instanceof String) {
            throw new IllegalArgumentException("Cannot use Strings with WeakMapping");
        }
        IdentityWeakReference ref = new IdentityWeakReference(instance, queue);
        Map<String, Object> m = map.get(ref);
        if (m == null) {
            m = new HashMap<String, Object>();
            map.put(ref, m);
        }
        m.put(key, value);
    }

    private static void cleanup() {
        Reference<Object> ref;
        while ((ref = queue.poll()) != null) {
            map.remove(ref);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IdentityWeakReference
    extends WeakReference<Object> {
        private final int hashCode;

        public IdentityWeakReference(Object referent, ReferenceQueue<Object> queue) {
            super(referent, queue);
            this.hashCode = System.identityHashCode(referent);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IdentityWeakReference)) {
                return false;
            }
            Object referent = this.get();
            if (referent == null) {
                return false;
            }
            return referent == ((IdentityWeakReference)other).get();
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

