/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ar" locale.
 */
public class LocalizedNamesImpl_ar extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "EG",
        "SA",
        "DZ",
        "SD",
        "IQ",
        "SY",
        "MA",
        "YE",
        "TN",
        "JO",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AZ",
        "AM",
        "AW",
        "ES",
        "AU",
        "IL",
        "AF",
        "AL",
        "DE",
        "AG",
        "AD",
        "AO",
        "AI",
        "UY",
        "UZ",
        "UG",
        "QO",
        "UA",
        "IE",
        "IS",
        "ET",
        "ER",
        "EE",
        "AR",
        "JO",
        "IO",
        "EC",
        "EU",
        "AE",
        "BS",
        "BH",
        "BR",
        "PT",
        "BA",
        "GA",
        "ME",
        "DZ",
        "DK",
        "CV",
        "SV",
        "SN",
        "SD",
        "SE",
        "EH",
        "SO",
        "CN",
        "IQ",
        "VA",
        "PH",
        "AQ",
        "CM",
        "CG",
        "KW",
        "MA",
        "TF",
        "MX",
        "SA",
        "GB",
        "NO",
        "AT",
        "NE",
        "IN",
        "US",
        "JP",
        "YE",
        "GR",
        "ID",
        "IR",
        "IT",
        "PG",
        "PY",
        "PK",
        "PW",
        "BW",
        "PN",
        "BB",
        "BM",
        "BN",
        "BE",
        "BG",
        "BZ",
        "BD",
        "PA",
        "BJ",
        "BT",
        "PR",
        "BF",
        "BI",
        "PL",
        "BO",
        "PF",
        "PE",
        "TZ",
        "TH",
        "TW",
        "TM",
        "TR",
        "TA",
        "TT",
        "TD",
        "TG",
        "TV",
        "TK",
        "TN",
        "TO",
        "TL",
        "JM",
        "GI",
        "GD",
        "AX",
        "AN",
        "TC",
        "KM",
        "KY",
        "IC",
        "MH",
        "MV",
        "UM",
        "SB",
        "FO",
        "VI",
        "VG",
        "FK",
        "CK",
        "CC",
        "MP",
        "WF",
        "AC",
        "CX",
        "BV",
        "CP",
        "IM",
        "NF",
        "HM",
        "CF",
        "CZ",
        "DO",
        "CD",
        "ZA",
        "GT",
        "GP",
        "GE",
        "GS",
        "DJ",
        "JE",
        "DM",
        "DG",
        "RW",
        "RU",
        "BY",
        "RO",
        "RE",
        "ZM",
        "ZW",
        "CI",
        "WS",
        "AS",
        "BL",
        "PM",
        "VC",
        "KN",
        "LC",
        "MF",
        "SH",
        "SM",
        "ST",
        "LK",
        "SJ",
        "SK",
        "SI",
        "SG",
        "SZ",
        "SY",
        "SR",
        "CH",
        "SL",
        "SC",
        "EA",
        "CL",
        "RS",
        "CS",
        "TJ",
        "OM",
        "GM",
        "GH",
        "GL",
        "GU",
        "GF",
        "GY",
        "GG",
        "GN",
        "GQ",
        "GW",
        "VU",
        "FR",
        "PS",
        "VE",
        "FI",
        "VN",
        "FJ",
        "CY",
        "KG",
        "QA",
        "KZ",
        "NC",
        "HR",
        "KH",
        "CA",
        "CU",
        "KR",
        "KP",
        "CR",
        "CO",
        "KI",
        "KE",
        "LV",
        "LA",
        "LB",
        "LU",
        "LY",
        "LR",
        "LT",
        "LI",
        "LS",
        "MQ",
        "MO",
        "MT",
        "ML",
        "MY",
        "YT",
        "MG",
        "EG",
        "MK",
        "MW",
        "MN",
        "MR",
        "MU",
        "MZ",
        "MD",
        "MC",
        "MS",
        "MM",
        "FX",
        "FM",
        "NA",
        "NR",
        "NP",
        "NG",
        "NI",
        "NZ",
        "NU",
        "HT",
        "HN",
        "HU",
        "NL",
        "HK",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "العالم");
    namesMap.put("002", "افريقيا");
    namesMap.put("003", "أمريكا الشمالية");
    namesMap.put("005", "أمريكا الجنوبية");
    namesMap.put("009", "أوقيانوسيا");
    namesMap.put("011", "غرب افريقيا");
    namesMap.put("013", "أمريكا الوسطى");
    namesMap.put("014", "شرق افريقيا");
    namesMap.put("015", "شمال افريقيا");
    namesMap.put("017", "وسط افريقيا");
    namesMap.put("018", "جنوب افريقيا");
    namesMap.put("019", "الأمريكتين");
    namesMap.put("021", "شمال أمريكا");
    namesMap.put("029", "الكاريبي");
    namesMap.put("030", "شرق آسيا");
    namesMap.put("034", "جنوب آسيا");
    namesMap.put("035", "جنوب شرق آسيا");
    namesMap.put("039", "جنوب أوروبا");
    namesMap.put("053", "أستراليا ونيوزيلندا");
    namesMap.put("054", "ميلانيزيا");
    namesMap.put("057", "الجزر الميكرونيزية");
    namesMap.put("061", "بولينيزيا");
    namesMap.put("062", "جنوب وسط آسيا");
    namesMap.put("142", "آسيا");
    namesMap.put("143", "وسط آسيا");
    namesMap.put("145", "غرب آسيا");
    namesMap.put("150", "أوروبا");
    namesMap.put("151", "شرق أوروبا");
    namesMap.put("154", "شمال أوروبا");
    namesMap.put("155", "غرب أوروبا");
    namesMap.put("172", "كومنولث الدول المستقلة");
    namesMap.put("419", "أمريكا اللاتينية و الكاريبي");
    namesMap.put("AC", "جزيرة أسينشيون");
    namesMap.put("AD", "أندورا");
    namesMap.put("AE", "الامارات العربية المتحدة");
    namesMap.put("AF", "أفغانستان");
    namesMap.put("AG", "أنتيغوا وبربودا");
    namesMap.put("AI", "أنغويلا");
    namesMap.put("AL", "ألبانيا");
    namesMap.put("AM", "أرمينيا");
    namesMap.put("AN", "جزر الأنتيل الهولندية");
    namesMap.put("AO", "أنغولا");
    namesMap.put("AQ", "القطب الجنوبي");
    namesMap.put("AR", "الأرجنتين");
    namesMap.put("AS", "ساموا الأمريكية");
    namesMap.put("AT", "النمسا");
    namesMap.put("AU", "أستراليا");
    namesMap.put("AW", "آروبا");
    namesMap.put("AX", "جزر أولان");
    namesMap.put("AZ", "أذربيجان");
    namesMap.put("BA", "البوسنة والهرسك");
    namesMap.put("BB", "بربادوس");
    namesMap.put("BD", "بنجلاديش");
    namesMap.put("BE", "بلجيكا");
    namesMap.put("BF", "بوركينا فاسو");
    namesMap.put("BG", "بلغاريا");
    namesMap.put("BH", "البحرين");
    namesMap.put("BI", "بوروندي");
    namesMap.put("BJ", "بنين");
    namesMap.put("BL", "سان بارتليمي");
    namesMap.put("BM", "برمودا");
    namesMap.put("BN", "بروناي");
    namesMap.put("BO", "بوليفيا");
    namesMap.put("BR", "البرازيل");
    namesMap.put("BS", "الباهاما");
    namesMap.put("BT", "بوتان");
    namesMap.put("BV", "جزيرة بوفيه");
    namesMap.put("BW", "بتسوانا");
    namesMap.put("BY", "روسيا البيضاء");
    namesMap.put("BZ", "بليز");
    namesMap.put("CA", "كندا");
    namesMap.put("CC", "جزر كوكوس");
    namesMap.put("CD", "جمهورية الكونغو الديمقراطية");
    namesMap.put("CF", "جمهورية افريقيا الوسطى");
    namesMap.put("CG", "الكونغو - برازافيل");
    namesMap.put("CH", "سويسرا");
    namesMap.put("CI", "ساحل العاج");
    namesMap.put("CK", "جزر كوك");
    namesMap.put("CL", "شيلي");
    namesMap.put("CM", "الكاميرون");
    namesMap.put("CN", "الصين");
    namesMap.put("CO", "كولومبيا");
    namesMap.put("CP", "جزيرة كليبيرتون");
    namesMap.put("CR", "كوستاريكا");
    namesMap.put("CS", "صربيا والجبل الأسود");
    namesMap.put("CU", "كوبا");
    namesMap.put("CV", "الرأس الأخضر");
    namesMap.put("CX", "جزيرة الكريسماس");
    namesMap.put("CY", "قبرص");
    namesMap.put("CZ", "جمهورية التشيك");
    namesMap.put("DE", "ألمانيا");
    namesMap.put("DG", "دييغو غارسيا");
    namesMap.put("DJ", "جيبوتي");
    namesMap.put("DK", "الدانمرك");
    namesMap.put("DM", "دومينيكا");
    namesMap.put("DO", "جمهورية الدومينيك");
    namesMap.put("DZ", "الجزائر");
    namesMap.put("EA", "سيوتا وميليلا");
    namesMap.put("EC", "الإكوادور");
    namesMap.put("EE", "استونيا");
    namesMap.put("EG", "مصر");
    namesMap.put("EH", "الصحراء الغربية");
    namesMap.put("ER", "اريتريا");
    namesMap.put("ES", "أسبانيا");
    namesMap.put("ET", "اثيوبيا");
    namesMap.put("EU", "الاتحاد الاوروبي");
    namesMap.put("FI", "فنلندا");
    namesMap.put("FJ", "فيجي");
    namesMap.put("FK", "جزر فوكلاند");
    namesMap.put("FM", "ميكرونيزيا");
    namesMap.put("FO", "جزر فارو");
    namesMap.put("FR", "فرنسا");
    namesMap.put("FX", "ميتروبولويتان فرنسا");
    namesMap.put("GA", "الجابون");
    namesMap.put("GB", "المملكة المتحدة");
    namesMap.put("GD", "جرينادا");
    namesMap.put("GE", "جورجيا");
    namesMap.put("GF", "غويانا");
    namesMap.put("GG", "غيرنزي");
    namesMap.put("GH", "غانا");
    namesMap.put("GI", "جبل طارق");
    namesMap.put("GL", "غرينلاند");
    namesMap.put("GM", "غامبيا");
    namesMap.put("GN", "غينيا");
    namesMap.put("GP", "جوادلوب");
    namesMap.put("GQ", "غينيا الاستوائية");
    namesMap.put("GR", "اليونان");
    namesMap.put("GS", "جورجيا الجنوبية وجزر ساندويتش الجنوبية");
    namesMap.put("GT", "جواتيمالا");
    namesMap.put("GU", "غوام");
    namesMap.put("GW", "غينيا بيساو");
    namesMap.put("GY", "غيانا");
    namesMap.put("HK", "هونج كونج");
    namesMap.put("HM", "جزيرة هيرد وماكدونالد");
    namesMap.put("HN", "هندوراس");
    namesMap.put("HR", "كرواتيا");
    namesMap.put("HT", "هايتي");
    namesMap.put("HU", "هنغاريا");
    namesMap.put("IC", "جزر الكناري");
    namesMap.put("ID", "اندونيسيا");
    namesMap.put("IE", "أيرلندا");
    namesMap.put("IL", "إسرائيل");
    namesMap.put("IM", "جزيرة مان");
    namesMap.put("IN", "الهند");
    namesMap.put("IO", "الإقليم البريطاني في المحيط الهندي");
    namesMap.put("IQ", "العراق");
    namesMap.put("IR", "ايران");
    namesMap.put("IS", "أيسلندا");
    namesMap.put("IT", "ايطاليا");
    namesMap.put("JE", "جيرسي");
    namesMap.put("JM", "جامايكا");
    namesMap.put("JO", "الأردن");
    namesMap.put("JP", "اليابان");
    namesMap.put("KE", "كينيا");
    namesMap.put("KG", "قرغيزستان");
    namesMap.put("KH", "كمبوديا");
    namesMap.put("KI", "كيريباتي");
    namesMap.put("KM", "جزر القمر");
    namesMap.put("KN", "سانت كيتس ونيفيس");
    namesMap.put("KP", "كوريا الشمالية");
    namesMap.put("KR", "كوريا الجنوبية");
    namesMap.put("KW", "الكويت");
    namesMap.put("KY", "جزر الكايمن");
    namesMap.put("KZ", "كازاخستان");
    namesMap.put("LA", "لاوس");
    namesMap.put("LB", "لبنان");
    namesMap.put("LC", "سانت لوسيا");
    namesMap.put("LI", "ليختنشتاين");
    namesMap.put("LK", "سريلانكا");
    namesMap.put("LR", "ليبيريا");
    namesMap.put("LS", "ليسوتو");
    namesMap.put("LT", "ليتوانيا");
    namesMap.put("LU", "لوكسمبورج");
    namesMap.put("LV", "لاتفيا");
    namesMap.put("LY", "ليبيا");
    namesMap.put("MA", "المغرب");
    namesMap.put("MC", "موناكو");
    namesMap.put("MD", "مولدافيا");
    namesMap.put("ME", "الجبل الأسود");
    namesMap.put("MF", "سانت مارتين");
    namesMap.put("MG", "مدغشقر");
    namesMap.put("MH", "جزر المارشال");
    namesMap.put("MK", "مقدونيا");
    namesMap.put("ML", "مالي");
    namesMap.put("MM", "ميانمار -بورما");
    namesMap.put("MN", "منغوليا");
    namesMap.put("MO", "ماكاو");
    namesMap.put("MP", "جزر ماريانا الشمالية");
    namesMap.put("MQ", "مارتينيك");
    namesMap.put("MR", "موريتانيا");
    namesMap.put("MS", "مونتسرات");
    namesMap.put("MT", "مالطا");
    namesMap.put("MU", "موريشيوس");
    namesMap.put("MV", "جزر الملديف");
    namesMap.put("MW", "ملاوي");
    namesMap.put("MX", "المكسيك");
    namesMap.put("MY", "ماليزيا");
    namesMap.put("MZ", "موزمبيق");
    namesMap.put("NA", "ناميبيا");
    namesMap.put("NC", "كاليدونيا الجديدة");
    namesMap.put("NE", "النيجر");
    namesMap.put("NF", "جزيرة نورفوك");
    namesMap.put("NG", "نيجيريا");
    namesMap.put("NI", "نيكاراغوا");
    namesMap.put("NL", "هولندا");
    namesMap.put("NO", "النرويج");
    namesMap.put("NP", "نيبال");
    namesMap.put("NR", "ناورو");
    namesMap.put("NU", "نيوي");
    namesMap.put("NZ", "نيوزيلاندا");
    namesMap.put("OM", "عُمان");
    namesMap.put("PA", "بنما");
    namesMap.put("PE", "بيرو");
    namesMap.put("PF", "بولينيزيا الفرنسية");
    namesMap.put("PG", "بابوا غينيا الجديدة");
    namesMap.put("PH", "الفيلبين");
    namesMap.put("PK", "باكستان");
    namesMap.put("PL", "بولندا");
    namesMap.put("PM", "سانت بيير وميكولون");
    namesMap.put("PN", "بتكايرن");
    namesMap.put("PR", "بورتوريكو");
    namesMap.put("PS", "فلسطين");
    namesMap.put("PT", "البرتغال");
    namesMap.put("PW", "بالاو");
    namesMap.put("PY", "باراغواي");
    namesMap.put("QA", "قطر");
    namesMap.put("QO", "أوقيانوسيا النائية");
    namesMap.put("RE", "روينيون");
    namesMap.put("RO", "رومانيا");
    namesMap.put("RS", "صربيا");
    namesMap.put("RU", "روسيا");
    namesMap.put("RW", "رواندا");
    namesMap.put("SA", "المملكة العربية السعودية");
    namesMap.put("SB", "جزر سليمان");
    namesMap.put("SC", "سيشل");
    namesMap.put("SD", "السودان");
    namesMap.put("SE", "السويد");
    namesMap.put("SG", "سنغافورة");
    namesMap.put("SH", "سانت هيلنا");
    namesMap.put("SI", "سلوفينيا");
    namesMap.put("SJ", "سفالبارد وجان مايان");
    namesMap.put("SK", "سلوفاكيا");
    namesMap.put("SL", "سيراليون");
    namesMap.put("SM", "سان مارينو");
    namesMap.put("SN", "السنغال");
    namesMap.put("SO", "الصومال");
    namesMap.put("SR", "سورينام");
    namesMap.put("ST", "ساو تومي وبرينسيبي");
    namesMap.put("SV", "السلفادور");
    namesMap.put("SY", "سوريا");
    namesMap.put("SZ", "سوازيلاند");
    namesMap.put("TA", "تريستان دي كونها");
    namesMap.put("TC", "جزر الترك وجايكوس");
    namesMap.put("TD", "تشاد");
    namesMap.put("TF", "المقاطعات الجنوبية الفرنسية");
    namesMap.put("TG", "توجو");
    namesMap.put("TH", "تايلند");
    namesMap.put("TJ", "طاجكستان");
    namesMap.put("TK", "توكيلو");
    namesMap.put("TL", "تيمور الشرقية");
    namesMap.put("TM", "تركمانستان");
    namesMap.put("TN", "تونس");
    namesMap.put("TO", "تونغا");
    namesMap.put("TR", "تركيا");
    namesMap.put("TT", "ترينيداد وتوباغو");
    namesMap.put("TV", "توفالو");
    namesMap.put("TW", "تايوان");
    namesMap.put("TZ", "تانزانيا");
    namesMap.put("UA", "أوكرانيا");
    namesMap.put("UG", "أوغندا");
    namesMap.put("UM", "جزر الولايات المتحدة البعيدة الصغيرة");
    namesMap.put("US", "الولايات المتحدة الأمريكية");
    namesMap.put("UY", "أورغواي");
    namesMap.put("UZ", "أوزبكستان");
    namesMap.put("VA", "الفاتيكان");
    namesMap.put("VC", "سانت فنسنت وغرنادين");
    namesMap.put("VE", "فنزويلا");
    namesMap.put("VG", "جزر فرجين البريطانية");
    namesMap.put("VI", "جزر فرجين الأمريكية");
    namesMap.put("VN", "فيتنام");
    namesMap.put("VU", "فانواتو");
    namesMap.put("WF", "جزر والس وفوتونا");
    namesMap.put("WS", "ساموا");
    namesMap.put("YE", "اليمن");
    namesMap.put("YT", "مايوت");
    namesMap.put("ZA", "جمهورية جنوب افريقيا");
    namesMap.put("ZM", "زامبيا");
    namesMap.put("ZW", "زيمبابوي");
    namesMap.put("ZZ", "منطقة غير معرفة");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "العالم",
        "002": "افريقيا",
        "003": "أمريكا الشمالية",
        "005": "أمريكا الجنوبية",
        "009": "أوقيانوسيا",
        "011": "غرب افريقيا",
        "013": "أمريكا الوسطى",
        "014": "شرق افريقيا",
        "015": "شمال افريقيا",
        "017": "وسط افريقيا",
        "018": "جنوب افريقيا",
        "019": "الأمريكتين",
        "021": "شمال أمريكا",
        "029": "الكاريبي",
        "030": "شرق آسيا",
        "034": "جنوب آسيا",
        "035": "جنوب شرق آسيا",
        "039": "جنوب أوروبا",
        "053": "أستراليا ونيوزيلندا",
        "054": "ميلانيزيا",
        "057": "الجزر الميكرونيزية",
        "061": "بولينيزيا",
        "062": "جنوب وسط آسيا",
        "142": "آسيا",
        "143": "وسط آسيا",
        "145": "غرب آسيا",
        "150": "أوروبا",
        "151": "شرق أوروبا",
        "154": "شمال أوروبا",
        "155": "غرب أوروبا",
        "172": "كومنولث الدول المستقلة",
        "419": "أمريكا اللاتينية و الكاريبي",
        "AC": "جزيرة أسينشيون",
        "AD": "أندورا",
        "AE": "الامارات العربية المتحدة",
        "AF": "أفغانستان",
        "AG": "أنتيغوا وبربودا",
        "AI": "أنغويلا",
        "AL": "ألبانيا",
        "AM": "أرمينيا",
        "AN": "جزر الأنتيل الهولندية",
        "AO": "أنغولا",
        "AQ": "القطب الجنوبي",
        "AR": "الأرجنتين",
        "AS": "ساموا الأمريكية",
        "AT": "النمسا",
        "AU": "أستراليا",
        "AW": "آروبا",
        "AX": "جزر أولان",
        "AZ": "أذربيجان",
        "BA": "البوسنة والهرسك",
        "BB": "بربادوس",
        "BD": "بنجلاديش",
        "BE": "بلجيكا",
        "BF": "بوركينا فاسو",
        "BG": "بلغاريا",
        "BH": "البحرين",
        "BI": "بوروندي",
        "BJ": "بنين",
        "BL": "سان بارتليمي",
        "BM": "برمودا",
        "BN": "بروناي",
        "BO": "بوليفيا",
        "BR": "البرازيل",
        "BS": "الباهاما",
        "BT": "بوتان",
        "BV": "جزيرة بوفيه",
        "BW": "بتسوانا",
        "BY": "روسيا البيضاء",
        "BZ": "بليز",
        "CA": "كندا",
        "CC": "جزر كوكوس",
        "CD": "جمهورية الكونغو الديمقراطية",
        "CF": "جمهورية افريقيا الوسطى",
        "CG": "الكونغو - برازافيل",
        "CH": "سويسرا",
        "CI": "ساحل العاج",
        "CK": "جزر كوك",
        "CL": "شيلي",
        "CM": "الكاميرون",
        "CN": "الصين",
        "CO": "كولومبيا",
        "CP": "جزيرة كليبيرتون",
        "CR": "كوستاريكا",
        "CS": "صربيا والجبل الأسود",
        "CU": "كوبا",
        "CV": "الرأس الأخضر",
        "CX": "جزيرة الكريسماس",
        "CY": "قبرص",
        "CZ": "جمهورية التشيك",
        "DE": "ألمانيا",
        "DG": "دييغو غارسيا",
        "DJ": "جيبوتي",
        "DK": "الدانمرك",
        "DM": "دومينيكا",
        "DO": "جمهورية الدومينيك",
        "DZ": "الجزائر",
        "EA": "سيوتا وميليلا",
        "EC": "الإكوادور",
        "EE": "استونيا",
        "EG": "مصر",
        "EH": "الصحراء الغربية",
        "ER": "اريتريا",
        "ES": "أسبانيا",
        "ET": "اثيوبيا",
        "EU": "الاتحاد الاوروبي",
        "FI": "فنلندا",
        "FJ": "فيجي",
        "FK": "جزر فوكلاند",
        "FM": "ميكرونيزيا",
        "FO": "جزر فارو",
        "FR": "فرنسا",
        "FX": "ميتروبولويتان فرنسا",
        "GA": "الجابون",
        "GB": "المملكة المتحدة",
        "GD": "جرينادا",
        "GE": "جورجيا",
        "GF": "غويانا",
        "GG": "غيرنزي",
        "GH": "غانا",
        "GI": "جبل طارق",
        "GL": "غرينلاند",
        "GM": "غامبيا",
        "GN": "غينيا",
        "GP": "جوادلوب",
        "GQ": "غينيا الاستوائية",
        "GR": "اليونان",
        "GS": "جورجيا الجنوبية وجزر ساندويتش الجنوبية",
        "GT": "جواتيمالا",
        "GU": "غوام",
        "GW": "غينيا بيساو",
        "GY": "غيانا",
        "HK": "هونج كونج",
        "HM": "جزيرة هيرد وماكدونالد",
        "HN": "هندوراس",
        "HR": "كرواتيا",
        "HT": "هايتي",
        "HU": "هنغاريا",
        "IC": "جزر الكناري",
        "ID": "اندونيسيا",
        "IE": "أيرلندا",
        "IL": "إسرائيل",
        "IM": "جزيرة مان",
        "IN": "الهند",
        "IO": "الإقليم البريطاني في المحيط الهندي",
        "IQ": "العراق",
        "IR": "ايران",
        "IS": "أيسلندا",
        "IT": "ايطاليا",
        "JE": "جيرسي",
        "JM": "جامايكا",
        "JO": "الأردن",
        "JP": "اليابان",
        "KE": "كينيا",
        "KG": "قرغيزستان",
        "KH": "كمبوديا",
        "KI": "كيريباتي",
        "KM": "جزر القمر",
        "KN": "سانت كيتس ونيفيس",
        "KP": "كوريا الشمالية",
        "KR": "كوريا الجنوبية",
        "KW": "الكويت",
        "KY": "جزر الكايمن",
        "KZ": "كازاخستان",
        "LA": "لاوس",
        "LB": "لبنان",
        "LC": "سانت لوسيا",
        "LI": "ليختنشتاين",
        "LK": "سريلانكا",
        "LR": "ليبيريا",
        "LS": "ليسوتو",
        "LT": "ليتوانيا",
        "LU": "لوكسمبورج",
        "LV": "لاتفيا",
        "LY": "ليبيا",
        "MA": "المغرب",
        "MC": "موناكو",
        "MD": "مولدافيا",
        "ME": "الجبل الأسود",
        "MF": "سانت مارتين",
        "MG": "مدغشقر",
        "MH": "جزر المارشال",
        "MK": "مقدونيا",
        "ML": "مالي",
        "MM": "ميانمار -بورما",
        "MN": "منغوليا",
        "MO": "ماكاو",
        "MP": "جزر ماريانا الشمالية",
        "MQ": "مارتينيك",
        "MR": "موريتانيا",
        "MS": "مونتسرات",
        "MT": "مالطا",
        "MU": "موريشيوس",
        "MV": "جزر الملديف",
        "MW": "ملاوي",
        "MX": "المكسيك",
        "MY": "ماليزيا",
        "MZ": "موزمبيق",
        "NA": "ناميبيا",
        "NC": "كاليدونيا الجديدة",
        "NE": "النيجر",
        "NF": "جزيرة نورفوك",
        "NG": "نيجيريا",
        "NI": "نيكاراغوا",
        "NL": "هولندا",
        "NO": "النرويج",
        "NP": "نيبال",
        "NR": "ناورو",
        "NU": "نيوي",
        "NZ": "نيوزيلاندا",
        "OM": "عُمان",
        "PA": "بنما",
        "PE": "بيرو",
        "PF": "بولينيزيا الفرنسية",
        "PG": "بابوا غينيا الجديدة",
        "PH": "الفيلبين",
        "PK": "باكستان",
        "PL": "بولندا",
        "PM": "سانت بيير وميكولون",
        "PN": "بتكايرن",
        "PR": "بورتوريكو",
        "PS": "فلسطين",
        "PT": "البرتغال",
        "PW": "بالاو",
        "PY": "باراغواي",
        "QA": "قطر",
        "QO": "أوقيانوسيا النائية",
        "RE": "روينيون",
        "RO": "رومانيا",
        "RS": "صربيا",
        "RU": "روسيا",
        "RW": "رواندا",
        "SA": "المملكة العربية السعودية",
        "SB": "جزر سليمان",
        "SC": "سيشل",
        "SD": "السودان",
        "SE": "السويد",
        "SG": "سنغافورة",
        "SH": "سانت هيلنا",
        "SI": "سلوفينيا",
        "SJ": "سفالبارد وجان مايان",
        "SK": "سلوفاكيا",
        "SL": "سيراليون",
        "SM": "سان مارينو",
        "SN": "السنغال",
        "SO": "الصومال",
        "SR": "سورينام",
        "ST": "ساو تومي وبرينسيبي",
        "SV": "السلفادور",
        "SY": "سوريا",
        "SZ": "سوازيلاند",
        "TA": "تريستان دي كونها",
        "TC": "جزر الترك وجايكوس",
        "TD": "تشاد",
        "TF": "المقاطعات الجنوبية الفرنسية",
        "TG": "توجو",
        "TH": "تايلند",
        "TJ": "طاجكستان",
        "TK": "توكيلو",
        "TL": "تيمور الشرقية",
        "TM": "تركمانستان",
        "TN": "تونس",
        "TO": "تونغا",
        "TR": "تركيا",
        "TT": "ترينيداد وتوباغو",
        "TV": "توفالو",
        "TW": "تايوان",
        "TZ": "تانزانيا",
        "UA": "أوكرانيا",
        "UG": "أوغندا",
        "UM": "جزر الولايات المتحدة البعيدة الصغيرة",
        "US": "الولايات المتحدة الأمريكية",
        "UY": "أورغواي",
        "UZ": "أوزبكستان",
        "VA": "الفاتيكان",
        "VC": "سانت فنسنت وغرنادين",
        "VE": "فنزويلا",
        "VG": "جزر فرجين البريطانية",
        "VI": "جزر فرجين الأمريكية",
        "VN": "فيتنام",
        "VU": "فانواتو",
        "WF": "جزر والس وفوتونا",
        "WS": "ساموا",
        "YE": "اليمن",
        "YT": "مايوت",
        "ZA": "جمهورية جنوب افريقيا",
        "ZM": "زامبيا",
        "ZW": "زيمبابوي",
        "ZZ": "منطقة غير معرفة"
    };
  }-*/;
}
