/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.client.impl;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.impl.AsyncFragmentLoader;

public class LoadingStrategyBase
implements AsyncFragmentLoader.LoadingStrategy {
    public static int MAX_AUTO_RETRY_COUNT = 3;
    private DownloadStrategy downloadStrategy;
    private final FragmentReloadTracker manualRetryNumbers = FragmentReloadTracker.create();

    protected static native void gwtInstallCode(String var0);

    protected static native String gwtStartLoadingFragment(int var0, AsyncFragmentLoader.LoadTerminatedHandler var1);

    public DownloadStrategy getDownloadStrategy() {
        return this.downloadStrategy;
    }

    public LoadingStrategyBase(DownloadStrategy downloadStrategy) {
        this.downloadStrategy = downloadStrategy;
    }

    @Override
    public void startLoadingFragment(int fragment, AsyncFragmentLoader.LoadTerminatedHandler loadErrorHandler) {
        String url = LoadingStrategyBase.gwtStartLoadingFragment(fragment, loadErrorHandler);
        if (url == null) {
            return;
        }
        int manualRetry = this.getManualRetryNum(fragment);
        if (manualRetry > 0) {
            char connector = url.contains("?") ? (char)'&' : '?';
            String string = String.valueOf(url);
            char c = connector;
            int n = manualRetry;
            url = new StringBuilder(24 + string.length()).append(string).append(c).append("manualRetry=").append(n).toString();
        }
        RequestData request = new RequestData(url, loadErrorHandler, fragment, this.downloadStrategy, this.getMaxAutoRetryCount());
        request.tryDownload();
    }

    protected int getMaxAutoRetryCount() {
        return MAX_AUTO_RETRY_COUNT;
    }

    private int getManualRetryNum(int fragment) {
        int ser = this.manualRetryNumbers.get(fragment);
        this.manualRetryNumbers.put(fragment, ser + 1);
        return ser;
    }

    protected static class RequestData {
        private static final int MAX_LOG_LENGTH = 200;
        private DownloadStrategy downloadStrategy;
        private AsyncFragmentLoader.LoadTerminatedHandler errorHandler = null;
        private int fragment;
        private int maxRetryCount;
        private String originalUrl;
        private int retryCount;
        private String url;

        public RequestData(String url, AsyncFragmentLoader.LoadTerminatedHandler errorHandler, int fragment, DownloadStrategy downloadStrategy, int maxRetryCount) {
            this.url = url;
            this.originalUrl = url;
            this.errorHandler = errorHandler;
            this.maxRetryCount = maxRetryCount;
            this.retryCount = 0;
            this.fragment = fragment;
            this.downloadStrategy = downloadStrategy;
        }

        public AsyncFragmentLoader.LoadTerminatedHandler getErrorHandler() {
            return this.errorHandler;
        }

        public int getFragment() {
            return this.fragment;
        }

        public int getRetryCount() {
            return this.retryCount;
        }

        protected void setRetryCount(int retryCount) {
            this.retryCount = retryCount;
        }

        public String getUrl() {
            return this.url;
        }

        protected void setUrl(String url) {
            this.url = url;
        }

        public String getOriginalUrl() {
            return this.originalUrl;
        }

        public void onLoadError(Throwable e, boolean mayRetry) {
            if (mayRetry) {
                ++this.retryCount;
                if (this.retryCount <= this.maxRetryCount) {
                    char connector = this.originalUrl.contains("?") ? (char)'&' : '?';
                    String string = String.valueOf(String.valueOf(this.originalUrl));
                    char c = connector;
                    int n = this.retryCount;
                    this.url = new StringBuilder(22 + string.length()).append(string).append(c).append("autoRetry=").append(n).toString();
                    this.downloadStrategy.tryDownload(this);
                    return;
                }
            }
            this.errorHandler.loadTerminated(e);
        }

        public void tryDownload() {
            this.downloadStrategy.tryDownload(this);
        }

        public void tryInstall(String code) {
            try {
                LoadingStrategyBase.gwtInstallCode(code);
            }
            catch (RuntimeException e) {
                String textIntro = code;
                if (textIntro != null && textIntro.length() > 200) {
                    textIntro = String.valueOf(textIntro.substring(0, 200)).concat("...");
                }
                this.onLoadError(new AsyncFragmentLoader.HttpInstallFailure(this.url, textIntro, e), false);
            }
        }
    }

    private static final class FragmentReloadTracker
    extends JavaScriptObject {
        public static FragmentReloadTracker create() {
            return (FragmentReloadTracker)JavaScriptObject.createArray();
        }

        protected FragmentReloadTracker() {
        }

        public native int get(int var1);

        public native void put(int var1, int var2);
    }

    protected static interface DownloadStrategy {
        public void tryDownload(RequestData var1);
    }
}

