/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.shared;

import com.google.gwt.core.shared.impl.ThrowableTypeResolver;

public final class SerializableThrowable
extends Throwable {
    private String typeName;
    private boolean exactTypeKnown;
    private transient Throwable originalThrowable;
    private StackTraceElement[] dummyFieldToIncludeTheTypeInSerialization;

    public static SerializableThrowable fromThrowable(Throwable throwable) {
        if (throwable instanceof SerializableThrowable) {
            return (SerializableThrowable)throwable;
        }
        if (throwable != null) {
            return SerializableThrowable.createSerializable(throwable);
        }
        return null;
    }

    public SerializableThrowable(String designatedType, String message) {
        super(message);
        this.typeName = designatedType;
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    public void setDesignatedType(String typeName, boolean isExactType) {
        this.typeName = typeName;
        this.exactTypeKnown = isExactType;
    }

    public String getDesignatedType() {
        return this.typeName;
    }

    public boolean isExactDesignatedTypeKnown() {
        return this.exactTypeKnown;
    }

    @Override
    public Throwable initCause(Throwable cause) {
        return super.initCause(SerializableThrowable.fromThrowable(cause));
    }

    public Throwable getOriginalThrowable() {
        return this.originalThrowable;
    }

    @Override
    public String toString() {
        String string;
        String type = this.exactTypeKnown ? this.typeName : String.valueOf(this.typeName).concat("(EXACT TYPE UNKNOWN)");
        String msg = this.getMessage();
        if (msg == null) {
            string = type;
        } else {
            String string2 = String.valueOf(String.valueOf(type));
            String string3 = String.valueOf(String.valueOf(msg));
            string = new StringBuilder(2 + string2.length() + string3.length()).append(string2).append(": ").append(string3).toString();
        }
        return string;
    }

    private static SerializableThrowable createSerializable(Throwable t) {
        SerializableThrowable throwable = new SerializableThrowable(null, t.getMessage());
        throwable.setStackTrace(t.getStackTrace());
        throwable.initCause(t.getCause());
        throwable.originalThrowable = t;
        ThrowableTypeResolver.resolveDesignatedType(throwable, t);
        return throwable;
    }
}

