/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dom.builder.shared;

import com.google.gwt.dom.builder.shared.ElementBuilderBase;
import com.google.gwt.dom.builder.shared.ElementBuilderImpl;
import com.google.gwt.dom.builder.shared.HtmlAnchorBuilder;
import com.google.gwt.dom.builder.shared.HtmlAreaBuilder;
import com.google.gwt.dom.builder.shared.HtmlAudioBuilder;
import com.google.gwt.dom.builder.shared.HtmlBRBuilder;
import com.google.gwt.dom.builder.shared.HtmlBaseBuilder;
import com.google.gwt.dom.builder.shared.HtmlBodyBuilder;
import com.google.gwt.dom.builder.shared.HtmlButtonBuilder;
import com.google.gwt.dom.builder.shared.HtmlCanvasBuilder;
import com.google.gwt.dom.builder.shared.HtmlDListBuilder;
import com.google.gwt.dom.builder.shared.HtmlDivBuilder;
import com.google.gwt.dom.builder.shared.HtmlElementBuilder;
import com.google.gwt.dom.builder.shared.HtmlFieldSetBuilder;
import com.google.gwt.dom.builder.shared.HtmlFormBuilder;
import com.google.gwt.dom.builder.shared.HtmlFrameBuilder;
import com.google.gwt.dom.builder.shared.HtmlFrameSetBuilder;
import com.google.gwt.dom.builder.shared.HtmlHRBuilder;
import com.google.gwt.dom.builder.shared.HtmlHeadBuilder;
import com.google.gwt.dom.builder.shared.HtmlHeadingBuilder;
import com.google.gwt.dom.builder.shared.HtmlIFrameBuilder;
import com.google.gwt.dom.builder.shared.HtmlImageBuilder;
import com.google.gwt.dom.builder.shared.HtmlInputBuilder;
import com.google.gwt.dom.builder.shared.HtmlLIBuilder;
import com.google.gwt.dom.builder.shared.HtmlLabelBuilder;
import com.google.gwt.dom.builder.shared.HtmlLegendBuilder;
import com.google.gwt.dom.builder.shared.HtmlLinkBuilder;
import com.google.gwt.dom.builder.shared.HtmlMapBuilder;
import com.google.gwt.dom.builder.shared.HtmlMetaBuilder;
import com.google.gwt.dom.builder.shared.HtmlOListBuilder;
import com.google.gwt.dom.builder.shared.HtmlOptGroupBuilder;
import com.google.gwt.dom.builder.shared.HtmlOptionBuilder;
import com.google.gwt.dom.builder.shared.HtmlParagraphBuilder;
import com.google.gwt.dom.builder.shared.HtmlParamBuilder;
import com.google.gwt.dom.builder.shared.HtmlPreBuilder;
import com.google.gwt.dom.builder.shared.HtmlQuoteBuilder;
import com.google.gwt.dom.builder.shared.HtmlScriptBuilder;
import com.google.gwt.dom.builder.shared.HtmlSelectBuilder;
import com.google.gwt.dom.builder.shared.HtmlSourceBuilder;
import com.google.gwt.dom.builder.shared.HtmlSpanBuilder;
import com.google.gwt.dom.builder.shared.HtmlStyleBuilder;
import com.google.gwt.dom.builder.shared.HtmlStylesBuilder;
import com.google.gwt.dom.builder.shared.HtmlTableBuilder;
import com.google.gwt.dom.builder.shared.HtmlTableCaptionBuilder;
import com.google.gwt.dom.builder.shared.HtmlTableCellBuilder;
import com.google.gwt.dom.builder.shared.HtmlTableColBuilder;
import com.google.gwt.dom.builder.shared.HtmlTableRowBuilder;
import com.google.gwt.dom.builder.shared.HtmlTableSectionBuilder;
import com.google.gwt.dom.builder.shared.HtmlTextAreaBuilder;
import com.google.gwt.dom.builder.shared.HtmlTitleBuilder;
import com.google.gwt.dom.builder.shared.HtmlUListBuilder;
import com.google.gwt.dom.builder.shared.HtmlVideoBuilder;
import com.google.gwt.dom.builder.shared.StylesBuilder;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.safecss.shared.SafeStyles;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;

class HtmlBuilderImpl
extends ElementBuilderImpl {
    private HtmlAnchorBuilder anchorBuilder;
    private HtmlAreaBuilder areaBuilder;
    private HtmlAudioBuilder audioBuilder;
    private HtmlBaseBuilder baseBuilder;
    private HtmlBodyBuilder bodyBuilder;
    private HtmlBRBuilder brBuilder;
    private HtmlButtonBuilder buttonBuilder;
    private HtmlCanvasBuilder canvasBuilder;
    private final HtmlDivBuilder divBuilder = new HtmlDivBuilder(this);
    private HtmlDListBuilder dListBuilder;
    private final HtmlElementBuilder elementBuilder = new HtmlElementBuilder(this);
    private HtmlFieldSetBuilder fieldSetBuilder;
    private HtmlFormBuilder formBuilder;
    private HtmlFrameBuilder frameBuilder;
    private HtmlFrameSetBuilder frameSetBuilder;
    private HtmlHeadBuilder headBuilder;
    private HtmlHeadingBuilder headingBuilder;
    private HtmlHRBuilder hrBuilder;
    private HtmlIFrameBuilder iFrameBuilder;
    private HtmlImageBuilder imageBuilder;
    private final HtmlInputBuilder inputBuilder = new HtmlInputBuilder(this);
    private HtmlLabelBuilder labelBuilder;
    private HtmlLegendBuilder legendBuilder;
    private final HtmlLIBuilder liBuilder = new HtmlLIBuilder(this);
    private HtmlLinkBuilder linkBuilder;
    private HtmlMapBuilder mapBuilder;
    private HtmlMetaBuilder metaBuilder;
    private HtmlOListBuilder oListBuilder;
    private final HtmlOptionBuilder optionBuilder = new HtmlOptionBuilder(this);
    private HtmlOptGroupBuilder optGroupBuilder;
    private HtmlParagraphBuilder paragraphBuilder;
    private HtmlParamBuilder paramBuilder;
    private HtmlPreBuilder preBuilder;
    private HtmlQuoteBuilder quoteBuilder;
    private HtmlScriptBuilder scriptBuilder;
    private HtmlSelectBuilder selectBuilder;
    private HtmlSourceBuilder sourceBuilder;
    private final HtmlSpanBuilder spanBuilder = new HtmlSpanBuilder(this);
    private HtmlStyleBuilder styleBuilder;
    private final StylesBuilder stylesBuilder = new HtmlStylesBuilder(this);
    private HtmlTableBuilder tableBuilder;
    private final HtmlTableCellBuilder tableCellBuilder = new HtmlTableCellBuilder(this);
    private HtmlTableCaptionBuilder tableCaptionBuilder;
    private HtmlTableColBuilder tableColBuilder;
    private HtmlTableColBuilder tableColGroupBuilder;
    private final HtmlTableRowBuilder tableRowBuilder = new HtmlTableRowBuilder(this);
    private HtmlTableSectionBuilder tableSectionBuilder;
    private HtmlTextAreaBuilder textAreaBuilder;
    private HtmlTitleBuilder titleBuilder;
    private HtmlUListBuilder uListBuilder;
    private HtmlVideoBuilder videoBuilder;
    private final StringBuilder sb = new StringBuilder();

    HtmlBuilderImpl() {
    }

    public SafeHtml asSafeHtml() {
        this.endAllTags();
        return SafeHtmlUtils.fromTrustedString(this.sb.toString());
    }

    public void attribute(String name, int value) {
        this.trustedAttribute(this.escape(name), value);
    }

    public void attribute(String name, String value) {
        this.trustedAttribute(this.escape(name), value);
    }

    public HtmlAnchorBuilder startAnchor() {
        if (this.anchorBuilder == null) {
            this.anchorBuilder = new HtmlAnchorBuilder(this);
        }
        this.trustedStart("a", this.anchorBuilder);
        return this.anchorBuilder;
    }

    public HtmlAreaBuilder startArea() {
        if (this.areaBuilder == null) {
            this.areaBuilder = new HtmlAreaBuilder(this);
        }
        this.trustedStart("area", this.areaBuilder);
        return this.areaBuilder;
    }

    public HtmlAudioBuilder startAudio() {
        if (this.audioBuilder == null) {
            this.audioBuilder = new HtmlAudioBuilder(this);
        }
        this.trustedStart("audio", this.audioBuilder);
        return this.audioBuilder;
    }

    public HtmlBaseBuilder startBase() {
        if (this.baseBuilder == null) {
            this.baseBuilder = new HtmlBaseBuilder(this);
        }
        this.trustedStart("base", this.baseBuilder);
        return this.baseBuilder;
    }

    public HtmlQuoteBuilder startBlockQuote() {
        return this.startQuote("blockquote");
    }

    public HtmlBodyBuilder startBody() {
        if (this.bodyBuilder == null) {
            this.bodyBuilder = new HtmlBodyBuilder(this);
        }
        this.trustedStart("body", this.bodyBuilder);
        return this.bodyBuilder;
    }

    public HtmlBRBuilder startBR() {
        if (this.brBuilder == null) {
            this.brBuilder = new HtmlBRBuilder(this);
        }
        this.trustedStart("br", this.brBuilder);
        return this.brBuilder;
    }

    public HtmlInputBuilder startButtonInput() {
        return this.startInput("button");
    }

    public HtmlCanvasBuilder startCanvas() {
        if (this.canvasBuilder == null) {
            this.canvasBuilder = new HtmlCanvasBuilder(this);
        }
        this.trustedStart("canvas", this.canvasBuilder);
        return this.canvasBuilder;
    }

    public HtmlInputBuilder startCheckboxInput() {
        return this.startInput("checkbox");
    }

    public HtmlTableColBuilder startCol() {
        if (this.tableColBuilder == null) {
            this.tableColBuilder = new HtmlTableColBuilder(this, false);
        }
        this.trustedStart("col", this.tableColBuilder);
        return this.tableColBuilder;
    }

    public HtmlTableColBuilder startColGroup() {
        if (this.tableColGroupBuilder == null) {
            this.tableColGroupBuilder = new HtmlTableColBuilder(this, true);
        }
        this.trustedStart("colgroup", this.tableColGroupBuilder);
        return this.tableColGroupBuilder;
    }

    public HtmlDivBuilder startDiv() {
        this.trustedStart("div", this.divBuilder);
        return this.divBuilder;
    }

    public HtmlDListBuilder startDList() {
        if (this.dListBuilder == null) {
            this.dListBuilder = new HtmlDListBuilder(this);
        }
        this.trustedStart("dl", this.dListBuilder);
        return this.dListBuilder;
    }

    public HtmlFieldSetBuilder startFieldSet() {
        if (this.fieldSetBuilder == null) {
            this.fieldSetBuilder = new HtmlFieldSetBuilder(this);
        }
        this.trustedStart("fieldset", this.fieldSetBuilder);
        return this.fieldSetBuilder;
    }

    public HtmlInputBuilder startFileInput() {
        return this.startInput("file");
    }

    public HtmlFormBuilder startForm() {
        if (this.formBuilder == null) {
            this.formBuilder = new HtmlFormBuilder(this);
        }
        this.trustedStart("form", this.formBuilder);
        return this.formBuilder;
    }

    public HtmlFrameBuilder startFrame() {
        if (this.frameBuilder == null) {
            this.frameBuilder = new HtmlFrameBuilder(this);
        }
        this.trustedStart("frame", this.frameBuilder);
        return this.frameBuilder;
    }

    public HtmlFrameSetBuilder startFrameSet() {
        if (this.frameSetBuilder == null) {
            this.frameSetBuilder = new HtmlFrameSetBuilder(this);
        }
        this.trustedStart("frameset", this.frameSetBuilder);
        return this.frameSetBuilder;
    }

    public HtmlHeadingBuilder startH1() {
        return this.startHeading(1);
    }

    public HtmlHeadingBuilder startH2() {
        return this.startHeading(2);
    }

    public HtmlHeadingBuilder startH3() {
        return this.startHeading(3);
    }

    public HtmlHeadingBuilder startH4() {
        return this.startHeading(4);
    }

    public HtmlHeadingBuilder startH5() {
        return this.startHeading(5);
    }

    public HtmlHeadingBuilder startH6() {
        return this.startHeading(6);
    }

    public HtmlHeadBuilder startHead() {
        if (this.headBuilder == null) {
            this.headBuilder = new HtmlHeadBuilder(this);
        }
        this.trustedStart("head", this.headBuilder);
        return this.headBuilder;
    }

    public HtmlInputBuilder startHiddenInput() {
        return this.startInput("hidden");
    }

    public HtmlHRBuilder startHR() {
        if (this.hrBuilder == null) {
            this.hrBuilder = new HtmlHRBuilder(this);
        }
        this.trustedStart("hr", this.hrBuilder);
        return this.hrBuilder;
    }

    public HtmlIFrameBuilder startIFrame() {
        if (this.iFrameBuilder == null) {
            this.iFrameBuilder = new HtmlIFrameBuilder(this);
        }
        this.trustedStart("iframe", this.iFrameBuilder);
        return this.iFrameBuilder;
    }

    public HtmlImageBuilder startImage() {
        if (this.imageBuilder == null) {
            this.imageBuilder = new HtmlImageBuilder(this);
        }
        this.trustedStart("img", this.imageBuilder);
        return this.imageBuilder;
    }

    public HtmlInputBuilder startImageInput() {
        return this.startInput("image");
    }

    public HtmlLabelBuilder startLabel() {
        if (this.labelBuilder == null) {
            this.labelBuilder = new HtmlLabelBuilder(this);
        }
        this.trustedStart("label", this.labelBuilder);
        return this.labelBuilder;
    }

    public HtmlLegendBuilder startLegend() {
        if (this.legendBuilder == null) {
            this.legendBuilder = new HtmlLegendBuilder(this);
        }
        this.trustedStart("legend", this.legendBuilder);
        return this.legendBuilder;
    }

    public HtmlLIBuilder startLI() {
        this.trustedStart("li", this.liBuilder);
        return this.liBuilder;
    }

    public HtmlLinkBuilder startLink() {
        if (this.linkBuilder == null) {
            this.linkBuilder = new HtmlLinkBuilder(this);
        }
        this.trustedStart("link", this.linkBuilder);
        return this.linkBuilder;
    }

    public HtmlMapBuilder startMap() {
        if (this.mapBuilder == null) {
            this.mapBuilder = new HtmlMapBuilder(this);
        }
        this.trustedStart("map", this.mapBuilder);
        return this.mapBuilder;
    }

    public HtmlMetaBuilder startMeta() {
        if (this.metaBuilder == null) {
            this.metaBuilder = new HtmlMetaBuilder(this);
        }
        this.trustedStart("meta", this.metaBuilder);
        return this.metaBuilder;
    }

    public HtmlOListBuilder startOList() {
        if (this.oListBuilder == null) {
            this.oListBuilder = new HtmlOListBuilder(this);
        }
        this.trustedStart("ol", this.oListBuilder);
        return this.oListBuilder;
    }

    public HtmlOptGroupBuilder startOptGroup() {
        if (this.optGroupBuilder == null) {
            this.optGroupBuilder = new HtmlOptGroupBuilder(this);
        }
        this.trustedStart("optgroup", this.optGroupBuilder);
        return this.optGroupBuilder;
    }

    public HtmlOptionBuilder startOption() {
        this.trustedStart("option", this.optionBuilder);
        return this.optionBuilder;
    }

    public HtmlParagraphBuilder startParagraph() {
        if (this.paragraphBuilder == null) {
            this.paragraphBuilder = new HtmlParagraphBuilder(this);
        }
        this.trustedStart("p", this.paragraphBuilder);
        return this.paragraphBuilder;
    }

    public HtmlParamBuilder startParam() {
        if (this.paramBuilder == null) {
            this.paramBuilder = new HtmlParamBuilder(this);
        }
        this.trustedStart("param", this.paramBuilder);
        return this.paramBuilder;
    }

    public HtmlInputBuilder startPasswordInput() {
        return this.startInput("password");
    }

    public HtmlPreBuilder startPre() {
        if (this.preBuilder == null) {
            this.preBuilder = new HtmlPreBuilder(this);
        }
        this.trustedStart("pre", this.preBuilder);
        return this.preBuilder;
    }

    public HtmlButtonBuilder startPushButton() {
        return this.startButton("button");
    }

    public HtmlQuoteBuilder startQuote() {
        return this.startQuote("q");
    }

    public HtmlInputBuilder startRadioInput(String name) {
        HtmlInputBuilder builder = this.startInput("radio");
        this.attribute("name", name);
        return builder;
    }

    public HtmlButtonBuilder startResetButton() {
        return this.startButton("reset");
    }

    public HtmlInputBuilder startResetInput() {
        return this.startInput("reset");
    }

    public HtmlScriptBuilder startScript() {
        if (this.scriptBuilder == null) {
            this.scriptBuilder = new HtmlScriptBuilder(this);
        }
        this.trustedStart("script", this.scriptBuilder);
        return this.scriptBuilder;
    }

    public HtmlSelectBuilder startSelect() {
        if (this.selectBuilder == null) {
            this.selectBuilder = new HtmlSelectBuilder(this);
        }
        this.trustedStart("select", this.selectBuilder);
        return this.selectBuilder;
    }

    public HtmlSourceBuilder startSource() {
        if (this.sourceBuilder == null) {
            this.sourceBuilder = new HtmlSourceBuilder(this);
        }
        this.trustedStart("source", this.sourceBuilder);
        return this.sourceBuilder;
    }

    public HtmlSpanBuilder startSpan() {
        this.trustedStart("span", this.spanBuilder);
        return this.spanBuilder;
    }

    public HtmlStyleBuilder startStyle() {
        if (this.styleBuilder == null) {
            this.styleBuilder = new HtmlStyleBuilder(this);
        }
        this.trustedStart("style", this.styleBuilder);
        return this.styleBuilder;
    }

    public HtmlButtonBuilder startSubmitButton() {
        return this.startButton("submit");
    }

    public HtmlInputBuilder startSubmitInput() {
        return this.startInput("submit");
    }

    public HtmlTableBuilder startTable() {
        if (this.tableBuilder == null) {
            this.tableBuilder = new HtmlTableBuilder(this);
        }
        this.trustedStart("table", this.tableBuilder);
        return this.tableBuilder;
    }

    public HtmlTableCaptionBuilder startTableCaption() {
        if (this.tableCaptionBuilder == null) {
            this.tableCaptionBuilder = new HtmlTableCaptionBuilder(this);
        }
        this.trustedStart("caption", this.tableCaptionBuilder);
        return this.tableCaptionBuilder;
    }

    public HtmlTableSectionBuilder startTBody() {
        return this.startTableSection("tbody");
    }

    public HtmlTableCellBuilder startTD() {
        this.trustedStart("td", this.tableCellBuilder);
        return this.tableCellBuilder;
    }

    public HtmlTextAreaBuilder startTextArea() {
        if (this.textAreaBuilder == null) {
            this.textAreaBuilder = new HtmlTextAreaBuilder(this);
        }
        this.trustedStart("textarea", this.textAreaBuilder);
        return this.textAreaBuilder;
    }

    public HtmlInputBuilder startTextInput() {
        return this.startInput("text");
    }

    public HtmlTableSectionBuilder startTFoot() {
        return this.startTableSection("tfoot");
    }

    public HtmlTableCellBuilder startTH() {
        this.trustedStart("th", this.tableCellBuilder);
        return this.tableCellBuilder;
    }

    public HtmlTableSectionBuilder startTHead() {
        return this.startTableSection("thead");
    }

    public HtmlTitleBuilder startTitle() {
        if (this.titleBuilder == null) {
            this.titleBuilder = new HtmlTitleBuilder(this);
        }
        this.trustedStart("title", this.titleBuilder);
        return this.titleBuilder;
    }

    public HtmlTableRowBuilder startTR() {
        this.trustedStart("tr", this.tableRowBuilder);
        return this.tableRowBuilder;
    }

    public HtmlUListBuilder startUList() {
        if (this.uListBuilder == null) {
            this.uListBuilder = new HtmlUListBuilder(this);
        }
        this.trustedStart("ul", this.uListBuilder);
        return this.uListBuilder;
    }

    public HtmlVideoBuilder startVideo() {
        if (this.videoBuilder == null) {
            this.videoBuilder = new HtmlVideoBuilder(this);
        }
        this.trustedStart("video", this.videoBuilder);
        return this.videoBuilder;
    }

    @Override
    public StylesBuilder style() {
        return this.stylesBuilder;
    }

    public StylesBuilder styleProperty(SafeStyles style) {
        this.assertCanAddStylePropertyImpl();
        this.sb.append(style.asString());
        return this.style();
    }

    public void trustedAttribute(String name, int value) {
        this.assertCanAddAttributeImpl();
        this.sb.append(" ").append(name).append("=\"").append(value).append("\"");
    }

    public void trustedAttribute(String name, String value) {
        this.assertCanAddAttributeImpl();
        this.sb.append(" ").append(name).append("=\"").append(this.escape(value)).append("\"");
    }

    public HtmlElementBuilder trustedStart(String tagName) {
        this.trustedStart(tagName, this.elementBuilder);
        return this.elementBuilder;
    }

    @Override
    protected void doCloseStartTagImpl() {
        this.sb.append(">");
    }

    @Override
    protected void doCloseStyleAttributeImpl() {
        this.sb.append("\"");
    }

    @Override
    protected void doEndStartTagImpl() {
        this.sb.append(" />");
    }

    @Override
    protected void doEndTagImpl(String tagName) {
        this.sb.append("</").append(tagName).append(">");
    }

    @Override
    protected Element doFinishImpl() {
        DivElement tmp = Document.get().createDivElement();
        tmp.setInnerSafeHtml(this.asSafeHtml());
        return tmp.getFirstChildElement();
    }

    @Override
    protected void doHtmlImpl(SafeHtml html) {
        this.sb.append(html.asString());
    }

    @Override
    protected void doOpenStyleImpl() {
        this.sb.append(" style=\"");
    }

    @Override
    protected void doTextImpl(String text) {
        this.sb.append(this.escape(text));
    }

    private String escape(String s) {
        return SafeHtmlUtils.htmlEscape(s);
    }

    private HtmlButtonBuilder startButton(String type) {
        if (this.buttonBuilder == null) {
            this.buttonBuilder = new HtmlButtonBuilder(this);
        }
        this.trustedStart("button", this.buttonBuilder);
        this.buttonBuilder.attribute("type", type);
        return this.buttonBuilder;
    }

    private HtmlHeadingBuilder startHeading(int level) {
        if (this.headingBuilder == null) {
            this.headingBuilder = new HtmlHeadingBuilder(this);
        }
        int n = level;
        this.trustedStart(new StringBuilder(12).append("h").append(n).toString(), this.headingBuilder);
        return this.headingBuilder;
    }

    private HtmlInputBuilder startInput(String type) {
        this.trustedStart("input", this.inputBuilder);
        this.attribute("type", type);
        return this.inputBuilder;
    }

    private HtmlQuoteBuilder startQuote(String tagName) {
        if (this.quoteBuilder == null) {
            this.quoteBuilder = new HtmlQuoteBuilder(this);
        }
        this.trustedStart(tagName, this.quoteBuilder);
        return this.quoteBuilder;
    }

    private HtmlTableSectionBuilder startTableSection(String tagName) {
        if (this.tableSectionBuilder == null) {
            this.tableSectionBuilder = new HtmlTableSectionBuilder(this);
        }
        this.trustedStart(tagName, this.tableSectionBuilder);
        return this.tableSectionBuilder;
    }

    private void trustedStart(String tagName, ElementBuilderBase<?> builder) {
        this.onStart(tagName, builder);
        this.sb.append("<").append(tagName);
    }
}

