/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.client;

import com.google.gwt.core.client.JavaScriptObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;

public final class Dictionary {
    private static Map<String, Dictionary> cache = new HashMap<String, Dictionary>();
    private static final int MAX_KEYS_TO_SHOW = 20;
    private JavaScriptObject dict;
    private String label;

    public static Dictionary getDictionary(String name) {
        Dictionary target = cache.get(name);
        if (target == null) {
            target = new Dictionary(name);
            cache.put(name, target);
        }
        return target;
    }

    static void resourceErrorBadType(String name) {
        String string = String.valueOf(String.valueOf(name));
        throw new MissingResourceException(new StringBuilder(64 + string.length()).append("'").append(string).append("' is not a JavaScript object and cannot be used as a Dictionary").toString(), null, name);
    }

    private Dictionary(String name) {
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException("Cannot create a Dictionary with a null or empty name");
        }
        String string = String.valueOf(name);
        this.label = string.length() != 0 ? "Dictionary ".concat(string) : new String("Dictionary ");
        this.attach(name);
        if (this.dict == null) {
            String string2 = String.valueOf(String.valueOf(name));
            throw new MissingResourceException(new StringBuilder(46 + string2.length()).append("Cannot find JavaScript object with the name '").append(string2).append("'").toString(), name, null);
        }
    }

    public native String get(String var1);

    public Set<String> keySet() {
        HashSet<String> s = new HashSet<String>();
        this.addKeys(s);
        return s;
    }

    public String toString() {
        return this.label;
    }

    public Collection<String> values() {
        ArrayList<String> s = new ArrayList<String>();
        this.addValues(s);
        return s;
    }

    void resourceError(String key) {
        String string = String.valueOf(String.valueOf(key));
        String string2 = String.valueOf(String.valueOf(this));
        String error = new StringBuilder(18 + string.length() + string2.length()).append("Cannot find '").append(string).append("' in ").append(string2).toString();
        throw new MissingResourceException(error, this.toString(), key);
    }

    private native void addKeys(HashSet<String> var1);

    private native void addValues(ArrayList<String> var1);

    private native void attach(String var1);
}

