/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.server;

import com.google.gwt.i18n.server.GwtLocaleImpl;
import com.google.gwt.i18n.shared.GwtLocale;
import com.google.gwt.i18n.shared.GwtLocaleFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class GwtLocaleFactoryImpl
implements GwtLocaleFactory {
    private final Object instanceCacheLock = new Object[0];
    private Map<GwtLocaleImpl, GwtLocaleImpl> instanceCache = new HashMap<GwtLocaleImpl, GwtLocaleImpl>();

    private static boolean isAlpha(String str, int min, int max) {
        return GwtLocaleFactoryImpl.matches(str, min, max, true);
    }

    private static boolean isDigit(String str, int min, int max) {
        return GwtLocaleFactoryImpl.matches(str, min, max, false);
    }

    private static boolean matches(String str, int min, int max, boolean lettersNotDigits) {
        int len = str.length();
        if (len < min || len > max) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if ((!lettersNotDigits || Character.isLetter(str.charAt(i))) && (lettersNotDigits || Character.isDigit(str.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    private static String titleCase(String str) {
        if (str.length() < 2) {
            return str.toUpperCase(Locale.ENGLISH);
        }
        String string = String.valueOf(String.valueOf(Character.toTitleCase(str.charAt(0))));
        String string2 = String.valueOf(str.substring(1).toLowerCase(Locale.ENGLISH));
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.instanceCacheLock;
        synchronized (object) {
            this.instanceCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GwtLocale fromComponents(String language, String script, String region, String variant) {
        if (language != null && language.length() == 0) {
            language = null;
        }
        if (language != null) {
            language = language.toLowerCase(Locale.ENGLISH);
        }
        if (script != null && script.length() == 0) {
            script = null;
        }
        if (script != null) {
            script = GwtLocaleFactoryImpl.titleCase(script);
        }
        if (region != null && region.length() == 0) {
            region = null;
        }
        if (region != null) {
            region = region.toUpperCase(Locale.ENGLISH);
        }
        if (variant != null && variant.length() == 0) {
            variant = null;
        }
        if (variant != null) {
            variant = variant.toUpperCase(Locale.ENGLISH);
        }
        GwtLocaleImpl locale = new GwtLocaleImpl(this, language, region, script, variant);
        Object object = this.instanceCacheLock;
        synchronized (object) {
            if (this.instanceCache.containsKey(locale)) {
                return this.instanceCache.get(locale);
            }
            this.instanceCache.put(locale, locale);
        }
        return locale;
    }

    @Override
    public GwtLocale fromString(String localeName) {
        String language = null;
        String script = null;
        String region = null;
        String variant = null;
        if (localeName != null && !"default".equals(localeName)) {
            int len;
            String part;
            int len2;
            ArrayList<String> localeParts = new ArrayList<String>();
            String[] parts = localeName.split("[-_]");
            for (int i = 0; i < parts.length; ++i) {
                if (parts[i].length() == 1 && i + 1 < parts.length) {
                    String string = String.valueOf(String.valueOf(parts[i]));
                    String string2 = String.valueOf(String.valueOf(parts[++i]));
                    localeParts.add(new StringBuilder(1 + string.length() + string2.length()).append(string).append("-").append(string2).toString());
                    continue;
                }
                localeParts.add(parts[i]);
            }
            int partIdx = 1;
            int numParts = localeParts.size();
            if (numParts > 0 && ((len2 = (language = (String)localeParts.get(0)).length()) == 2 || len2 == 3) && partIdx < numParts) {
                String part2 = (String)localeParts.get(partIdx);
                while (partIdx < numParts && partIdx < 4 && GwtLocaleFactoryImpl.isAlpha(part2, 3, 3)) {
                    String string = String.valueOf(language);
                    String string3 = String.valueOf(String.valueOf(part2));
                    language = new StringBuilder(1 + string.length() + string3.length()).append(string).append("-").append(string3).toString();
                    if (++partIdx >= numParts) break;
                    part2 = (String)localeParts.get(partIdx);
                }
            }
            if (numParts > partIdx && GwtLocaleFactoryImpl.isAlpha((String)localeParts.get(partIdx), 4, 4)) {
                script = (String)localeParts.get(partIdx++);
            }
            if (partIdx < numParts && (GwtLocaleFactoryImpl.isAlpha(part = (String)localeParts.get(partIdx), 2, 2) || GwtLocaleFactoryImpl.isDigit(part, 3, 3))) {
                region = part;
                ++partIdx;
            }
            if (partIdx < numParts && ((len = (part = (String)localeParts.get(partIdx)).length()) >= 5 && len <= 8 || len == 4 && Character.isDigit(part.charAt(0)))) {
                variant = part;
                ++partIdx;
            }
            if (partIdx < numParts) {
                String string = String.valueOf(localeName);
                throw new IllegalArgumentException(string.length() != 0 ? "Unrecognized locale format: ".concat(string) : new String("Unrecognized locale format: "));
            }
        }
        return this.fromComponents(language, script, region, variant);
    }

    @Override
    public GwtLocale getDefault() {
        return this.fromComponents(null, null, null, null);
    }
}

