/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.converter;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.util.DefaultTextOutput;
import com.google.gwt.dev.util.TextOutput;
import com.google.gwt.dev.util.log.PrintWriterTreeLogger;
import com.google.gwt.resources.converter.AlternateAnnotationCreatorVisitor;
import com.google.gwt.resources.converter.DefCollectorVisitor;
import com.google.gwt.resources.converter.ElseNodeCreator;
import com.google.gwt.resources.converter.FontFamilyVisitor;
import com.google.gwt.resources.converter.GssGenerationVisitor;
import com.google.gwt.resources.converter.UndefinedConstantVisitor;
import com.google.gwt.resources.css.GenerateCssAst;
import com.google.gwt.resources.css.ast.CssStylesheet;
import java.io.File;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;

public class Css2Gss {
    private final URL cssFile;
    private final TreeLogger treeLogger;
    private final boolean lenient;
    private PrintWriter printWriter;
    private Map<String, String> defNameMapping;

    public Css2Gss(String filePath) throws MalformedURLException {
        this(new File(filePath).toURI().toURL(), false);
    }

    public Css2Gss(URL fileUrl, TreeLogger treeLogger) {
        this(fileUrl, treeLogger, false);
    }

    public Css2Gss(URL fileUrl, TreeLogger treeLogger, boolean lenient) {
        this.cssFile = fileUrl;
        this.treeLogger = treeLogger;
        this.lenient = lenient;
    }

    public Css2Gss(URL resource, boolean lenient) {
        this.cssFile = resource;
        this.printWriter = new PrintWriter(System.err);
        this.treeLogger = new PrintWriterTreeLogger(this.printWriter);
        this.lenient = lenient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toGss() throws UnableToCompleteException {
        try {
            CssStylesheet sheet = GenerateCssAst.exec(this.treeLogger, this.cssFile);
            DefCollectorVisitor defCollectorVisitor = new DefCollectorVisitor(this.lenient, this.treeLogger);
            defCollectorVisitor.accept(sheet);
            this.defNameMapping = defCollectorVisitor.getDefMapping();
            new UndefinedConstantVisitor(new HashSet<String>(this.defNameMapping.values()), this.lenient, this.treeLogger).accept(sheet);
            new ElseNodeCreator().accept(sheet);
            new AlternateAnnotationCreatorVisitor().accept(sheet);
            new FontFamilyVisitor().accept(sheet);
            GssGenerationVisitor gssGenerationVisitor = new GssGenerationVisitor((TextOutput)new DefaultTextOutput(false), this.defNameMapping, this.lenient, this.treeLogger);
            gssGenerationVisitor.accept(sheet);
            String string = gssGenerationVisitor.getContent();
            return string;
        }
        finally {
            if (this.printWriter != null) {
                this.printWriter.flush();
            }
        }
    }

    public Map<String, String> getDefNameMapping() {
        return this.defNameMapping;
    }

    public static void main(String ... args) {
        if (args.length != 1) {
            Css2Gss.printUsage();
            System.exit(-1);
        }
        try {
            System.out.println(new Css2Gss(args[0]).toGss());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        System.exit(0);
    }

    private static void printUsage() {
        System.err.println("Usage :");
        String string = String.valueOf(String.valueOf(Css2Gss.class.getName()));
        System.err.println(new StringBuilder(27 + string.length()).append("java ").append(string).append(" fileNameToConvertPath").toString());
    }
}

