/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.converter;

import com.google.gwt.resources.converter.SimpleValue;
import com.google.gwt.resources.css.ast.Context;
import com.google.gwt.resources.css.ast.CssProperty;
import com.google.gwt.resources.css.ast.CssVisitor;
import com.google.gwt.thirdparty.guava.common.base.Splitter;
import java.util.regex.Pattern;

public class FontFamilyVisitor
extends CssVisitor {
    private static Pattern ESCAPE_TEST = Pattern.compile("^[^'\"].*\\s.*[^'\"]$");

    @Override
    public boolean visit(CssProperty x, Context ctx) {
        if ("font-family".equals(x.getName())) {
            CssProperty.ListValue values = x.getValues();
            String css = values.toCss();
            StringBuilder valueBuilder = new StringBuilder();
            boolean first = true;
            for (String subProperty : Splitter.on(",").trimResults().omitEmptyStrings().split(css)) {
                if (first) {
                    first = false;
                } else {
                    valueBuilder.append(",");
                }
                if (this.hasToBeEscaped(subProperty)) {
                    String string = String.valueOf(String.valueOf(subProperty));
                    valueBuilder.append(new StringBuilder(2 + string.length()).append("'").append(string).append("'").toString());
                    continue;
                }
                valueBuilder.append(subProperty);
            }
            x.setValue(new SimpleValue(valueBuilder.toString()));
        }
        return false;
    }

    private boolean hasToBeEscaped(String fontFamilyName) {
        return ESCAPE_TEST.matcher(fontFamilyName).matches();
    }
}

