/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.css;

import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.util.log.PrintWriterTreeLogger;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.css.DefsCollector;
import com.google.gwt.resources.css.ExtractClassNamesVisitor;
import com.google.gwt.resources.css.GenerateCssAst;
import com.google.gwt.resources.css.ast.CssStylesheet;
import com.google.gwt.user.rebind.StringSourceWriter;
import com.google.gwt.util.tools.ArgHandler;
import com.google.gwt.util.tools.ArgHandlerFile;
import com.google.gwt.util.tools.ArgHandlerFlag;
import com.google.gwt.util.tools.ArgHandlerString;
import com.google.gwt.util.tools.ToolBase;
import java.io.File;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeSet;

public class InterfaceGenerator
extends ToolBase {
    private static final Comparator<String> NAME_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    };
    private static final TreeLogger.Type LOG_LEVEL = TreeLogger.WARN;
    private String interfaceName;
    private File inputFile;
    private TreeLogger logger;
    private boolean standaloneFile;

    public static void main(String[] args) {
        new InterfaceGenerator().execImpl(args);
    }

    private InterfaceGenerator() {
        this.registerHandler((ArgHandler)new ArgHandlerAddPackageHeader());
        this.registerHandler((ArgHandler)new ArgHandlerString(){

            public String getPurpose() {
                return "The name of the generated CssResource subtype";
            }

            public String getTag() {
                return "-typeName";
            }

            public String[] getTagArgs() {
                return new String[]{"some.package.MyCssResource"};
            }

            public boolean isRequired() {
                return true;
            }

            public boolean setString(String str) {
                if (str.length() == 0) {
                    return false;
                }
                if (!Character.isJavaIdentifierStart(str.charAt(0))) {
                    return false;
                }
                int j = str.length();
                for (int i = 1; i < j; ++i) {
                    char c = str.charAt(i);
                    if (Character.isJavaIdentifierPart(c) || c == '.') continue;
                    return false;
                }
                InterfaceGenerator.this.interfaceName = str;
                if (InterfaceGenerator.this.logger.isLoggable(TreeLogger.DEBUG)) {
                    String string = String.valueOf(InterfaceGenerator.this.interfaceName);
                    InterfaceGenerator.this.logger.log(TreeLogger.DEBUG, string.length() != 0 ? "interfaceName = ".concat(string) : new String("interfaceName = "));
                }
                return true;
            }
        });
        this.registerHandler((ArgHandler)new ArgHandlerFile(){

            public String getPurpose() {
                return "The input CSS file to process";
            }

            public String getTag() {
                return "-css";
            }

            public boolean isRequired() {
                return true;
            }

            public void setFile(File file) {
                InterfaceGenerator.this.inputFile = file;
                if (InterfaceGenerator.this.logger.isLoggable(TreeLogger.DEBUG)) {
                    String string = String.valueOf(file.getAbsolutePath());
                    InterfaceGenerator.this.logger.log(TreeLogger.DEBUG, string.length() != 0 ? "inputFile = ".concat(string) : new String("inputFile = "));
                }
            }
        });
    }

    protected String getDescription() {
        return "Create a CssResource interface based on a CSS file";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execImpl(String[] args) {
        PrintWriter logWriter = new PrintWriter(System.err);
        this.logger = new PrintWriterTreeLogger(logWriter);
        ((PrintWriterTreeLogger)this.logger).setMaxDetail(LOG_LEVEL);
        if (!this.processArgs(args)) {
            System.exit(-1);
        }
        boolean error = false;
        try {
            System.out.println(this.process());
        }
        catch (MalformedURLException e) {
            this.logger.log(TreeLogger.ERROR, "Unable to load CSS", (Throwable)e);
            error = true;
        }
        catch (UnableToCompleteException e) {
            this.logger.log(TreeLogger.ERROR, "Unable to process CSS", (Throwable)e);
            error = true;
        }
        finally {
            logWriter.flush();
        }
        System.exit(error ? -1 : 0);
    }

    private String methodName(String className) {
        StringBuilder sb = new StringBuilder();
        char c = className.charAt(0);
        boolean nextUpCase = false;
        if (Character.isJavaIdentifierStart(c)) {
            sb.append(Character.toLowerCase(c));
        }
        int j = className.length();
        for (int i = 1; i < j; ++i) {
            c = className.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                nextUpCase = true;
                continue;
            }
            if (nextUpCase) {
                nextUpCase = false;
                c = Character.toUpperCase(c);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private String process() throws MalformedURLException, UnableToCompleteException {
        String string;
        CssStylesheet sheet = GenerateCssAst.exec(this.logger, this.inputFile.toURI().toURL());
        TreeSet<String> names = new TreeSet<String>(NAME_COMPARATOR);
        names.addAll(ExtractClassNamesVisitor.exec(sheet));
        DefsCollector defs = new DefsCollector();
        defs.accept(sheet);
        names.addAll(defs.getDefs());
        HashSet<String> methodNames = new HashSet<String>();
        StringSourceWriter sw = new StringSourceWriter();
        int lastDot = this.interfaceName.lastIndexOf(46);
        if (this.standaloneFile) {
            sw.println("// DO NOT EDIT");
            String string2 = String.valueOf(InterfaceGenerator.class.getName());
            sw.println(string2.length() != 0 ? "// Automatically generated by ".concat(string2) : new String("// Automatically generated by "));
            string = String.valueOf(String.valueOf(this.interfaceName.substring(0, lastDot)));
            sw.println(new StringBuilder(9 + string.length()).append("package ").append(string).append(";").toString());
            String string3 = String.valueOf(String.valueOf(CssResource.class.getCanonicalName()));
            sw.println(new StringBuilder(8 + string3.length()).append("import ").append(string3).append(";").toString());
            String string4 = String.valueOf(String.valueOf(CssResource.ClassName.class.getCanonicalName()));
            sw.println(new StringBuilder(8 + string4.length()).append("import ").append(string4).append(";").toString());
        }
        string = String.valueOf(String.valueOf(this.interfaceName.substring(lastDot + 1)));
        sw.println(new StringBuilder(32 + string.length()).append("interface ").append(string).append(" extends CssResource {").toString());
        sw.indent();
        for (String className : names) {
            String string5;
            String methodName = this.methodName(className);
            while (!methodNames.add(methodName)) {
                methodName = String.valueOf(methodName).concat("_");
            }
            sw.println();
            if (!methodName.equals(className)) {
                string5 = String.valueOf(String.valueOf(Generator.escape((String)className)));
                sw.println(new StringBuilder(14 + string5.length()).append("@ClassName(\"").append(string5).append("\")").toString());
            }
            string5 = String.valueOf(String.valueOf(methodName));
            sw.println(new StringBuilder(10 + string5.length()).append("String ").append(string5).append("();").toString());
        }
        sw.outdent();
        sw.println("}");
        return sw.toString();
    }

    private class ArgHandlerAddPackageHeader
    extends ArgHandlerFlag {
        public ArgHandlerAddPackageHeader() {
            this.addTagValue("-standalone", true);
        }

        public String getPurposeSnippet() {
            return "Add package and import statements to generated interface so that they are still functional when they stand alone.";
        }

        public String getLabel() {
            return "addPackageHeader";
        }

        public boolean setFlag(boolean value) {
            InterfaceGenerator.this.standaloneFile = value;
            InterfaceGenerator.this.logger.log(TreeLogger.DEBUG, value ? "Not creating" : "Creating a standalone file");
            return true;
        }

        public boolean getDefaultValue() {
            return InterfaceGenerator.this.standaloneFile;
        }
    }
}

