/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.css;

import com.google.gwt.core.shared.impl.StringCase;
import com.google.gwt.resources.css.ast.Context;
import com.google.gwt.resources.css.ast.CssCompilerException;
import com.google.gwt.resources.css.ast.CssModVisitor;
import com.google.gwt.resources.css.ast.CssNoFlip;
import com.google.gwt.resources.css.ast.CssProperty;
import com.google.gwt.resources.css.ast.CssRule;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class RtlVisitor
extends CssModVisitor {
    private boolean inBodyRule;

    @Override
    public void endVisit(CssProperty x, Context ctx) {
        String name = x.getName();
        if (name.equalsIgnoreCase("left")) {
            x.setName("right");
        } else if (name.equalsIgnoreCase("right")) {
            x.setName("left");
        } else if (name.endsWith("-left")) {
            int len = name.length();
            x.setName(String.valueOf(name.substring(0, len - 4)).concat("right"));
        } else if (name.endsWith("-right")) {
            int len = name.length();
            x.setName(String.valueOf(name.substring(0, len - 5)).concat("left"));
        } else if (name.contains("-right-")) {
            x.setName(name.replace("-right-", "-left-"));
        } else if (name.contains("-left-")) {
            x.setName(name.replace("-left-", "-right-"));
        } else {
            ArrayList<CssProperty.Value> values = new ArrayList<CssProperty.Value>(x.getValues().getValues());
            this.invokePropertyHandler(x.getName(), values);
            x.setValue(new CssProperty.ListValue(values));
        }
    }

    @Override
    public boolean visit(CssNoFlip x, Context ctx) {
        return false;
    }

    @Override
    public boolean visit(CssRule x, Context ctx) {
        this.inBodyRule = x.getSelectors().size() == 1 && x.getSelectors().get(0).getSelector().equals("body");
        return true;
    }

    void propertyHandlerBackground(List<CssProperty.Value> values) {
        boolean seenLeft = false;
        ListIterator<CssProperty.Value> it = values.listIterator();
        while (it.hasNext()) {
            CssProperty.Value v = it.next();
            CssProperty.Value maybeFlipped = this.flipLeftRightIdentValue(v);
            CssProperty.NumberValue nv = v.isNumberValue();
            if (v != maybeFlipped) {
                it.set(maybeFlipped);
                seenLeft = true;
                continue;
            }
            if (this.isIdent(v, "center")) {
                seenLeft = true;
                continue;
            }
            if (seenLeft || nv == null) continue;
            seenLeft = true;
            if (!"%".equals(nv.getUnits())) continue;
            float position = 100.0f - nv.getValue();
            it.set(new CssProperty.NumberValue(position, "%"));
            break;
        }
    }

    void propertyHandlerBackgroundPosition(List<CssProperty.Value> values) {
        this.propertyHandlerBackground(values);
    }

    CssProperty.Value propertyHandlerBackgroundPositionX(CssProperty.Value v) {
        ArrayList<CssProperty.Value> list = new ArrayList<CssProperty.Value>(1);
        list.add(v);
        this.propertyHandlerBackground(list);
        return list.get(0);
    }

    void propertyHandlerBorderColor(List<CssProperty.Value> values) {
        this.swapFour(values);
    }

    void propertyHandlerBorderStyle(List<CssProperty.Value> values) {
        this.swapFour(values);
    }

    void propertyHandlerBorderWidth(List<CssProperty.Value> values) {
        this.swapFour(values);
    }

    CssProperty.Value propertyHandlerClear(CssProperty.Value v) {
        return this.propertyHandlerFloat(v);
    }

    CssProperty.Value propertyHandlerCursor(CssProperty.Value v) {
        CssProperty.IdentValue identValue = v.isIdentValue();
        if (identValue == null) {
            return v;
        }
        String ident = StringCase.toLower(identValue.getIdent());
        if (!ident.endsWith("-resize")) {
            return v;
        }
        StringBuffer newIdent = new StringBuffer();
        if (ident.length() == 9) {
            if (ident.charAt(0) == 'n') {
                newIdent.append('n');
                ident = ident.substring(1);
            } else if (ident.charAt(0) == 's') {
                newIdent.append('s');
                ident = ident.substring(1);
            } else {
                return v;
            }
        }
        if (ident.length() == 8) {
            if (ident.charAt(0) == 'e') {
                newIdent.append("w-resize");
            } else if (ident.charAt(0) == 'w') {
                newIdent.append("e-resize");
            } else {
                return v;
            }
            return new CssProperty.IdentValue(newIdent.toString());
        }
        return v;
    }

    CssProperty.Value propertyHandlerDirection(CssProperty.Value v) {
        if (this.inBodyRule) {
            if (this.isIdent(v, "ltr")) {
                return new CssProperty.IdentValue("rtl");
            }
            if (this.isIdent(v, "rtl")) {
                return new CssProperty.IdentValue("ltr");
            }
        }
        return v;
    }

    CssProperty.Value propertyHandlerFloat(CssProperty.Value v) {
        return this.flipLeftRightIdentValue(v);
    }

    void propertyHandlerMargin(List<CssProperty.Value> values) {
        this.swapFour(values);
    }

    void propertyHandlerPadding(List<CssProperty.Value> values) {
        this.swapFour(values);
    }

    CssProperty.Value propertyHandlerPageBreakAfter(CssProperty.Value v) {
        return this.flipLeftRightIdentValue(v);
    }

    CssProperty.Value propertyHandlerPageBreakBefore(CssProperty.Value v) {
        return this.flipLeftRightIdentValue(v);
    }

    CssProperty.Value propertyHandlerTextAlign(CssProperty.Value v) {
        return this.flipLeftRightIdentValue(v);
    }

    private CssProperty.Value flipLeftRightIdentValue(CssProperty.Value v) {
        if (this.isIdent(v, "right")) {
            return new CssProperty.IdentValue("left");
        }
        if (this.isIdent(v, "left")) {
            return new CssProperty.IdentValue("right");
        }
        return v;
    }

    private void invokePropertyHandler(String name, List<CssProperty.Value> values) {
        try {
            Method m;
            String[] parts = StringCase.toLower(name).split("-");
            StringBuffer methodName = new StringBuffer("propertyHandler");
            for (String part : parts) {
                if (part.length() <= 0) continue;
                methodName.append(Character.toUpperCase(part.charAt(0)));
                methodName.append(part, 1, part.length());
            }
            try {
                m = this.getClass().getDeclaredMethod(methodName.toString(), CssProperty.Value.class);
                assert (CssProperty.Value.class.isAssignableFrom(m.getReturnType()));
                CssProperty.Value newValue = (CssProperty.Value)m.invoke((Object)this, values.get(0));
                values.set(0, newValue);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            try {
                m = this.getClass().getDeclaredMethod(methodName.toString(), List.class);
                m.invoke((Object)this, values);
            }
            catch (NoSuchMethodException e) {}
        }
        catch (SecurityException e) {
            String string = String.valueOf(name);
            throw new CssCompilerException(string.length() != 0 ? "Unable to invoke property handler function for ".concat(string) : new String("Unable to invoke property handler function for "), e);
        }
        catch (IllegalArgumentException e) {
            String string = String.valueOf(name);
            throw new CssCompilerException(string.length() != 0 ? "Unable to invoke property handler function for ".concat(string) : new String("Unable to invoke property handler function for "), e);
        }
        catch (IllegalAccessException e) {
            String string = String.valueOf(name);
            throw new CssCompilerException(string.length() != 0 ? "Unable to invoke property handler function for ".concat(string) : new String("Unable to invoke property handler function for "), e);
        }
        catch (InvocationTargetException e) {
            String string = String.valueOf(name);
            throw new CssCompilerException(string.length() != 0 ? "Unable to invoke property handler function for ".concat(string) : new String("Unable to invoke property handler function for "), e);
        }
    }

    private boolean isIdent(CssProperty.Value value, String query) {
        CssProperty.IdentValue v = value.isIdentValue();
        return v != null && v.getIdent().equalsIgnoreCase(query);
    }

    private void swapFour(List<CssProperty.Value> values) {
        if (values.size() == 4) {
            Collections.swap(values, 1, 3);
        }
    }
}

