/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.gss;

import com.google.gwt.thirdparty.common.css.SourceCodeLocation;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompositeValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssLiteralNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssStringNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssUnknownAtRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.ErrorManager;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssError;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class ExternalClassesCollector
extends DefaultTreeVisitor
implements CssCompilerPass {
    public static final String EXTERNAL_AT_RULE = "external";
    private static final String STAR_SUFFIX = "*";
    private final MutatingVisitController visitController;
    private final ErrorManager errorManager;
    private Set<String> externalClassNames;
    private List<String> externalClassPrefixes;
    private boolean matchAll;

    public ExternalClassesCollector(MutatingVisitController visitController, ErrorManager errorManager) {
        this.visitController = visitController;
        this.errorManager = errorManager;
    }

    public void runPass() {
        this.externalClassNames = new HashSet<String>();
        this.externalClassPrefixes = new ArrayList<String>();
        this.visitController.startVisit((CssTreeVisitor)this);
    }

    public void leaveUnknownAtRule(CssUnknownAtRuleNode node) {
        if (EXTERNAL_AT_RULE.equals(node.getName().getValue())) {
            if (!this.matchAll) {
                this.processParameters(node.getParameters(), node.getSourceCodeLocation());
            }
            this.visitController.removeCurrentNode();
        }
    }

    public Set<String> getExternalClassNames(Set<String> styleClassesSet) {
        TreeSet<String> classNames = new TreeSet<String>(styleClassesSet);
        if (this.matchAll) {
            return classNames;
        }
        for (String prefix : this.externalClassPrefixes) {
            String styleClass;
            Iterator i$ = classNames.tailSet(prefix).iterator();
            while (i$.hasNext() && (styleClass = (String)i$.next()).startsWith(prefix)) {
                this.externalClassNames.add(styleClass);
            }
        }
        return this.externalClassNames;
    }

    private void processParameters(List<CssValueNode> values, SourceCodeLocation sourceCodeLocation) {
        for (CssValueNode value : values) {
            if (value instanceof CssCompositeValueNode) {
                this.processParameters(((CssCompositeValueNode)value).getValues(), sourceCodeLocation);
                continue;
            }
            if (value instanceof CssStringNode) {
                String selector = ((CssStringNode)value).getConcreteValue();
                if (STAR_SUFFIX.equals(selector)) {
                    this.matchAll = true;
                    return;
                }
                if (selector.endsWith(STAR_SUFFIX)) {
                    this.externalClassPrefixes.add(selector.substring(0, selector.length() - 1));
                    continue;
                }
                this.externalClassNames.add(selector);
                continue;
            }
            if (value instanceof CssLiteralNode) {
                this.externalClassNames.add(value.getValue());
                continue;
            }
            String string = String.valueOf(String.valueOf("External at-rule invalid. The following terms is not accepted in an external at-rule ["));
            String string2 = String.valueOf(String.valueOf(value.getValue()));
            this.errorManager.report(new GssError(new StringBuilder(1 + string.length() + string2.length()).append(string).append(string2).append("]").toString(), sourceCodeLocation));
        }
    }
}

