/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.rg;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.shared.impl.StringCase;
import com.google.gwt.dev.util.log.PrintWriterTreeLogger;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.resources.rg.UnsuitableForStripException;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.w3c.dom.Node;

class ImageBundleBuilder {
    static final String BUNDLE_FILE_TYPE = "png";
    static final String BUNDLE_MIME_TYPE = "image/png";
    private static final int IMAGE_MAX_SIZE = Integer.getInteger("gwt.imageResource.maxBundleSize", 256);
    private final Map<String, ImageRect> imageNameToImageRectMap = new HashMap<String, ImageRect>();

    public static void main(String[] args) {
        PrintWriterTreeLogger logger = new PrintWriterTreeLogger(new PrintWriter(System.out));
        if (args.length < 2) {
            logger.log(TreeLogger.ERROR, String.valueOf(ImageBundleBuilder.class.getSimpleName()).concat(" <output file> <input file> ..."));
            System.exit(-1);
        }
        ImageBundleBuilder builder = new ImageBundleBuilder();
        boolean fail = false;
        int j = args.length;
        for (int i = 1; i < j; ++i) {
            String string = String.valueOf(args[i]);
            TreeLogger loopLogger = logger.branch(TreeLogger.DEBUG, string.length() != 0 ? "Processing argument ".concat(string) : new String("Processing argument "));
            File file = new File(args[i]);
            Throwable ex = null;
            try {
                builder.assimilate(loopLogger, args[i], file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                ex = e;
            }
            catch (UnableToCompleteException e) {
                ex = e;
            }
            catch (UnsuitableForStripException e) {
                ex = e;
            }
            if (ex == null) continue;
            loopLogger.log(TreeLogger.ERROR, "Unable to assimilate image", ex);
            fail = true;
        }
        if (fail) {
            System.exit(-1);
        }
        String outFile = args[0];
        try {
            BufferedImage bundledImage = builder.drawBundledImage(new BestFitArranger());
            byte[] bytes = ImageBundleBuilder.createImageBytes((TreeLogger)logger, bundledImage);
            FileOutputStream out = new FileOutputStream(outFile);
            out.write(bytes);
            out.close();
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "Unable to write output file", (Throwable)e);
            System.exit(-2);
        }
        catch (UnableToCompleteException e) {
            logger.log(TreeLogger.ERROR, "Unable to draw output image", (Throwable)e);
            System.exit(-2);
        }
        System.exit(0);
    }

    public static byte[] toPng(TreeLogger logger, ImageRect rect) throws UnableToCompleteException {
        BufferedImage bundledImage = new BufferedImage(rect.getWidth(), rect.getHeight(), 3);
        SpeedTracerLogger.Event createGraphicsEvent = SpeedTracerLogger.start((SpeedTracerLogger.EventType)CompilerEventType.GRAPHICS_INIT, (String[])new String[]{"java.awt.headless", System.getProperty("java.awt.headless")});
        Graphics2D g2d = bundledImage.createGraphics();
        createGraphicsEvent.end(new String[0]);
        ImageBundleBuilder.setBetterRenderingQuality(g2d);
        g2d.drawImage(rect.getImage(), rect.transform(), null);
        g2d.dispose();
        byte[] imageBytes = ImageBundleBuilder.createImageBytes(logger, bundledImage);
        return imageBytes;
    }

    private static byte[] createImageBytes(TreeLogger logger, BufferedImage bundledImage) throws UnableToCompleteException {
        byte[] imageBytes;
        try {
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            boolean writerAvailable = ImageIO.write((RenderedImage)bundledImage, BUNDLE_FILE_TYPE, byteOutputStream);
            if (!writerAvailable) {
                logger.log(TreeLogger.ERROR, "No png writer available");
                throw new UnableToCompleteException();
            }
            imageBytes = byteOutputStream.toByteArray();
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "An error occurred while trying to write the image bundle.", (Throwable)e);
            throw new UnableToCompleteException();
        }
        return imageBytes;
    }

    private static int gcd(int a, int b) {
        while (b != 0) {
            int t = b;
            b = a % b;
            a = t;
        }
        return a;
    }

    private static int lcm(int a, int b) {
        return b / ImageBundleBuilder.gcd(a, b) * a;
    }

    private static void setBetterRenderingQuality(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
    }

    public ImageBundleBuilder() {
    }

    public ImageBundleBuilder(ImageBundleBuilder other) {
        for (Map.Entry<String, ImageRect> entry : other.imageNameToImageRectMap.entrySet()) {
            this.imageNameToImageRectMap.put(entry.getKey(), new ImageRect(entry.getValue()));
        }
    }

    public ImageRect assimilate(TreeLogger logger, String imageName, URL resource) throws UnableToCompleteException, UnsuitableForStripException {
        ImageRect rect = this.getMapping(imageName);
        if (rect == null) {
            rect = this.addImage(logger, imageName, resource);
            this.imageNameToImageRectMap.put(imageName, rect);
        }
        return rect;
    }

    public int getImageCount() {
        return this.imageNameToImageRectMap.size();
    }

    public ImageRect getMapping(String imageName) {
        return this.imageNameToImageRectMap.get(imageName);
    }

    public ImageRect removeMapping(String imageName) {
        return this.imageNameToImageRectMap.remove(imageName);
    }

    public byte[] render(TreeLogger logger, Arranger arranger) throws UnableToCompleteException {
        if (this.imageNameToImageRectMap.isEmpty()) {
            return null;
        }
        BufferedImage bundledImage = this.drawBundledImage(arranger);
        byte[] imageBytes = ImageBundleBuilder.createImageBytes(logger, bundledImage);
        return imageBytes;
    }

    private ImageRect addImage(TreeLogger logger, String imageName, URL imageUrl) throws UnableToCompleteException, UnsuitableForStripException {
        String string = String.valueOf(String.valueOf(imageName));
        logger = logger.branch(TreeLogger.TRACE, new StringBuilder(15 + string.length()).append("Adding image '").append(string).append("'").toString(), null);
        BufferedImage image = null;
        boolean lossy = true;
        try {
            MemoryCacheImageInputStream input = new MemoryCacheImageInputStream(imageUrl.openStream());
            Iterator<ImageReader> it = ImageIO.getImageReaders(input);
            block7: while (it.hasNext()) {
                ImageReader reader = it.next();
                reader.setInput(input);
                int numImages = reader.getNumImages(true);
                if (numImages == 0) continue;
                if (numImages == 1) {
                    try {
                        image = reader.read(0);
                        IIOMetadata metadata = reader.getImageMetadata(0);
                        if (metadata == null || !metadata.isStandardMetadataFormatSupported()) continue;
                        Node data = metadata.getAsTree("javax_imageio_1.0");
                        int j = data.getChildNodes().getLength();
                        for (int i = 0; i < j; ++i) {
                            Node child = data.getChildNodes().item(i);
                            if (!child.getLocalName().equalsIgnoreCase("compression")) continue;
                            int l = child.getChildNodes().getLength();
                            for (int k = 0; k < l; ++k) {
                                Node child2 = child.getChildNodes().item(k);
                                if (!child2.getLocalName().equalsIgnoreCase("lossless")) continue;
                                Node value = child2.getAttributes().getNamedItem("value");
                                if (value == null) {
                                    lossy = false;
                                    continue block7;
                                }
                                lossy = !Boolean.parseBoolean(value.getNodeValue());
                                continue block7;
                            }
                        }
                        continue;
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                BufferedImage[] images = new BufferedImage[numImages];
                try {
                    for (int i = 0; i < numImages; ++i) {
                        images[i] = reader.read(i);
                    }
                }
                catch (Exception e) {
                    continue;
                }
                ImageRect rect = new ImageRect(imageName, images);
                throw new UnsuitableForStripException(rect);
            }
        }
        catch (IllegalArgumentException iex) {
            if (StringCase.toLower(imageName).endsWith(BUNDLE_FILE_TYPE) && iex.getMessage() != null && iex.getStackTrace()[0].getClassName().equals("javax.imageio.ImageTypeSpecifier$Indexed")) {
                logger.log(TreeLogger.ERROR, "Unable to read image. The image may not be in valid PNG format. This problem may also be due to a bug in versions of the JRE prior to 1.6. See http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=5098176 for more information. If this bug is the cause of the error, try resaving the image using a different image program, or upgrade to a newer JRE.", null);
                throw new UnableToCompleteException();
            }
            throw iex;
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "Unable to read image resource", (Throwable)e);
            throw new UnableToCompleteException();
        }
        if (image == null) {
            logger.log(TreeLogger.ERROR, "Unrecognized image file format", null);
            throw new UnableToCompleteException();
        }
        ImageRect toReturn = new ImageRect(imageName, image);
        toReturn.setLossy(lossy);
        if (lossy || toReturn.getHeight() > IMAGE_MAX_SIZE || toReturn.getWidth() > IMAGE_MAX_SIZE) {
            throw new UnsuitableForStripException(toReturn);
        }
        return toReturn;
    }

    private BufferedImage drawBundledImage(Arranger arranger) {
        LinkedList<ImageRect> imageRects = new LinkedList<ImageRect>(this.imageNameToImageRectMap.values());
        Size size = arranger.arrangeImages(imageRects);
        BufferedImage bundledImage = new BufferedImage(size.width, size.height, 3);
        SpeedTracerLogger.Event graphicsEvent = SpeedTracerLogger.start((SpeedTracerLogger.EventType)CompilerEventType.GRAPHICS_INIT, (String[])new String[]{"java.awt.headless", System.getProperty("java.awt.headless")});
        Graphics2D g2d = bundledImage.createGraphics();
        ImageBundleBuilder.setBetterRenderingQuality(g2d);
        graphicsEvent.end(new String[0]);
        for (ImageRect imageRect : imageRects) {
            g2d.drawImage(imageRect.getImage(), imageRect.transform(), null);
        }
        g2d.dispose();
        return bundledImage;
    }

    static class VerticalArranger
    implements Arranger {
        VerticalArranger() {
        }

        @Override
        public Size arrangeImages(Collection<ImageRect> rects) {
            int height = 0;
            int width = 1;
            for (ImageRect rect : rects) {
                rect.setPosition(0, height);
                width = ImageBundleBuilder.lcm(width, rect.getWidth());
                height += rect.getHeight();
            }
            ArrayList<ImageRect> toAdd = new ArrayList<ImageRect>();
            for (ImageRect rect : rects) {
                for (int x = rect.getWidth(); x < width; x += rect.getWidth()) {
                    ImageRect newRect = new ImageRect(rect);
                    newRect.setPosition(x, rect.getTop());
                    toAdd.add(newRect);
                }
            }
            rects.addAll(toAdd);
            return new Size(width, height);
        }
    }

    static class Size {
        private final int width;
        private final int height;

        Size(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }

    static class ImageRect {
        private boolean hasBeenPositioned;
        private boolean lossy;
        private int height;
        private int width;
        private final int intrinsicHeight;
        private final int intrinsicWidth;
        private final BufferedImage[] images;
        private int left;
        private int top;
        private final String name;
        private final AffineTransform transform = new AffineTransform();

        public ImageRect(ImageRect other) {
            this.name = other.getName();
            this.height = other.height;
            this.width = other.width;
            this.images = other.getImages();
            this.left = other.getLeft();
            this.top = other.getTop();
            this.intrinsicHeight = other.intrinsicHeight;
            this.intrinsicWidth = other.intrinsicWidth;
            this.setTransform(other.getTransform());
        }

        public ImageRect(String name, BufferedImage ... images) {
            this.name = name;
            this.images = images;
            this.intrinsicWidth = images[0].getWidth();
            this.intrinsicHeight = images[0].getHeight();
            this.width = -1;
            this.height = -1;
        }

        public int getHeight() {
            return this.height > 0 ? this.height : this.intrinsicHeight;
        }

        public BufferedImage getImage() {
            return this.images[0];
        }

        public BufferedImage[] getImages() {
            return this.images;
        }

        public int getLeft() {
            return this.left;
        }

        public String getName() {
            return this.name;
        }

        public int getTop() {
            return this.top;
        }

        public AffineTransform getTransform() {
            return new AffineTransform(this.transform);
        }

        public int getWidth() {
            return this.width > 0 ? this.width : this.intrinsicWidth;
        }

        public boolean hasBeenPositioned() {
            return this.hasBeenPositioned;
        }

        public boolean isAnimated() {
            return this.images.length > 1;
        }

        public boolean isLossy() {
            return this.lossy;
        }

        public void setHeight(int height) {
            this.height = height;
            if (this.width <= 0) {
                this.width = (int)Math.round((double)height / (double)this.intrinsicHeight * (double)this.intrinsicWidth);
            }
        }

        public void setLossy(boolean lossy) {
            this.lossy = lossy;
        }

        public void setPosition(int left, int top) {
            this.hasBeenPositioned = true;
            this.left = left;
            this.top = top;
        }

        public void setTransform(AffineTransform transform) {
            this.transform.setTransform(transform);
        }

        public void setWidth(int width) {
            this.width = width;
            if (this.height <= 0) {
                this.height = (int)Math.round((double)width / (double)this.intrinsicWidth * (double)this.intrinsicHeight);
            }
        }

        public AffineTransform transform() {
            AffineTransform toReturn = new AffineTransform();
            toReturn.translate(this.left, this.top);
            assert (!(this.height > 0 ^ this.width > 0));
            if (this.height > 0) {
                toReturn.scale((double)this.height / (double)this.intrinsicHeight, (double)this.width / (double)this.intrinsicWidth);
            }
            toReturn.concatenate(this.transform);
            assert (this.checkTransform(toReturn));
            return toReturn;
        }

        private boolean checkTransform(AffineTransform tx) {
            double[] in = new double[]{0.0, 0.0, this.intrinsicWidth, this.intrinsicHeight};
            double[] out = new double[]{0.0, 0.0, 0.0, 0.0};
            tx.transform(in, 0, out, 0, 2);
            assert (out[0] >= 0.0);
            assert (out[1] >= 0.0);
            assert (out[2] >= 0.0);
            assert (out[3] >= 0.0);
            if (!$assertionsDisabled && (long)this.getWidth() != Math.round(Math.abs(out[0] - out[2]))) {
                int n = this.getWidth();
                long l = Math.round(Math.abs(out[0] - out[2]));
                throw new AssertionError((Object)new StringBuilder(41).append("Width ").append(n).append(" != ").append(l).toString());
            }
            if (!$assertionsDisabled && (long)this.getHeight() != Math.round(Math.abs(out[1] - out[3]))) {
                int n = this.getHeight();
                long l = Math.round(Math.abs(out[1] - out[3]));
                throw new AssertionError((Object)new StringBuilder(40).append("Height ").append(n).append("!=").append(l).toString());
            }
            return true;
        }
    }

    static class IdentityArranger
    implements Arranger {
        IdentityArranger() {
        }

        @Override
        public Size arrangeImages(Collection<ImageRect> rects) {
            int height = 0;
            int width = 0;
            for (ImageRect rect : rects) {
                height = Math.max(height, rect.getTop() + rect.getHeight());
                width = Math.max(width, rect.getLeft() + rect.getWidth());
            }
            return new Size(width, height);
        }
    }

    static class HorizontalArranger
    implements Arranger {
        HorizontalArranger() {
        }

        @Override
        public Size arrangeImages(Collection<ImageRect> rects) {
            int height = 1;
            int width = 0;
            for (ImageRect rect : rects) {
                rect.setPosition(width, 0);
                width += rect.getWidth();
                height = ImageBundleBuilder.lcm(height, rect.getHeight());
            }
            ArrayList<ImageRect> toAdd = new ArrayList<ImageRect>();
            for (ImageRect rect : rects) {
                for (int y = rect.getHeight(); y < height; y += rect.getHeight()) {
                    ImageRect newRect = new ImageRect(rect);
                    newRect.setPosition(rect.getLeft(), y);
                    toAdd.add(newRect);
                }
            }
            rects.addAll(toAdd);
            return new Size(width, height);
        }
    }

    static class BestFitArranger
    implements Arranger {
        private static final Comparator<ImageRect> decreasingHeightComparator = new Comparator<ImageRect>(){

            @Override
            public int compare(ImageRect a, ImageRect b) {
                int c = b.getHeight() - a.getHeight();
                return c != 0 ? c : b.getName().compareTo(a.getName());
            }
        };
        private static final Comparator<ImageRect> decreasingWidthComparator = new Comparator<ImageRect>(){

            @Override
            public int compare(ImageRect a, ImageRect b) {
                int c = b.getWidth() - a.getWidth();
                return c != 0 ? c : b.getName().compareTo(a.getName());
            }
        };

        BestFitArranger() {
        }

        @Override
        public Size arrangeImages(Collection<ImageRect> rects) {
            if (rects.size() == 0) {
                return new Size(0, 0);
            }
            ArrayList<ImageRect> rectsOrderedByHeight = new ArrayList<ImageRect>(rects);
            Collections.sort(rectsOrderedByHeight, decreasingHeightComparator);
            ArrayList<ImageRect> rectsOrderedByWidth = new ArrayList<ImageRect>(rects);
            Collections.sort(rectsOrderedByWidth, decreasingWidthComparator);
            ImageRect first = rectsOrderedByHeight.get(0);
            first.setPosition(0, 0);
            int curX = first.getWidth();
            int colH = first.getHeight();
            int n = rectsOrderedByHeight.size();
            for (int i = 1; i < n; ++i) {
                if (rectsOrderedByHeight.get(i).hasBeenPositioned()) continue;
                int colW = 0;
                int curY = 0;
                ArrayList<ImageRect> rectsInColumn = new ArrayList<ImageRect>();
                for (int j = i; j < n; ++j) {
                    ImageRect current = rectsOrderedByHeight.get(j);
                    if (current.hasBeenPositioned() || curY + current.getHeight() > colH) continue;
                    current.setPosition(curX, 0);
                    colW = Math.max(colW, current.getWidth());
                    curY += current.getHeight();
                    int pos = Collections.binarySearch(rectsInColumn, current, decreasingWidthComparator);
                    assert (pos < 0);
                    rectsInColumn.add(-1 - pos, current);
                }
                if (!rectsInColumn.isEmpty()) {
                    this.arrangeColumn(rectsInColumn, rectsOrderedByWidth);
                }
                curX += colW;
            }
            return new Size(curX, colH);
        }

        private void arrangeColumn(List<ImageRect> rectsInColumn, List<ImageRect> remainingRectsOrderedByWidth) {
            ImageRect first = rectsInColumn.get(0);
            int columnWidth = first.getWidth();
            int curY = first.getHeight();
            int m = rectsInColumn.size();
            for (int i = 1; i < m; ++i) {
                ImageRect r = rectsInColumn.get(i);
                r.setPosition(r.getLeft(), curY);
                int curX = r.getWidth();
                int n = remainingRectsOrderedByWidth.size();
                for (int j = 0; j < n; ++j) {
                    ImageRect current = remainingRectsOrderedByWidth.get(j);
                    if (current.hasBeenPositioned() || curX + current.getWidth() > columnWidth || current.getHeight() > r.getHeight()) continue;
                    current.setPosition(r.getLeft() + curX, r.getTop());
                    curX += current.getWidth();
                }
                curY += r.getHeight();
            }
        }
    }

    static interface Arranger {
        public Size arrangeImages(Collection<ImageRect> var1);
    }
}

