/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.rg;

import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.dev.util.StringKey;
import com.google.gwt.dev.util.Util;
import com.google.gwt.dev.util.collect.Maps;
import com.google.gwt.dev.util.collect.Sets;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.resources.client.impl.ImageResourcePrototype;
import com.google.gwt.resources.ext.AbstractResourceGenerator;
import com.google.gwt.resources.ext.ClientBundleFields;
import com.google.gwt.resources.ext.ClientBundleRequirements;
import com.google.gwt.resources.ext.ResourceContext;
import com.google.gwt.resources.ext.ResourceGeneratorUtil;
import com.google.gwt.resources.ext.SupportsGeneratorResultCaching;
import com.google.gwt.resources.rg.ImageBundleBuilder;
import com.google.gwt.resources.rg.UnsuitableForStripException;
import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.user.rebind.StringSourceWriter;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class ImageResourceGenerator
extends AbstractResourceGenerator
implements SupportsGeneratorResultCaching {
    private boolean prepared;
    private CachedState shared;

    private static URL renderToTempPngFile(TreeLogger logger, ImageBundleBuilder builder, ImageBundleBuilder.Arranger arranger) throws UnableToCompleteException {
        try {
            byte[] imageBytes = builder.render(logger, arranger);
            if (imageBytes == null) {
                return null;
            }
            File file = File.createTempFile(ImageResourceGenerator.class.getSimpleName(), ".png");
            file.deleteOnExit();
            Util.writeBytesToFile((TreeLogger)logger, (File)file, (byte[])imageBytes);
            return file.toURI().toURL();
        }
        catch (IOException ex) {
            logger.log(TreeLogger.ERROR, "Unable to write re-encoded PNG", (Throwable)ex);
            throw new UnableToCompleteException();
        }
    }

    @Override
    public String createAssignment(TreeLogger logger, ResourceContext context, JMethod method) throws UnableToCompleteException {
        String string;
        String string2;
        String name = method.getName();
        ImageResourceDeclaration image = new ImageResourceDeclaration(method);
        DisplayedImage bundle = this.getImage(image);
        StringSourceWriter sw = new StringSourceWriter();
        String string3 = String.valueOf(String.valueOf(bundle.getResourceType().getCanonicalName()));
        sw.println(new StringBuilder(5 + string3.length()).append("new ").append(string3).append("(").toString());
        sw.indent();
        String string4 = String.valueOf(String.valueOf(name));
        sw.println(new StringBuilder(3 + string4.length()).append("\"").append(string4).append("\",").toString());
        ImageBundleBuilder.ImageRect rect = bundle.getImageRect(image);
        if (rect == null) {
            String string5 = String.valueOf(name);
            throw new NullPointerException(string5.length() != 0 ? "No ImageRect ever computed for ".concat(string5) : new String("No ImageRect ever computed for "));
        }
        String[] urlExpressions = new String[]{bundle.getNormalContentsFieldName(), bundle.getRtlContentsFieldName()};
        if (!$assertionsDisabled && urlExpressions[0] == null) {
            String string6 = String.valueOf(name);
            throw new AssertionError((Object)(string6.length() != 0 ? "No primary URL expression for ".concat(string6) : new String("No primary URL expression for ")));
        }
        if (urlExpressions[1] == null) {
            string2 = String.valueOf(String.valueOf(UriUtils.class.getName()));
            string = String.valueOf(String.valueOf(urlExpressions[0]));
            sw.println(new StringBuilder(21 + string2.length() + string.length()).append(string2).append(".fromTrustedString(").append(string).append("),").toString());
        } else {
            string2 = String.valueOf(String.valueOf(UriUtils.class.getName()));
            string = String.valueOf(String.valueOf(urlExpressions[1]));
            String string7 = String.valueOf(String.valueOf(urlExpressions[0]));
            sw.println(new StringBuilder(90 + string2.length() + string.length() + string7.length()).append(string2).append(".fromTrustedString(").append("com.google.gwt.i18n.client.LocaleInfo.getCurrentLocale().isRTL() ?").append(string).append(" : ").append(string7).append("),").toString());
        }
        int n = rect.getLeft();
        int n2 = rect.getTop();
        int n3 = rect.getWidth();
        int n4 = rect.getHeight();
        boolean bl = rect.isAnimated();
        boolean bl2 = rect.isLossy();
        sw.println(new StringBuilder(64).append(n).append(", ").append(n2).append(", ").append(n3).append(", ").append(n4).append(", ").append(bl).append(", ").append(bl2).toString());
        sw.outdent();
        sw.print(")");
        return sw.toString();
    }

    @Override
    public void createFields(TreeLogger logger, ResourceContext context, ClientBundleFields fields) throws UnableToCompleteException {
        this.renderImageMap(logger, context, fields, this.shared.bundledImages);
        this.renderImageMap(logger, context, fields, this.shared.externalImages);
    }

    @Override
    public void init(TreeLogger logger, ResourceContext context) {
        String key = this.createCacheKey(context);
        this.shared = context.getCachedData(key, CachedState.class);
        boolean bl = this.prepared = this.shared != null;
        if (this.prepared) {
            logger.log(TreeLogger.DEBUG, "Using cached data");
        } else {
            this.shared = new CachedState();
            context.putCachedData(key, this.shared);
        }
    }

    @Override
    public void prepare(TreeLogger logger, ResourceContext context, ClientBundleRequirements requirements, JMethod method) throws UnableToCompleteException {
        ImageBundleBuilder.ImageRect rect;
        LocalizedImage localizedImage;
        if (this.prepared) {
            logger.log(TreeLogger.DEBUG, "ImageResources already prepared");
            return;
        }
        ImageResourceDeclaration image = new ImageResourceDeclaration(method);
        boolean cannotBundle = false;
        DisplayedImage displayed = null;
        try {
            BundledImage bundledImage = (BundledImage)this.getImage(image);
            localizedImage = bundledImage.addImage(logger, context, image);
            rect = bundledImage.getImageRect(image);
            displayed = bundledImage;
            if (image.isPreventInlining() || image.getRepeatStyle() == ImageResource.RepeatStyle.Both) {
                cannotBundle = true;
            }
        }
        catch (CannotBundleImageException e) {
            cannotBundle = true;
            localizedImage = e.getLocalizedImage();
            rect = e.getImageRect();
        }
        if (cannotBundle) {
            if (!rect.isAnimated() && !rect.isLossy()) {
                try {
                    URL contentLocation = localizedImage.getUrl();
                    int originalSize = contentLocation.openConnection().getContentLength();
                    URL reencodedContents = this.reencodeToTempFile(logger, rect);
                    int newSize = reencodedContents.openConnection().getContentLength();
                    if (newSize < originalSize) {
                        if (logger.isLoggable(TreeLogger.SPAM)) {
                            int n = originalSize - newSize;
                            logger.log(TreeLogger.SPAM, new StringBuilder(43).append("Reencoded image and saved ").append(n).append(" bytes").toString());
                        }
                        localizedImage = new LocalizedImage(localizedImage, reencodedContents);
                    }
                }
                catch (IOException e2) {
                    logger.log(TreeLogger.WARN, "Unable to determine before/after size when re-encoding image data", (Throwable)e2);
                }
            }
            ExternalImage externalImage = new ExternalImage(image, localizedImage, rect);
            this.shared.externalImages.put(new BundleKey(image, true), externalImage);
            displayed = externalImage;
        }
        if (image.isFlipRtl()) {
            ((DisplayedImage)displayed).setRtlImage(localizedImage);
        }
    }

    private String createCacheKey(ResourceContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getClientBundleType().getQualifiedSourceName());
        sb.append(":").append(context.supportsDataUrls());
        try {
            String locale = context.getGeneratorContext().getPropertyOracle().getSelectionProperty(TreeLogger.NULL, "locale").getCurrentValue();
            context.getRequirements().addPermutationAxis("locale");
            sb.append(locale);
        }
        catch (BadPropertyValueException badPropertyValueException) {
            // empty catch block
        }
        return sb.toString();
    }

    private DisplayedImage getImage(ImageResourceDeclaration image) {
        DisplayedImage toReturn = this.shared.externalImages.get(new BundleKey(image, true));
        if (toReturn != null) {
            return toReturn;
        }
        BundleKey key = new BundleKey(image, false);
        toReturn = this.shared.bundledImages.get(key);
        if (toReturn == null) {
            BundledImage bundled = new BundledImage();
            this.shared.bundledImages.put(key, bundled);
            toReturn = bundled;
        }
        return toReturn;
    }

    private URL reencodeToTempFile(TreeLogger logger, ImageBundleBuilder.ImageRect rect) throws UnableToCompleteException {
        try {
            byte[] imageBytes = ImageBundleBuilder.toPng(logger, rect);
            if (imageBytes == null) {
                return null;
            }
            File file = File.createTempFile(ImageResourceGenerator.class.getSimpleName(), ".png");
            file.deleteOnExit();
            Util.writeBytesToFile((TreeLogger)logger, (File)file, (byte[])imageBytes);
            return file.toURI().toURL();
        }
        catch (IOException ex) {
            logger.log(TreeLogger.ERROR, "Unable to write re-encoded PNG", (Throwable)ex);
            throw new UnableToCompleteException();
        }
    }

    private void renderImageMap(TreeLogger logger, ResourceContext context, ClientBundleFields fields, Map<BundleKey, ? extends DisplayedImage> map) throws UnableToCompleteException {
        for (Map.Entry<BundleKey, ? extends DisplayedImage> entry : map.entrySet()) {
            DisplayedImage bundle = entry.getValue();
            bundle.render(logger, context, fields, entry.getKey().getRepeatStyle());
        }
    }

    static class LocalizedImage
    extends StringKey {
        private final ImageResourceDeclaration image;
        private final URL url;

        public static LocalizedImage create(TreeLogger logger, ResourceContext context, ImageResourceDeclaration image) throws UnableToCompleteException {
            URL[] resources = ResourceGeneratorUtil.findResources(logger, context, image.getMethod());
            if (resources.length != 1) {
                logger.log(TreeLogger.ERROR, "Exactly one image may be specified", null);
                throw new UnableToCompleteException();
            }
            URL resource = resources[0];
            LocalizedImage toReturn = new LocalizedImage(image, resource);
            return toReturn;
        }

        private static String key(ImageResourceDeclaration image, URL url) {
            String string = String.valueOf(String.valueOf(Util.computeStrongName((byte[])Util.readURLAsBytes((URL)url))));
            int n = image.getScaleHeight();
            int n2 = image.getScaleWidth();
            return new StringBuilder(24 + string.length()).append(string).append(":").append(n).append(":").append(n2).toString();
        }

        public LocalizedImage(LocalizedImage other, URL alternateUrl) {
            this(other.image, alternateUrl);
        }

        private LocalizedImage(ImageResourceDeclaration image, URL url) {
            super(LocalizedImage.key(image, url));
            this.image = image;
            this.url = url;
        }

        public URL getUrl() {
            return this.url;
        }
    }

    static class ImageResourceDeclaration
    extends StringKey {
        private final String name;
        private final JMethod method;
        private final ImageResource.ImageOptions options;

        private static String key(JMethod method) {
            String string = String.valueOf(String.valueOf(method.getEnclosingType().getQualifiedSourceName()));
            String string2 = String.valueOf(String.valueOf(method.getName()));
            return new StringBuilder(1 + string.length() + string2.length()).append(string).append(".").append(string2).toString();
        }

        public ImageResourceDeclaration(JMethod method) {
            super(ImageResourceDeclaration.key(method));
            this.name = method.getName();
            this.method = method;
            this.options = (ImageResource.ImageOptions)method.getAnnotation(ImageResource.ImageOptions.class);
        }

        public JMethod getMethod() {
            return this.method;
        }

        public String getName() {
            return this.name;
        }

        public ImageResource.RepeatStyle getRepeatStyle() {
            return this.options == null ? ImageResource.RepeatStyle.None : this.options.repeatStyle();
        }

        public int getScaleHeight() {
            return this.options == null ? -1 : this.options.height();
        }

        public int getScaleWidth() {
            return this.options == null ? -1 : this.options.width();
        }

        public boolean isFlipRtl() {
            return this.options == null ? false : this.options.flipRtl();
        }

        public boolean isPreventInlining() {
            return this.options == null ? false : this.options.preventInlining();
        }
    }

    static class ExternalImage
    extends DisplayedImage {
        private final ImageResourceDeclaration image;
        private boolean isRtl;
        private final LocalizedImage localized;
        private final ImageBundleBuilder.ImageRect rect;

        public ExternalImage(ImageResourceDeclaration image, LocalizedImage localized, ImageBundleBuilder.ImageRect rect) {
            this.image = image;
            this.localized = localized;
            this.rect = rect;
        }

        @Override
        public Class<?> getResourceType() {
            return ImageResourcePrototype.class;
        }

        @Override
        public ImageBundleBuilder.ImageRect getImageRect(ImageResourceDeclaration image) {
            return this.image.equals(image) ? this.rect : null;
        }

        @Override
        public void render(TreeLogger logger, ResourceContext context, ClientBundleFields fields, ImageResource.RepeatStyle repeatStyle) throws UnableToCompleteException {
            JClassType stringType = context.getGeneratorContext().getTypeOracle().findType(String.class.getCanonicalName());
            String contentsExpression = context.deploy(this.localized.getUrl(), null, this.image.isPreventInlining());
            this.normalContentsFieldName = fields.define((JType)stringType, "externalImage", contentsExpression, true, true);
            if (this.isRtl) {
                AffineTransform tx = new AffineTransform();
                tx.setTransform(-1.0, 0.0, 0.0, 1.0, this.rect.getWidth(), 0.0);
                this.rect.setTransform(tx);
                byte[] rtlData = ImageBundleBuilder.toPng(logger, this.rect);
                String rtlContentsUrlExpression = context.deploy(String.valueOf(this.image.getName()).concat("_rtl.png"), "image/png", rtlData, this.image.isPreventInlining());
                this.rtlContentsFieldName = fields.define((JType)stringType, "externalImage_rtl", rtlContentsUrlExpression, true, true);
            }
        }

        @Override
        public void setRtlImage(LocalizedImage localized) {
            if (this.localized.equals(localized)) {
                this.isRtl = true;
            }
        }
    }

    static abstract class DisplayedImage {
        protected String normalContentsFieldName;
        protected String rtlContentsFieldName;

        DisplayedImage() {
        }

        public abstract Class<?> getResourceType();

        public abstract ImageBundleBuilder.ImageRect getImageRect(ImageResourceDeclaration var1);

        public String getNormalContentsFieldName() {
            return this.normalContentsFieldName;
        }

        public String getRtlContentsFieldName() {
            return this.rtlContentsFieldName;
        }

        public abstract void setRtlImage(LocalizedImage var1);

        abstract void render(TreeLogger var1, ResourceContext var2, ClientBundleFields var3, ImageResource.RepeatStyle var4) throws UnableToCompleteException;
    }

    static class CannotBundleImageException
    extends Exception {
        private final ImageBundleBuilder.ImageRect imageRect;
        private final LocalizedImage localized;

        public CannotBundleImageException(LocalizedImage localized, ImageBundleBuilder.ImageRect imageRect) {
            this.localized = localized;
            this.imageRect = imageRect;
        }

        public ImageBundleBuilder.ImageRect getImageRect() {
            return this.imageRect;
        }

        public LocalizedImage getLocalizedImage() {
            return this.localized;
        }
    }

    static class CachedState {
        public final Map<BundleKey, BundledImage> bundledImages = new LinkedHashMap<BundleKey, BundledImage>();
        public final Map<BundleKey, ExternalImage> externalImages = new LinkedHashMap<BundleKey, ExternalImage>();

        CachedState() {
        }
    }

    static class BundleKey
    extends StringKey {
        private final ImageResource.RepeatStyle repeatStyle;

        private static String key(ImageResourceDeclaration image, boolean isExternal) {
            if (isExternal) {
                String string = String.valueOf(image.get());
                return string.length() != 0 ? "External: ".concat(string) : new String("External: ");
            }
            if (image.isPreventInlining() || image.getRepeatStyle() == ImageResource.RepeatStyle.Both) {
                String string = String.valueOf(image.get());
                return string.length() != 0 ? "Unbundled: ".concat(string) : new String("Unbundled: ");
            }
            String string = String.valueOf(image.getRepeatStyle().toString());
            return string.length() != 0 ? "Arranged: ".concat(string) : new String("Arranged: ");
        }

        public BundleKey(ImageResourceDeclaration image, boolean isExternal) {
            super(BundleKey.key(image, isExternal));
            this.repeatStyle = image.getRepeatStyle();
        }

        public ImageResource.RepeatStyle getRepeatStyle() {
            return this.repeatStyle;
        }

        public boolean isExternal() {
            return this.get().startsWith("External: ");
        }
    }

    static class BundledImage
    extends DisplayedImage {
        private static final String MIME_TYPE_IMAGE_PNG = "image/png";
        private final ImageBundleBuilder builder;
        private boolean dirty = false;
        private Map<LocalizedImage, ImageBundleBuilder.ImageRect> images;
        private Set<LocalizedImage> rtlImages = Sets.create();
        private Map<ImageResourceDeclaration, LocalizedImage> localizedByImageResource;
        private String normalContentsUrlExpression;
        private String rtlContentsUrlExpression;

        public BundledImage() {
            this.builder = new ImageBundleBuilder();
            this.images = Maps.create();
            this.localizedByImageResource = Maps.create();
        }

        @Override
        public Class<?> getResourceType() {
            return ImageResourcePrototype.Bundle.class;
        }

        public LocalizedImage addImage(TreeLogger logger, ResourceContext context, ImageResourceDeclaration image) throws UnableToCompleteException, CannotBundleImageException {
            LocalizedImage localized = LocalizedImage.create(logger, context, image);
            this.localizedByImageResource = Maps.put(this.localizedByImageResource, (Object)image, (Object)localized);
            if (this.images.containsKey(localized)) {
                return localized;
            }
            this.dirty = true;
            ImageBundleBuilder.ImageRect rect = null;
            try {
                rect = this.builder.assimilate(logger, image.get(), localized.getUrl());
                if (context.supportsDataUrls()) {
                    this.builder.removeMapping(image.get());
                    throw new CannotBundleImageException(localized, rect);
                }
                this.images = Maps.put(this.images, (Object)localized, (Object)rect);
            }
            catch (UnsuitableForStripException e) {
                rect = e.getImageRect();
                throw new CannotBundleImageException(localized, rect);
            }
            finally {
                assert (rect != null) : "No ImageRect";
                rect.setHeight(image.getScaleHeight());
                rect.setWidth(image.getScaleWidth());
            }
            return localized;
        }

        public ImageBundleBuilder getImageBundleBuilder() {
            return this.builder;
        }

        @Override
        public ImageBundleBuilder.ImageRect getImageRect(ImageResourceDeclaration image) {
            return this.images.get(this.localizedByImageResource.get(image));
        }

        @Override
        public void render(TreeLogger logger, ResourceContext context, ClientBundleFields fields, ImageResource.RepeatStyle repeatStyle) throws UnableToCompleteException {
            if (this.builder.getImageCount() == 0) {
                return;
            }
            if (this.dirty) {
                ImageBundleBuilder.Arranger arranger;
                switch (repeatStyle) {
                    case None: {
                        arranger = new ImageBundleBuilder.BestFitArranger();
                        break;
                    }
                    case Horizontal: {
                        arranger = new ImageBundleBuilder.VerticalArranger();
                        break;
                    }
                    case Vertical: {
                        arranger = new ImageBundleBuilder.HorizontalArranger();
                        break;
                    }
                    case Both: {
                        arranger = new ImageBundleBuilder.IdentityArranger();
                        break;
                    }
                    default: {
                        String string = String.valueOf(String.valueOf((Object)repeatStyle));
                        logger.log(TreeLogger.ERROR, new StringBuilder(20 + string.length()).append("Unknown RepeatStyle ").append(string).toString());
                        throw new UnableToCompleteException();
                    }
                }
                URL normalContents = ImageResourceGenerator.renderToTempPngFile(logger, this.builder, arranger);
                this.normalContentsUrlExpression = context.deploy(normalContents, MIME_TYPE_IMAGE_PNG, false);
                if (!this.rtlImages.isEmpty()) {
                    for (LocalizedImage rtlImage : this.rtlImages) {
                        AffineTransform tx = new AffineTransform();
                        ImageBundleBuilder.ImageRect imageRect = this.images.get(rtlImage);
                        tx.setTransform(-1.0, 0.0, 0.0, 1.0, imageRect.getWidth(), 0.0);
                        imageRect.setTransform(tx);
                    }
                    URL rtlContents = ImageResourceGenerator.renderToTempPngFile(logger, this.builder, new ImageBundleBuilder.IdentityArranger());
                    assert (rtlContents != null);
                    this.rtlContentsUrlExpression = context.deploy(rtlContents, MIME_TYPE_IMAGE_PNG, false);
                }
                this.dirty = false;
                if (logger.isLoggable(TreeLogger.DEBUG)) {
                    int n = this.builder.getImageCount();
                    logger.log(TreeLogger.DEBUG, new StringBuilder(29).append("Composited ").append(n).append(" images").toString());
                }
            }
            JClassType stringType = context.getGeneratorContext().getTypeOracle().findType(String.class.getCanonicalName());
            assert (this.normalContentsUrlExpression != null);
            String string = String.valueOf(repeatStyle.name());
            this.normalContentsFieldName = fields.define((JType)stringType, string.length() != 0 ? "bundledImage_".concat(string) : new String("bundledImage_"), this.normalContentsUrlExpression, true, true);
            if (this.rtlContentsUrlExpression != null) {
                String string2 = String.valueOf(String.valueOf(repeatStyle.name()));
                this.rtlContentsFieldName = fields.define((JType)stringType, new StringBuilder(17 + string2.length()).append("bundledImage_").append(string2).append("_rtl").toString(), this.rtlContentsUrlExpression, true, true);
            }
        }

        @Override
        public void setRtlImage(LocalizedImage image) {
            this.rtlImages = Sets.add(this.rtlImages, (Object)image);
        }
    }
}

