/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.safecss.shared;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import java.util.HashMap;
import java.util.Stack;

public class SafeStylesHostedModeUtils {
    public static final String FORCE_CHECK_VALID_STYLES = "com.google.gwt.safecss.ForceCheckValidStyles";
    private static boolean forceCheck;

    @VisibleForTesting
    public static String isValidStyleName(String name) {
        if (name == null || name.isEmpty()) {
            return "Style property names cannot be null or empty";
        }
        char firstReal = name.charAt(0);
        if (firstReal == '-' && name.length() > 0) {
            firstReal = name.charAt(1);
        }
        if (firstReal >= '0' && firstReal <= '9') {
            String string = String.valueOf(name);
            return string.length() != 0 ? "Style property names cannot start with a digit or a hyphen followed by a digit: ".concat(string) : new String("Style property names cannot start with a digit or a hyphen followed by a digit: ");
        }
        if (name.startsWith("--")) {
            String string = String.valueOf(name);
            return string.length() != 0 ? "Style property names cannot start with a double hyphen: ".concat(string) : new String("Style property names cannot start with a double hyphen: ");
        }
        if (name.indexOf(59) >= 0) {
            String string = String.valueOf(name);
            return string.length() != 0 ? "Style property names cannot contain a semi-colon: ".concat(string) : new String("Style property names cannot contain a semi-colon: ");
        }
        if (name.indexOf(58) >= 0) {
            String string = String.valueOf(name);
            return string.length() != 0 ? "Style property names cannot contain a colon: ".concat(string) : new String("Style property names cannot contain a colon: ");
        }
        return null;
    }

    @VisibleForTesting
    public static String isValidStyleValue(String value) {
        int i;
        if (value == null || value.length() == 0) {
            return "Style property values cannot be null or empty";
        }
        HashMap<Character, Character> pairs = new HashMap<Character, Character>();
        pairs.put(Character.valueOf('('), Character.valueOf(')'));
        pairs.put(Character.valueOf('['), Character.valueOf(']'));
        pairs.put(Character.valueOf('{'), Character.valueOf('}'));
        Stack<Character> pairsStack = new Stack<Character>();
        Stack<Integer> pairsPos = new Stack<Integer>();
        Character inQuote = null;
        int inQuotePos = -1;
        boolean inUrl = false;
        boolean ignoreNext = false;
        for (i = 0; i < value.length(); ++i) {
            if (ignoreNext) {
                ignoreNext = false;
                continue;
            }
            char ch = value.charAt(i);
            if (ch == '\\') {
                ignoreNext = true;
                continue;
            }
            if (inUrl) {
                if (ch == ')') {
                    inUrl = false;
                    continue;
                }
                if (ch != '(') continue;
                int n = i;
                String string = String.valueOf(String.valueOf(value));
                return new StringBuilder(57 + string.length()).append("Unescaped parentheses within a url at index ").append(n).append(": ").append(string).toString();
            }
            if (inQuote != null) {
                if (ch != inQuote.charValue()) continue;
                inQuote = null;
                continue;
            }
            if (ch == '\"' || ch == '\'') {
                inQuote = Character.valueOf(ch);
                inQuotePos = i;
                continue;
            }
            if ((ch == 'u' || ch == 'U') && value.length() >= i + 4 && value.substring(i, i + 4).equalsIgnoreCase("url(")) {
                inUrl = true;
                i += 3;
                continue;
            }
            if (pairs.containsKey(Character.valueOf(ch))) {
                pairsStack.push(Character.valueOf(ch));
                pairsPos.push(i);
                continue;
            }
            if (pairs.values().contains(Character.valueOf(ch))) {
                if (pairsStack.isEmpty() || ((Character)pairs.get(pairsStack.pop())).charValue() != ch) {
                    char c = ch;
                    int n = i;
                    String string = String.valueOf(String.valueOf(value));
                    return new StringBuilder(65 + string.length()).append("Style property value contains unpaired '").append(c).append("' at index ").append(n).append(": ").append(string).toString();
                }
                pairsPos.pop();
                continue;
            }
            if (ch == ';') {
                String string = String.valueOf(value);
                return string.length() != 0 ? "Style property values cannot contain a semi-colon (except within quotes): ".concat(string) : new String("Style property values cannot contain a semi-colon (except within quotes): ");
            }
            if (ch != ':') continue;
            String string = String.valueOf(value);
            return string.length() != 0 ? "Style property values cannot contain a colon (except within quotes): ".concat(string) : new String("Style property values cannot contain a colon (except within quotes): ");
        }
        if (inQuote != null) {
            i = inQuotePos;
            String ch = String.valueOf(String.valueOf(value));
            return new StringBuilder(72 + ch.length()).append("Style property value contains unpaired open quote at index ").append(i).append(": ").append(ch).toString();
        }
        if (inUrl) {
            String string = String.valueOf(value);
            return string.length() != 0 ? "Style property value contains an unterminated url: ".concat(string) : new String("Style property value contains an unterminated url: ");
        }
        if (!pairsStack.isEmpty()) {
            char openToken = ((Character)pairsStack.pop()).charValue();
            int index = (Integer)pairsPos.pop();
            char c = openToken;
            int n = index;
            String string = String.valueOf(String.valueOf(value));
            return new StringBuilder(65 + string.length()).append("Style property value contains unpaired '").append(c).append("' at index ").append(n).append(": ").append(string).toString();
        }
        if (ignoreNext) {
            String string = String.valueOf(value);
            return string.length() != 0 ? "Style property values cannot end in an escape character: ".concat(string) : new String("Style property values cannot end in an escape character: ");
        }
        return null;
    }

    public static void maybeCheckValidStyleName(String name) {
        if (GWT.isClient() || forceCheck) {
            String errorText = SafeStylesHostedModeUtils.isValidStyleName(name);
            Preconditions.checkArgument(errorText == null, errorText);
        } else assert (SafeStylesHostedModeUtils.isValidStyleName(name) == null) : SafeStylesHostedModeUtils.isValidStyleName(name);
    }

    public static void maybeCheckValidStyleValue(String value) {
        if (GWT.isClient() || forceCheck) {
            String errorText = SafeStylesHostedModeUtils.isValidStyleValue(value);
            Preconditions.checkArgument(errorText == null, errorText);
        } else assert (SafeStylesHostedModeUtils.isValidStyleValue(value) == null) : SafeStylesHostedModeUtils.isValidStyleValue(value);
    }

    public static void setForceCheckValidStyle(boolean check) {
        forceCheck = check;
    }

    static void setForceCheckValidStyleFromProperty() {
        forceCheck = System.getProperty(FORCE_CHECK_VALID_STYLES) != null;
    }

    static {
        SafeStylesHostedModeUtils.setForceCheckValidStyleFromProperty();
    }
}

