/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.attributeparsers;

import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.uibinder.attributeparsers.AttributeParser;
import com.google.gwt.uibinder.attributeparsers.FieldReferenceConverter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;

class StringAttributeParser
implements AttributeParser {
    private final FieldReferenceConverter converter;
    private final JType stringType;

    StringAttributeParser(FieldReferenceConverter converter, JType stringType) {
        this.converter = converter;
        this.stringType = stringType;
    }

    @Override
    public String parse(XMLElement source, String value) {
        return this.converter.convert(source, value, new FieldReferenceDelegate(this.stringType));
    }

    static class FieldReferenceDelegate
    implements FieldReferenceConverter.Delegate {
        private final JType[] types;

        FieldReferenceDelegate(JType type) {
            this.types = new JType[]{type};
        }

        @Override
        public JType[] getTypes() {
            return this.types;
        }

        @Override
        public String handleFragment(String literal) {
            String string = String.valueOf(String.valueOf(UiBinderWriter.escapeTextForJavaStringLiteral((String)literal)));
            return new StringBuilder(2 + string.length()).append("\"").append(string).append("\"").toString();
        }

        @Override
        public String handleReference(String reference) {
            return String.format(" + %s + ", reference);
        }
    }
}

