/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.core.ext.typeinfo.TypeOracleException;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.TimeZone;
import com.google.gwt.uibinder.elementparsers.ElementParser;
import com.google.gwt.uibinder.rebind.TypeOracleUtils;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;

public class DateLabelParser
implements ElementParser {
    static final String AT_MOST_ONE_SPECIFIED_FORMAT = "May have at most one of format, predefinedFormat and customFormat.";
    static final String AT_MOST_ONE_SPECIFIED_TIME_ZONE = "May have at most one of timezone and timezoneOffset.";
    static final String NO_TIMEZONE_WITHOUT_SPECIFIED_FORMAT = "May not specify a time zone if no format is given.";

    @Override
    public void parse(XMLElement elem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        boolean supportsTimeZone = this.hasDateTimeFormatAndTimeZoneConstructor(writer.getOracle(), type);
        if (this.hasDateTimeFormatConstructor(writer.getOracle(), type) || supportsTimeZone) {
            String format = this.consumeFormat(elem, writer);
            if (format != null) {
                String timeZone = supportsTimeZone ? this.consumeTimeZone(elem, writer) : null;
                writer.setFieldInitializerAsConstructor(fieldName, this.makeArgs(format, timeZone));
            } else if (supportsTimeZone && this.hasTimeZone(elem)) {
                writer.die(elem, NO_TIMEZONE_WITHOUT_SPECIFIED_FORMAT, new Object[0]);
            }
        }
    }

    private String consumeFormat(XMLElement elem, UiBinderWriter writer) throws UnableToCompleteException {
        String format = elem.consumeAttribute("format", (JType)writer.getOracle().findType(DateTimeFormat.class.getCanonicalName()));
        String predefinedFormat = elem.consumeAttribute("predefinedFormat", (JType)writer.getOracle().findType(DateTimeFormat.PredefinedFormat.class.getCanonicalName()));
        String customFormat = elem.consumeStringAttribute("customFormat");
        if (format != null) {
            if (predefinedFormat != null || customFormat != null) {
                writer.die(elem, AT_MOST_ONE_SPECIFIED_FORMAT, new Object[0]);
            }
            return format;
        }
        if (predefinedFormat != null) {
            if (customFormat != null) {
                writer.die(elem, AT_MOST_ONE_SPECIFIED_FORMAT, new Object[0]);
            }
            return this.makeGetFormat(predefinedFormat);
        }
        if (customFormat != null) {
            return this.makeGetFormat(customFormat);
        }
        return null;
    }

    private String consumeTimeZone(XMLElement elem, UiBinderWriter writer) throws UnableToCompleteException {
        String timeZone = elem.consumeAttribute("timezone", (JType)writer.getOracle().findType(TimeZone.class.getCanonicalName()));
        String timeZoneOffset = elem.consumeAttribute("timezoneOffset", this.getIntType(writer.getOracle()));
        if (timeZone != null && timeZoneOffset != null) {
            writer.die(elem, AT_MOST_ONE_SPECIFIED_TIME_ZONE, new Object[0]);
        }
        if (timeZone != null) {
            return timeZone;
        }
        if (timeZoneOffset != null) {
            String string = String.valueOf(String.valueOf(TimeZone.class.getCanonicalName()));
            String string2 = String.valueOf(String.valueOf(timeZoneOffset));
            return new StringBuilder(17 + string.length() + string2.length()).append(string).append(".createTimeZone(").append(string2).append(")").toString();
        }
        return null;
    }

    private JType getIntType(TypeOracle oracle) {
        try {
            return oracle.parse("int");
        }
        catch (TypeOracleException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean hasDateTimeFormatAndTimeZoneConstructor(TypeOracle typeOracle, JClassType type) {
        JClassType dateTimeFormatType = typeOracle.findType(DateTimeFormat.class.getName());
        JClassType timeZoneType = typeOracle.findType(TimeZone.class.getName());
        return TypeOracleUtils.hasCompatibleConstructor((JClassType)type, (JType[])new JType[]{dateTimeFormatType, timeZoneType});
    }

    private boolean hasDateTimeFormatConstructor(TypeOracle typeOracle, JClassType type) {
        JClassType dateTimeFormatType = typeOracle.findType(DateTimeFormat.class.getName());
        return TypeOracleUtils.hasCompatibleConstructor((JClassType)type, (JType[])new JType[]{dateTimeFormatType});
    }

    private boolean hasTimeZone(XMLElement elem) {
        return elem.hasAttribute("timezone") || elem.hasAttribute("timezoneOffset");
    }

    private String[] makeArgs(String format, String timeZone) {
        if (timeZone == null) {
            return new String[]{format};
        }
        return new String[]{format, timeZone};
    }

    private String makeGetFormat(String format) {
        String string = String.valueOf(String.valueOf(DateTimeFormat.class.getCanonicalName()));
        String string2 = String.valueOf(String.valueOf(format));
        return new StringBuilder(12 + string.length() + string2.length()).append(string).append(".getFormat(").append(string2).append(")").toString();
    }
}

