/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.uibinder.elementparsers.ComputedAttributeInterpreter;
import com.google.gwt.uibinder.rebind.MortalLogger;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLAttribute;
import com.google.gwt.uibinder.rebind.XMLElement;

public class UiTextInterpreter
implements XMLElement.Interpreter<String> {
    protected final UiBinderWriter writer;
    protected final ComputedAttributeInterpreter computedAttributeInterpreter;
    private final MortalLogger logger;

    public UiTextInterpreter(UiBinderWriter writer) {
        this.writer = writer;
        this.logger = writer.getLogger();
        this.computedAttributeInterpreter = this.createComputedAttributeInterpreter();
    }

    public String interpretElement(XMLElement elem) throws UnableToCompleteException {
        if (this.writer.isBinderElement(elem) && this.getLocalName().equals(elem.getLocalName())) {
            if (!elem.hasAttribute("from")) {
                this.logger.die(elem, "Attribute 'from' not found.", new Object[0]);
            }
            if (!elem.getAttribute("from").hasComputedValue()) {
                this.logger.die(elem, "Attribute 'from' does not have a computed value", new Object[0]);
            }
            this.computedAttributeInterpreter.interpretElement(elem);
            String fieldRef = elem.consumeStringAttribute("from");
            elem.assertNoAttributes();
            String string = String.valueOf(String.valueOf(fieldRef));
            return new StringBuilder(8 + string.length()).append("\" + ").append(string).append(" + \"").toString();
        }
        return null;
    }

    protected ComputedAttributeInterpreter createComputedAttributeInterpreter() {
        return new ComputedAttributeInterpreter(this.writer);
    }

    protected String getLocalName() {
        return "text";
    }

    protected class Delegate
    implements ComputedAttributeInterpreter.Delegate {
        protected Delegate() {
        }

        @Override
        public String getAttributeToken(XMLAttribute attribute) throws UnableToCompleteException {
            return UiTextInterpreter.this.writer.tokenForStringExpression(attribute.getElement(), attribute.consumeStringValue());
        }
    }
}

