/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.dom.builder.shared.DivBuilder;
import com.google.gwt.dom.builder.shared.TableCellBuilder;
import com.google.gwt.dom.builder.shared.TableRowBuilder;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.AbstractCellTableBuilder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.RowStyles;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.view.client.SelectionModel;

public class DefaultCellTableBuilder<T>
extends AbstractCellTableBuilder<T> {
    private final String evenRowStyle;
    private final String oddRowStyle;
    private final String selectedRowStyle;
    private final String cellStyle;
    private final String evenCellStyle;
    private final String oddCellStyle;
    private final String firstColumnStyle;
    private final String lastColumnStyle;
    private final String selectedCellStyle;

    public DefaultCellTableBuilder(AbstractCellTable<T> cellTable) {
        super(cellTable);
        AbstractCellTable.Style style = cellTable.getResources().style();
        this.evenRowStyle = style.evenRow();
        this.oddRowStyle = style.oddRow();
        String string = String.valueOf(style.selectedRow());
        this.selectedRowStyle = string.length() != 0 ? " ".concat(string) : new String(" ");
        this.cellStyle = style.cell();
        String string2 = String.valueOf(style.evenRowCell());
        this.evenCellStyle = string2.length() != 0 ? " ".concat(string2) : new String(" ");
        String string3 = String.valueOf(style.oddRowCell());
        this.oddCellStyle = string3.length() != 0 ? " ".concat(string3) : new String(" ");
        String string4 = String.valueOf(style.firstColumn());
        this.firstColumnStyle = string4.length() != 0 ? " ".concat(string4) : new String(" ");
        String string5 = String.valueOf(style.lastColumn());
        this.lastColumnStyle = string5.length() != 0 ? " ".concat(string5) : new String(" ");
        String string6 = String.valueOf(style.selectedRowCell());
        this.selectedCellStyle = string6.length() != 0 ? " ".concat(string6) : new String(" ");
    }

    @Override
    public void buildRowImpl(T rowValue, int absRowIndex) {
        String extraRowStyles;
        RowStyles<T> rowStyles;
        SelectionModel<T> selectionModel = this.cellTable.getSelectionModel();
        boolean isSelected = selectionModel == null || rowValue == null ? false : selectionModel.isSelected(rowValue);
        boolean isEven = absRowIndex % 2 == 0;
        StringBuilder trClasses = new StringBuilder(isEven ? this.evenRowStyle : this.oddRowStyle);
        if (isSelected) {
            trClasses.append(this.selectedRowStyle);
        }
        if ((rowStyles = this.cellTable.getRowStyles()) != null && (extraRowStyles = rowStyles.getStyleNames(rowValue, absRowIndex)) != null) {
            trClasses.append(" ").append(extraRowStyles);
        }
        TableRowBuilder tr = this.startRow();
        tr.className(trClasses.toString());
        int columnCount = this.cellTable.getColumnCount();
        for (int curColumn = 0; curColumn < columnCount; ++curColumn) {
            Cell.Context context;
            String cellStyles;
            Column<T, ?> column = this.cellTable.getColumn(curColumn);
            StringBuilder tdClasses = new StringBuilder(this.cellStyle);
            tdClasses.append(isEven ? this.evenCellStyle : this.oddCellStyle);
            if (curColumn == 0) {
                tdClasses.append(this.firstColumnStyle);
            }
            if (isSelected) {
                tdClasses.append(this.selectedCellStyle);
            }
            if (curColumn == columnCount - 1) {
                tdClasses.append(this.lastColumnStyle);
            }
            if ((cellStyles = column.getCellStyleNames(context = new Cell.Context(absRowIndex, curColumn, this.cellTable.getValueKey(rowValue)), rowValue)) != null) {
                String string = String.valueOf(cellStyles);
                tdClasses.append(string.length() != 0 ? " ".concat(string) : new String(" "));
            }
            HasHorizontalAlignment.HorizontalAlignmentConstant hAlign = column.getHorizontalAlignment();
            HasVerticalAlignment.VerticalAlignmentConstant vAlign = column.getVerticalAlignment();
            TableCellBuilder td = tr.startTD();
            td.className(tdClasses.toString());
            if (hAlign != null) {
                td.align(hAlign.getTextAlignString());
            }
            if (vAlign != null) {
                td.vAlign(vAlign.getVerticalAlignString());
            }
            DivBuilder div = td.startDiv();
            div.style().outlineStyle(Style.OutlineStyle.NONE).endStyle();
            this.renderCell(div, context, column, rowValue);
            div.endDiv();
            td.endTD();
        }
        tr.endTR();
    }
}

