/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.rpc.impl;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.core.client.JsArrayString;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.SerializationStreamReader;
import com.google.gwt.user.client.rpc.SerializationStreamWriter;
import com.google.gwt.user.client.rpc.impl.ReflectionHelper;
import com.google.gwt.user.client.rpc.impl.Serializer;
import com.google.gwt.user.client.rpc.impl.TypeHandler;
import java.util.HashMap;
import java.util.Map;

public abstract class SerializerBase
implements Serializer {
    private final Map<String, TypeHandler> handlerCache = new HashMap<String, TypeHandler>();
    private final Map<String, String> methodMapJava;
    private final MethodMap methodMapNative;
    private final Map<String, String> signatureMapJava;
    private final JsArrayString signatureMapNative;

    public SerializerBase(Map<String, String> methodMapJava, MethodMap methodMapNative, Map<String, String> signatureMapJava, JsArrayString signatureMapNative) {
        this.methodMapJava = methodMapJava;
        this.methodMapNative = methodMapNative;
        this.signatureMapJava = signatureMapJava;
        this.signatureMapNative = signatureMapNative;
    }

    @Override
    public final void deserialize(SerializationStreamReader stream, Object instance, String typeSignature) throws SerializationException {
        if (GWT.isScript()) {
            this.check(typeSignature, 2);
            this.methodMapNative.deserialize(stream, instance, typeSignature);
        } else {
            TypeHandler typeHandler = this.getTypeHandler(typeSignature);
            typeHandler.deserial(stream, instance);
        }
    }

    @Override
    public final String getSerializationSignature(Class<?> clazz) {
        assert (clazz != null) : "clazz";
        if (GWT.isScript()) {
            return this.signatureMapNative.get(clazz.hashCode());
        }
        return this.signatureMapJava.get(clazz.getName());
    }

    @Override
    public final Object instantiate(SerializationStreamReader stream, String typeSignature) throws SerializationException {
        if (GWT.isScript()) {
            this.check(typeSignature, 1);
            return this.methodMapNative.instantiate(stream, typeSignature);
        }
        TypeHandler typeHandler = this.getTypeHandler(typeSignature);
        return typeHandler.create(stream);
    }

    @Override
    public final void serialize(SerializationStreamWriter stream, Object instance, String typeSignature) throws SerializationException {
        if (GWT.isScript()) {
            this.check(typeSignature, 3);
            this.methodMapNative.serialize(stream, instance, typeSignature);
        } else {
            TypeHandler typeHandler = this.getTypeHandler(typeSignature);
            typeHandler.serial(stream, instance);
        }
    }

    private void check(String typeSignature, int length) throws SerializationException {
        if (this.methodMapNative.get(typeSignature) == null) {
            throw new SerializationException(typeSignature);
        }
        if (!$assertionsDisabled && this.methodMapNative.get(typeSignature).length() < length) {
            int n = length;
            int n2 = this.methodMapNative.get(typeSignature).length();
            throw new AssertionError((Object)new StringBuilder(57).append("Not enough methods, expecting ").append(n).append(" saw ").append(n2).toString());
        }
    }

    private TypeHandler getTypeHandler(String typeSignature) throws SerializationException {
        String typeHandlerClass = this.methodMapJava.get(typeSignature);
        if (typeHandlerClass == null) {
            throw new SerializationException(typeSignature);
        }
        TypeHandler typeHandler = this.handlerCache.get(typeHandlerClass);
        if (typeHandler == null) {
            try {
                Class<?> klass = ReflectionHelper.loadClass(typeHandlerClass);
                typeHandler = (TypeHandler)ReflectionHelper.newInstance(klass);
                this.handlerCache.put(typeHandlerClass, typeHandler);
            }
            catch (Exception e) {
                throw new SerializationException(e);
            }
        }
        return typeHandler;
    }

    protected static final class MethodMap
    extends JavaScriptObject {
        protected MethodMap() {
        }

        native void deserialize(SerializationStreamReader var1, Object var2, String var3) throws SerializationException;

        native JsArray<JavaScriptObject> get(String var1);

        native Object instantiate(SerializationStreamReader var1, String var2) throws SerializationException;

        native void put(String var1, JsArray<JavaScriptObject> var2);

        native void serialize(SerializationStreamWriter var1, Object var2, String var3) throws SerializationException;
    }
}

