/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.editor.client.IsEditor;
import com.google.gwt.editor.client.LeafValueEditor;
import com.google.gwt.editor.client.adapters.TakesValueEditor;
import com.google.gwt.event.dom.client.HasAllKeyHandlers;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DecoratedPopupPanel;
import com.google.gwt.user.client.ui.FiresSuggestionEvents;
import com.google.gwt.user.client.ui.FocusListener;
import com.google.gwt.user.client.ui.HasAnimation;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.HasFocus;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.ListenerWrapper;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SourcesChangeEvents;
import com.google.gwt.user.client.ui.SourcesClickEvents;
import com.google.gwt.user.client.ui.SourcesKeyboardEvents;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.SuggestionHandler;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.TextBoxBase;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.ValueBoxBase;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.List;

public class SuggestBox
extends Composite
implements HasText,
HasFocus,
HasAnimation,
HasEnabled,
SourcesClickEvents,
SourcesChangeEvents,
SourcesKeyboardEvents,
FiresSuggestionEvents,
HasAllKeyHandlers,
HasValue<String>,
HasSelectionHandlers<SuggestOracle.Suggestion>,
IsEditor<LeafValueEditor<String>> {
    private static final String STYLENAME_DEFAULT = "gwt-SuggestBox";
    private int limit = 20;
    private boolean selectsFirstItem = true;
    private SuggestOracle oracle;
    private String currentText;
    private LeafValueEditor<String> editor;
    private final SuggestionDisplay display;
    private final ValueBoxBase<String> box;
    private final SuggestOracle.Callback callback = new SuggestOracle.Callback(){

        @Override
        public void onSuggestionsReady(SuggestOracle.Request request, SuggestOracle.Response response) {
            if (!SuggestBox.this.isEnabled()) {
                return;
            }
            SuggestBox.this.display.setMoreSuggestions(response.hasMoreSuggestions(), response.getMoreSuggestionsCount());
            SuggestBox.this.display.showSuggestions(SuggestBox.this, response.getSuggestions(), SuggestBox.this.oracle.isDisplayStringHTML(), SuggestBox.this.isAutoSelectEnabled(), SuggestBox.this.suggestionCallback);
        }
    };
    private final SuggestionCallback suggestionCallback = new SuggestionCallback(){

        @Override
        public void onSuggestionSelected(SuggestOracle.Suggestion suggestion) {
            SuggestBox.this.box.setFocus(true);
            SuggestBox.this.setNewSelection(suggestion);
        }
    };

    public static SuggestBox wrap(SuggestOracle oracle, Element element) {
        assert (Document.get().getBody().isOrHasChild(element));
        TextBox textBox = new TextBox(element);
        SuggestBox suggestBox = new SuggestBox(oracle, textBox);
        suggestBox.onAttach();
        RootPanel.detachOnWindowClose(suggestBox);
        return suggestBox;
    }

    public SuggestBox() {
        this(new MultiWordSuggestOracle());
    }

    public SuggestBox(SuggestOracle oracle) {
        this(oracle, new TextBox());
    }

    public SuggestBox(SuggestOracle oracle, ValueBoxBase<String> box) {
        this(oracle, box, new DefaultSuggestionDisplay());
    }

    public SuggestBox(SuggestOracle oracle, ValueBoxBase<String> box, SuggestionDisplay suggestDisplay) {
        this.box = box;
        this.display = suggestDisplay;
        this.initWidget(box);
        this.addEventsToTextBox();
        this.setOracle(oracle);
        this.setStyleName(STYLENAME_DEFAULT);
    }

    @Override
    @Deprecated
    public void addChangeListener(ChangeListener listener) {
        ListenerWrapper.WrappedLogicalChangeListener.add(this.box, listener).setSource(this);
    }

    @Override
    @Deprecated
    public void addClickListener(ClickListener listener) {
        ListenerWrapper.WrappedClickListener legacy = ListenerWrapper.WrappedClickListener.add(this.box, listener);
        legacy.setSource(this);
    }

    @Override
    @Deprecated
    public void addEventHandler(SuggestionHandler handler) {
        ListenerWrapper.WrappedOldSuggestionHandler.add(this, handler);
    }

    @Override
    @Deprecated
    public void addFocusListener(FocusListener listener) {
        ListenerWrapper.WrappedFocusListener focus = ListenerWrapper.WrappedFocusListener.add(this.box, listener);
        focus.setSource(this);
    }

    @Override
    @Deprecated
    public void addKeyboardListener(KeyboardListener listener) {
        ListenerWrapper.WrappedKeyboardListener.add(this, listener);
    }

    @Override
    public HandlerRegistration addKeyDownHandler(KeyDownHandler handler) {
        return this.addDomHandler(handler, KeyDownEvent.getType());
    }

    @Override
    public HandlerRegistration addKeyPressHandler(KeyPressHandler handler) {
        return this.addDomHandler(handler, KeyPressEvent.getType());
    }

    @Override
    public HandlerRegistration addKeyUpHandler(KeyUpHandler handler) {
        return this.addDomHandler(handler, KeyUpEvent.getType());
    }

    @Override
    public HandlerRegistration addSelectionHandler(SelectionHandler<SuggestOracle.Suggestion> handler) {
        return this.addHandler(handler, SelectionEvent.getType());
    }

    @Override
    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<String> handler) {
        return this.addHandler(handler, ValueChangeEvent.getType());
    }

    @Override
    public LeafValueEditor<String> asEditor() {
        if (this.editor == null) {
            this.editor = TakesValueEditor.of(this);
        }
        return this.editor;
    }

    public int getLimit() {
        return this.limit;
    }

    public SuggestionDisplay getSuggestionDisplay() {
        return this.display;
    }

    public SuggestOracle getSuggestOracle() {
        return this.oracle;
    }

    @Override
    public int getTabIndex() {
        return this.box.getTabIndex();
    }

    @Override
    public String getText() {
        return this.box.getText();
    }

    @Deprecated
    public TextBoxBase getTextBox() {
        return (TextBoxBase)this.box;
    }

    @Override
    public String getValue() {
        return this.box.getValue();
    }

    public ValueBoxBase<String> getValueBox() {
        return this.box;
    }

    @Deprecated
    public void hideSuggestionList() {
        this.display.hideSuggestions();
    }

    @Override
    @Deprecated
    public boolean isAnimationEnabled() {
        return this.display.isAnimationEnabledImpl();
    }

    public boolean isAutoSelectEnabled() {
        return this.selectsFirstItem;
    }

    @Override
    public boolean isEnabled() {
        return this.box.isEnabled();
    }

    @Deprecated
    public boolean isSuggestionListShowing() {
        return this.display.isSuggestionListShowingImpl();
    }

    public void refreshSuggestionList() {
        if (this.isAttached()) {
            this.refreshSuggestions();
        }
    }

    @Override
    @Deprecated
    public void removeChangeListener(ChangeListener listener) {
        ListenerWrapper.WrappedChangeListener.remove(this.box, listener);
    }

    @Override
    @Deprecated
    public void removeClickListener(ClickListener listener) {
        ListenerWrapper.WrappedClickListener.remove(this.box, listener);
    }

    @Override
    @Deprecated
    public void removeEventHandler(SuggestionHandler handler) {
        ListenerWrapper.WrappedOldSuggestionHandler.remove(this, handler);
    }

    @Override
    @Deprecated
    public void removeFocusListener(FocusListener listener) {
        ListenerWrapper.WrappedFocusListener.remove(this, listener);
    }

    @Override
    @Deprecated
    public void removeKeyboardListener(KeyboardListener listener) {
        ListenerWrapper.WrappedKeyboardListener.remove(this, listener);
    }

    @Override
    public void setAccessKey(char key) {
        this.box.setAccessKey(key);
    }

    @Override
    @Deprecated
    public void setAnimationEnabled(boolean enable) {
        this.display.setAnimationEnabledImpl(enable);
    }

    public void setAutoSelectEnabled(boolean selectsFirstItem) {
        this.selectsFirstItem = selectsFirstItem;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.box.setEnabled(enabled);
        if (!enabled) {
            this.display.hideSuggestions();
        }
    }

    @Override
    public void setFocus(boolean focused) {
        this.box.setFocus(focused);
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Deprecated
    public void setPopupStyleName(String style) {
        this.getSuggestionDisplay().setPopupStyleNameImpl(style);
    }

    @Override
    public void setTabIndex(int index) {
        this.box.setTabIndex(index);
    }

    @Override
    public void setText(String text) {
        this.box.setText(text);
    }

    @Override
    public void setValue(String newValue) {
        this.box.setValue(newValue);
    }

    @Override
    public void setValue(String value, boolean fireEvents) {
        this.box.setValue(value, fireEvents);
    }

    public void showSuggestionList() {
        if (this.isAttached()) {
            this.currentText = null;
            this.refreshSuggestions();
        }
    }

    @Override
    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        this.display.onEnsureDebugId(baseID);
    }

    void showSuggestions(String query) {
        if (query.length() == 0) {
            this.oracle.requestDefaultSuggestions(new SuggestOracle.Request(null, this.limit), this.callback);
        } else {
            this.oracle.requestSuggestions(new SuggestOracle.Request(query, this.limit), this.callback);
        }
    }

    private void addEventsToTextBox() {
        class TextBoxEvents
        implements KeyDownHandler,
        KeyUpHandler,
        ValueChangeHandler<String> {
            TextBoxEvents() {
            }

            @Override
            public void onKeyDown(KeyDownEvent event) {
                switch (event.getNativeKeyCode()) {
                    case 40: {
                        SuggestBox.this.display.moveSelectionDown();
                        break;
                    }
                    case 38: {
                        SuggestBox.this.display.moveSelectionUp();
                        break;
                    }
                    case 9: 
                    case 13: {
                        SuggestOracle.Suggestion suggestion = SuggestBox.this.display.getCurrentSelection();
                        if (suggestion == null) {
                            SuggestBox.this.display.hideSuggestions();
                            break;
                        }
                        SuggestBox.this.setNewSelection(suggestion);
                    }
                }
            }

            @Override
            public void onKeyUp(KeyUpEvent event) {
                SuggestBox.this.refreshSuggestions();
            }

            @Override
            public void onValueChange(ValueChangeEvent<String> event) {
                SuggestBox.this.delegateEvent(SuggestBox.this, event);
            }
        }
        TextBoxEvents events = new TextBoxEvents();
        this.box.addKeyDownHandler(events);
        this.box.addKeyUpHandler(events);
        this.box.addValueChangeHandler(events);
    }

    private void fireSuggestionEvent(SuggestOracle.Suggestion selectedSuggestion) {
        SelectionEvent.fire(this, selectedSuggestion);
    }

    private void refreshSuggestions() {
        String text = this.getText();
        if (text.equals(this.currentText)) {
            return;
        }
        this.currentText = text;
        this.showSuggestions(text);
    }

    private void setNewSelection(SuggestOracle.Suggestion curSuggestion) {
        assert (curSuggestion != null) : "suggestion cannot be null";
        this.currentText = curSuggestion.getReplacementString();
        this.setText(this.currentText);
        this.display.hideSuggestions();
        this.fireSuggestionEvent(curSuggestion);
    }

    private void setOracle(SuggestOracle oracle) {
        this.oracle = oracle;
    }

    private static class SuggestionMenuItem
    extends MenuItem {
        private static final String STYLENAME_DEFAULT = "item";
        private SuggestOracle.Suggestion suggestion;

        public SuggestionMenuItem(SuggestOracle.Suggestion suggestion, boolean asHTML) {
            super(suggestion.getDisplayString(), asHTML);
            this.getElement().getStyle().setProperty("whiteSpace", "nowrap");
            this.setStyleName(STYLENAME_DEFAULT);
            this.setSuggestion(suggestion);
        }

        public SuggestOracle.Suggestion getSuggestion() {
            return this.suggestion;
        }

        public void setSuggestion(SuggestOracle.Suggestion suggestion) {
            this.suggestion = suggestion;
        }
    }

    private static class SuggestionMenu
    extends MenuBar {
        public SuggestionMenu(boolean vertical) {
            super(vertical);
            this.setStyleName("");
            this.setFocusOnHoverEnabled(false);
        }

        public int getNumItems() {
            return this.getItems().size();
        }

        public int getSelectedItemIndex() {
            MenuItem selectedItem = this.getSelectedItem();
            if (selectedItem != null) {
                return this.getItems().indexOf(selectedItem);
            }
            return -1;
        }

        public void selectItem(int index) {
            List<MenuItem> items = this.getItems();
            if (index > -1 && index < items.size()) {
                this.itemOver(items.get(index), false);
            }
        }
    }

    public static class DefaultSuggestionDisplay
    extends SuggestionDisplay
    implements HasAnimation {
        private final SuggestionMenu suggestionMenu = new SuggestionMenu(true);
        private final PopupPanel suggestionPopup = this.createPopup();
        private SuggestBox lastSuggestBox = null;
        private boolean hideWhenEmpty = true;
        private UIObject positionRelativeTo;

        public DefaultSuggestionDisplay() {
            this.suggestionPopup.setWidget(this.decorateSuggestionList(this.suggestionMenu));
        }

        @Override
        public void hideSuggestions() {
            this.suggestionPopup.hide();
        }

        @Override
        public boolean isAnimationEnabled() {
            return this.suggestionPopup.isAnimationEnabled();
        }

        public boolean isSuggestionListHiddenWhenEmpty() {
            return this.hideWhenEmpty;
        }

        public boolean isSuggestionListShowing() {
            return this.suggestionPopup.isShowing();
        }

        @Override
        public void setAnimationEnabled(boolean enable) {
            this.suggestionPopup.setAnimationEnabled(enable);
        }

        public void setPopupStyleName(String style) {
            this.suggestionPopup.setStyleName(style);
        }

        public void setPositionRelativeTo(UIObject uiObject) {
            this.positionRelativeTo = uiObject;
        }

        public void setSuggestionListHiddenWhenEmpty(boolean hideWhenEmpty) {
            this.hideWhenEmpty = hideWhenEmpty;
        }

        protected PopupPanel createPopup() {
            DecoratedPopupPanel p = new DecoratedPopupPanel(true, false, "suggestPopup");
            p.setStyleName("gwt-SuggestBoxPopup");
            p.setPreviewingAllNativeEvents(true);
            p.setAnimationType(PopupPanel.AnimationType.ROLL_DOWN);
            return p;
        }

        protected Widget decorateSuggestionList(Widget suggestionList) {
            return suggestionList;
        }

        @Override
        protected SuggestOracle.Suggestion getCurrentSelection() {
            if (!this.isSuggestionListShowing()) {
                return null;
            }
            MenuItem item = this.suggestionMenu.getSelectedItem();
            return item == null ? null : ((SuggestionMenuItem)item).getSuggestion();
        }

        protected PopupPanel getPopupPanel() {
            return this.suggestionPopup;
        }

        protected MenuBar getSuggestionMenu() {
            return this.suggestionMenu;
        }

        @Override
        protected void moveSelectionDown() {
            if (this.isSuggestionListShowing()) {
                this.suggestionMenu.selectItem(this.suggestionMenu.getSelectedItemIndex() + 1);
            }
        }

        @Override
        protected void moveSelectionUp() {
            if (this.isSuggestionListShowing()) {
                if (this.suggestionMenu.getSelectedItemIndex() == -1) {
                    this.suggestionMenu.selectItem(this.suggestionMenu.getNumItems() - 1);
                } else {
                    this.suggestionMenu.selectItem(this.suggestionMenu.getSelectedItemIndex() - 1);
                }
            }
        }

        @Override
        protected void onEnsureDebugId(String baseID) {
            this.suggestionPopup.ensureDebugId(String.valueOf(baseID).concat("-popup"));
            this.suggestionMenu.setMenuItemDebugIds(baseID);
        }

        @Override
        protected void showSuggestions(SuggestBox suggestBox, Collection<? extends SuggestOracle.Suggestion> suggestions, boolean isDisplayStringHTML, boolean isAutoSelectEnabled, final SuggestionCallback callback) {
            boolean anySuggestions;
            boolean bl = anySuggestions = suggestions != null && suggestions.size() > 0;
            if (!anySuggestions && this.hideWhenEmpty) {
                this.hideSuggestions();
                return;
            }
            if (this.suggestionPopup.isAttached()) {
                this.suggestionPopup.hide();
            }
            this.suggestionMenu.clearItems();
            for (final SuggestOracle.Suggestion suggestion : suggestions) {
                SuggestionMenuItem menuItem = new SuggestionMenuItem(suggestion, isDisplayStringHTML);
                menuItem.setScheduledCommand(new Scheduler.ScheduledCommand(){

                    @Override
                    public void execute() {
                        callback.onSuggestionSelected(suggestion);
                    }
                });
                this.suggestionMenu.addItem(menuItem);
            }
            if (isAutoSelectEnabled && anySuggestions) {
                this.suggestionMenu.selectItem(0);
            }
            if (this.lastSuggestBox != suggestBox) {
                if (this.lastSuggestBox != null) {
                    this.suggestionPopup.removeAutoHidePartner(this.lastSuggestBox.getElement());
                }
                this.lastSuggestBox = suggestBox;
                this.suggestionPopup.addAutoHidePartner(suggestBox.getElement());
            }
            this.suggestionPopup.showRelativeTo(this.positionRelativeTo != null ? this.positionRelativeTo : suggestBox);
        }

        @Override
        boolean isAnimationEnabledImpl() {
            return this.isAnimationEnabled();
        }

        @Override
        boolean isSuggestionListShowingImpl() {
            return this.isSuggestionListShowing();
        }

        @Override
        void setAnimationEnabledImpl(boolean enable) {
            this.setAnimationEnabled(enable);
        }

        @Override
        void setPopupStyleNameImpl(String style) {
            this.setPopupStyleName(style);
        }
    }

    public static abstract class SuggestionDisplay {
        protected abstract SuggestOracle.Suggestion getCurrentSelection();

        protected abstract void hideSuggestions();

        protected abstract void moveSelectionDown();

        protected abstract void moveSelectionUp();

        protected void onEnsureDebugId(String suggestBoxBaseID) {
        }

        protected void setMoreSuggestions(boolean hasMoreSuggestions, int numMoreSuggestions) {
        }

        protected abstract void showSuggestions(SuggestBox var1, Collection<? extends SuggestOracle.Suggestion> var2, boolean var3, boolean var4, SuggestionCallback var5);

        @Deprecated
        boolean isAnimationEnabledImpl() {
            return false;
        }

        @Deprecated
        boolean isSuggestionListShowingImpl() {
            return false;
        }

        @Deprecated
        void setAnimationEnabledImpl(boolean enable) {
        }

        @Deprecated
        void setPopupStyleNameImpl(String style) {
        }
    }

    public static interface SuggestionCallback {
        public void onSuggestionSelected(SuggestOracle.Suggestion var1);
    }
}

