/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc;

import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

class SerializationPolicyClient {
    private final int connectTimeout;
    private final int readTimeout;

    SerializationPolicyClient(int connectTimeoutMs, int readTimeoutMs) {
        this.connectTimeout = connectTimeoutMs;
        this.readTimeout = readTimeoutMs;
    }

    SerializationPolicy loadPolicy(String url, Logger logger) {
        InputStream in;
        URL urlObj;
        try {
            urlObj = new URL(url);
        }
        catch (MalformedURLException e) {
            String string = String.valueOf(url);
            logger.logError(string.length() != 0 ? "Can't parse serialization policy URL: ".concat(string) : new String("Can't parse serialization policy URL: "), e);
            return null;
        }
        try {
            URLConnection conn = urlObj.openConnection();
            conn.setConnectTimeout(this.connectTimeout);
            conn.setReadTimeout(this.readTimeout);
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).setInstanceFollowRedirects(false);
            }
            conn.connect();
            in = conn.getInputStream();
        }
        catch (IOException e) {
            String string = String.valueOf(url);
            logger.logError(string.length() != 0 ? "Can't open serialization policy URL: ".concat(string) : new String("Can't open serialization policy URL: "), e);
            return null;
        }
        return SerializationPolicyClient.readPolicy(in, url, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static SerializationPolicy readPolicy(InputStream in, String sourceName, Logger logger) {
        ArrayList<ClassNotFoundException> errs = new ArrayList<ClassNotFoundException>();
        SerializationPolicy policy = SerializationPolicyLoader.loadFromStream(in, errs);
        String string = String.valueOf(sourceName);
        logger.logInfo(string.length() != 0 ? "Downloaded serialization policy from ".concat(string) : new String("Downloaded serialization policy from "));
        if (!errs.isEmpty()) {
            SerializationPolicyClient.logMissingClasses(logger, errs);
        }
        SerializationPolicy serializationPolicy = policy;
        try {
            in.close();
        }
        catch (IOException e) {
            String string2 = String.valueOf(sourceName);
            logger.logError(string2.length() != 0 ? "Can't close serialization policy url: ".concat(string2) : new String("Can't close serialization policy url: "), e);
        }
        return serializationPolicy;
        catch (ParseException e) {
            String string3 = String.valueOf(sourceName);
            logger.logError(string3.length() != 0 ? "Can't parse serialization policy from ".concat(string3) : new String("Can't parse serialization policy from "), e);
            SerializationPolicy serializationPolicy2 = null;
            try {
                in.close();
            }
            catch (IOException e2) {
                String string4 = String.valueOf(sourceName);
                logger.logError(string4.length() != 0 ? "Can't close serialization policy url: ".concat(string4) : new String("Can't close serialization policy url: "), e2);
            }
            return serializationPolicy2;
        }
        catch (IOException e2) {
            String string5 = String.valueOf(sourceName);
            logger.logError(string5.length() != 0 ? "Can't read serialization policy from ".concat(string5) : new String("Can't read serialization policy from "), e2);
            SerializationPolicy serializationPolicy3 = null;
            {
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (IOException e3) {
                        String string6 = String.valueOf(sourceName);
                        logger.logError(string6.length() != 0 ? "Can't close serialization policy url: ".concat(string6) : new String("Can't close serialization policy url: "), e3);
                    }
                    throw throwable;
                }
            }
            try {
                in.close();
            }
            catch (IOException e4) {
                String string7 = String.valueOf(sourceName);
                logger.logError(string7.length() != 0 ? "Can't close serialization policy url: ".concat(string7) : new String("Can't close serialization policy url: "), e4);
            }
            return serializationPolicy3;
        }
    }

    private static void logMissingClasses(Logger logger, List<ClassNotFoundException> errs) {
        StringBuilder message = new StringBuilder();
        message.append("Unable to load server-side classes used by policy:\n");
        int limit = Math.min(10, errs.size());
        for (int i = 0; i < limit; ++i) {
            String string = String.valueOf(String.valueOf(errs.get(i).getMessage()));
            message.append(new StringBuilder(3 + string.length()).append("  ").append(string).append("\n").toString());
        }
        int omitted = errs.size() - limit;
        if (omitted > 0) {
            int n = omitted;
            message.append(new StringBuilder(37).append("  (omitted ").append(n).append(" more classes)\n").toString());
        }
        logger.logInfo(message.toString());
    }

    static interface Logger {
        public void logInfo(String var1);

        public void logError(String var1, Throwable var2);
    }
}

