/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.util.regexfilter;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class RegexFilter {
    private final List<String> values;
    private final ArrayList<Pattern> typePatterns;
    private final ArrayList<Boolean> includeType;

    public RegexFilter(TreeLogger logger, List<String> values) throws UnableToCompleteException {
        this.values = values;
        int size = values.size();
        this.typePatterns = new ArrayList(size);
        this.includeType = new ArrayList(size);
        for (String regex : values) {
            String string;
            boolean include = this.entriesArePositiveByDefault();
            if (regex.length() == 0) {
                logger.log(TreeLogger.ERROR, "Got empty blacklist entry");
                throw new UnableToCompleteException();
            }
            char c = regex.charAt(0);
            if (c == '+' || c == '-') {
                regex = regex.substring(1);
                include = c == '+';
            }
            try {
                Pattern p = Pattern.compile(regex);
                this.typePatterns.add(p);
                this.includeType.add(include);
                if (!logger.isLoggable(TreeLogger.DEBUG)) continue;
                string = String.valueOf(String.valueOf(regex));
                logger.log(TreeLogger.DEBUG, new StringBuilder(19 + string.length()).append("Got filter entry '").append(string).append("'").toString());
            }
            catch (PatternSyntaxException e) {
                string = String.valueOf(String.valueOf(regex));
                logger.log(TreeLogger.ERROR, new StringBuilder(29 + string.length()).append("Got malformed filter entry '").append(string).append("'").toString());
                throw new UnableToCompleteException();
            }
        }
    }

    public boolean isIncluded(TreeLogger logger, String query) {
        String string = String.valueOf(query);
        logger = logger.branch(TreeLogger.DEBUG, string.length() != 0 ? "Considering query ".concat(string) : new String("Considering query "));
        int size = this.typePatterns.size();
        for (int idx = size - 1; idx >= 0; --idx) {
            if (logger.isLoggable(TreeLogger.DEBUG)) {
                String string2 = String.valueOf(String.valueOf(this.values.get(idx)));
                String string3 = String.valueOf(String.valueOf(query));
                logger.log(TreeLogger.DEBUG, new StringBuilder(35 + string2.length() + string3.length()).append("Considering filter rule ").append(string2).append(" for query ").append(string3).toString());
            }
            boolean include = this.includeType.get(idx);
            Pattern pattern = this.typePatterns.get(idx);
            if (!pattern.matcher(query).matches()) continue;
            if (include) {
                if (logger.isLoggable(TreeLogger.DEBUG)) {
                    String string4 = String.valueOf(String.valueOf(query));
                    String string5 = String.valueOf(String.valueOf(this.values.get(idx)));
                    logger.log(TreeLogger.DEBUG, new StringBuilder(32 + string4.length() + string5.length()).append("Whitelisting ").append(string4).append(" according to rule ").append(string5).toString());
                }
                return true;
            }
            if (logger.isLoggable(TreeLogger.DEBUG)) {
                String string6 = String.valueOf(String.valueOf(query));
                String string7 = String.valueOf(String.valueOf(this.values.get(idx)));
                logger.log(TreeLogger.DEBUG, new StringBuilder(32 + string6.length() + string7.length()).append("Blacklisting ").append(string6).append(" according to rule ").append(string7).toString());
            }
            return false;
        }
        return this.acceptByDefault();
    }

    protected abstract boolean acceptByDefault();

    protected abstract boolean entriesArePositiveByDefault();
}

