/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.validation.client.constraints;

import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.Pattern;

public class PatternValidator
implements ConstraintValidator<Pattern, String> {
    private RegExp pattern;

    public final void initialize(Pattern annotation) {
        Pattern.Flag[] flags = annotation.flags();
        String flagString = "";
        for (Pattern.Flag flag : flags) {
            String string = String.valueOf(flagString);
            String string2 = String.valueOf(this.toString(flag));
            flagString = string2.length() != 0 ? string.concat(string2) : new String(string);
        }
        this.pattern = RegExp.compile(annotation.regexp(), flagString);
    }

    public final boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        MatchResult match = this.pattern.exec(value);
        if (match == null) {
            return false;
        }
        return match.getGroup(0).length() == value.length();
    }

    private final String toString(Pattern.Flag flag) {
        String value;
        switch (flag) {
            case CASE_INSENSITIVE: 
            case UNICODE_CASE: {
                value = "i";
                break;
            }
            case MULTILINE: {
                value = "m";
                break;
            }
            default: {
                String string = String.valueOf(String.valueOf(flag));
                throw new IllegalArgumentException(new StringBuilder(44 + string.length()).append(string).append(" is not a suppoted gwt Pattern (RegExp) flag").toString());
            }
        }
        return value;
    }
}

