/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.server;

import com.google.gwt.user.server.Base64Utils;
import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanCodex;
import com.google.web.bindery.autobean.shared.AutoBeanFactory;
import com.google.web.bindery.autobean.shared.AutoBeanUtils;
import com.google.web.bindery.autobean.shared.AutoBeanVisitor;
import com.google.web.bindery.autobean.shared.Splittable;
import com.google.web.bindery.autobean.shared.ValueCodex;
import com.google.web.bindery.autobean.vm.AutoBeanFactorySource;
import com.google.web.bindery.autobean.vm.Configuration;
import com.google.web.bindery.autobean.vm.impl.TypeUtils;
import com.google.web.bindery.requestfactory.server.DefaultExceptionHandler;
import com.google.web.bindery.requestfactory.server.ExceptionHandler;
import com.google.web.bindery.requestfactory.server.ReportableException;
import com.google.web.bindery.requestfactory.server.RequestState;
import com.google.web.bindery.requestfactory.server.ServiceLayer;
import com.google.web.bindery.requestfactory.server.UnexpectedException;
import com.google.web.bindery.requestfactory.shared.BaseProxy;
import com.google.web.bindery.requestfactory.shared.EntityProxyId;
import com.google.web.bindery.requestfactory.shared.InstanceRequest;
import com.google.web.bindery.requestfactory.shared.Request;
import com.google.web.bindery.requestfactory.shared.RequestContext;
import com.google.web.bindery.requestfactory.shared.ServerFailure;
import com.google.web.bindery.requestfactory.shared.WriteOperation;
import com.google.web.bindery.requestfactory.shared.impl.BaseProxyCategory;
import com.google.web.bindery.requestfactory.shared.impl.EntityCodex;
import com.google.web.bindery.requestfactory.shared.impl.EntityProxyCategory;
import com.google.web.bindery.requestfactory.shared.impl.SimpleProxyId;
import com.google.web.bindery.requestfactory.shared.impl.ValueProxyCategory;
import com.google.web.bindery.requestfactory.shared.messages.IdMessage;
import com.google.web.bindery.requestfactory.shared.messages.InvocationMessage;
import com.google.web.bindery.requestfactory.shared.messages.MessageFactory;
import com.google.web.bindery.requestfactory.shared.messages.OperationMessage;
import com.google.web.bindery.requestfactory.shared.messages.RequestMessage;
import com.google.web.bindery.requestfactory.shared.messages.ResponseMessage;
import com.google.web.bindery.requestfactory.shared.messages.ServerFailureMessage;
import com.google.web.bindery.requestfactory.shared.messages.ViolationMessage;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.validation.ConstraintViolation;

public class SimpleRequestProcessor {
    static final Configuration CONFIGURATION = new Configuration.Builder().setCategories(EntityProxyCategory.class, ValueProxyCategory.class, BaseProxyCategory.class).setNoWrap(EntityProxyId.class).build();
    static final MessageFactory FACTORY = AutoBeanFactorySource.create(MessageFactory.class);
    private ExceptionHandler exceptionHandler = new DefaultExceptionHandler();
    private final ServiceLayer service;

    static String fromBase64(String encoded) {
        try {
            return new String(Base64Utils.fromBase64(encoded), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnexpectedException(e);
        }
    }

    static String toBase64(String data) {
        try {
            return Base64Utils.toBase64(data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new UnexpectedException(e);
        }
    }

    public SimpleRequestProcessor(ServiceLayer serviceLayer) {
        this.service = serviceLayer;
    }

    public String process(String payload) {
        RequestMessage req = AutoBeanCodex.decode((AutoBeanFactory)FACTORY, RequestMessage.class, payload).as();
        AutoBean<ResponseMessage> responseBean = FACTORY.response();
        try {
            this.process(req, responseBean.as());
        }
        catch (ReportableException e) {
            responseBean = FACTORY.response();
            responseBean.as().setGeneralFailure(this.createFailureMessage(e).as());
        }
        return AutoBeanCodex.encode(responseBean).getPayload();
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    <T> Splittable createOobMessage(List<T> domainValues) {
        RequestState state = new RequestState(this.service);
        ArrayList<Splittable> encodedValues = new ArrayList<Splittable>(domainValues.size());
        for (T domainValue : domainValues) {
            Object clientValue;
            if (domainValue == null) {
                clientValue = null;
            } else {
                Class<BaseProxy> clientType = this.service.resolveClientType(domainValue.getClass(), BaseProxy.class, true);
                clientValue = state.getResolver().resolveClientValue(domainValue, clientType, Collections.<String>emptySet());
            }
            encodedValues.add(EntityCodex.encode(state, clientValue));
        }
        IdToEntityMap map = new IdToEntityMap();
        map.putAll(state.beans);
        ArrayList<OperationMessage> operations = new ArrayList<OperationMessage>();
        this.createReturnOperations(operations, state, map);
        InvocationMessage invocation = FACTORY.invocation().as();
        invocation.setParameters(encodedValues);
        AutoBean<RequestMessage> bean = FACTORY.request();
        RequestMessage resp = bean.as();
        resp.setInvocations(Collections.singletonList(invocation));
        resp.setOperations(operations);
        return AutoBeanCodex.encode(bean);
    }

    <T> List<T> decodeOobMessage(Class<T> domainClass, Splittable payload) {
        List<Object> decoded;
        Class<BaseProxy> proxyType = this.service.resolveClientType(domainClass, BaseProxy.class, true);
        RequestState state = new RequestState(this.service);
        RequestMessage message = AutoBeanCodex.decode((AutoBeanFactory)FACTORY, RequestMessage.class, payload).as();
        this.processOperationMessages(state, message);
        List<Object> toReturn = decoded = this.decodeInvocationArguments(state, message.getInvocations().get(0).getParameters(), new Class[]{proxyType}, new Type[]{domainClass});
        return toReturn;
    }

    void process(RequestMessage req, ResponseMessage resp) {
        RequestState source = new RequestState(this.service);
        String requestFactoryToken = req.getRequestFactory();
        if (requestFactoryToken == null) {
            throw new ReportableException("The client payload version is out of sync with the server");
        }
        this.service.resolveRequestFactory(requestFactoryToken);
        this.processOperationMessages(source, req);
        List<ViolationMessage> errorMessages = this.validateEntities(source);
        if (!errorMessages.isEmpty()) {
            resp.setViolations(errorMessages);
            return;
        }
        RequestState returnState = new RequestState(source);
        ArrayList<Splittable> invocationResults = new ArrayList<Splittable>();
        ArrayList<Boolean> invocationSuccess = new ArrayList<Boolean>();
        this.processInvocationMessages(source, req, invocationResults, invocationSuccess, returnState);
        ArrayList<OperationMessage> operations = new ArrayList<OperationMessage>();
        IdToEntityMap toProcess = new IdToEntityMap();
        toProcess.putAll(source.beans);
        toProcess.putAll(returnState.beans);
        this.createReturnOperations(operations, returnState, toProcess);
        assert (invocationResults.size() == invocationSuccess.size());
        if (!invocationResults.isEmpty()) {
            resp.setInvocationResults(invocationResults);
            resp.setStatusCodes(invocationSuccess);
        }
        if (!operations.isEmpty()) {
            resp.setOperations(operations);
        }
    }

    private AutoBean<ServerFailureMessage> createFailureMessage(ReportableException e) {
        ServerFailure failure = this.exceptionHandler.createServerFailure(e.getCause() == null ? e : e.getCause());
        AutoBean<ServerFailureMessage> bean = FACTORY.failure();
        ServerFailureMessage msg = bean.as();
        msg.setExceptionType(failure.getExceptionType());
        msg.setMessage(failure.getMessage());
        msg.setStackTrace(failure.getStackTraceString());
        msg.setFatal(failure.isFatal());
        return bean;
    }

    private void createReturnOperations(List<OperationMessage> operations, RequestState returnState, IdToEntityMap toProcess) {
        for (Map.Entry entry : toProcess.entrySet()) {
            boolean inResponse;
            SimpleProxyId id = (SimpleProxyId)entry.getKey();
            AutoBean bean = (AutoBean)entry.getValue();
            Object domainObject = bean.getTag("domainObject");
            if (id.isEphemeral() && returnState.isEntityType(id.getProxyClass())) {
                returnState.getResolver().resolveClientValue(domainObject, id.getProxyClass(), Collections.<String>emptySet());
            }
            WriteOperation writeOperation = id.isEphemeral() || id.isSynthetic() || domainObject == null ? null : (!this.service.isLive(domainObject) ? WriteOperation.DELETE : (id.wasEphemeral() ? WriteOperation.PERSIST : WriteOperation.UPDATE));
            Splittable version = null;
            if (writeOperation == WriteOperation.PERSIST || writeOperation == WriteOperation.UPDATE) {
                Object domainVersion = this.service.getVersion(domainObject);
                if (domainVersion == null) {
                    String string = String.valueOf(String.valueOf(this.service.getId(domainObject)));
                    throw new UnexpectedException(new StringBuilder(48 + string.length()).append("The persisted entity with id ").append(string).append(" has a null version").toString(), null);
                }
                version = returnState.flatten(domainVersion);
            }
            boolean bl = inResponse = bean.getTag("inResponse") != null;
            if (WriteOperation.UPDATE.equals((Object)writeOperation) && !inResponse) {
                String previousVersion = (String)bean.getTag("version");
                if (version != null && previousVersion != null && version.equals(SimpleRequestProcessor.fromBase64(previousVersion))) continue;
            }
            OperationMessage op = FACTORY.operation().as();
            if (id.wasEphemeral()) {
                op.setClientId(id.getClientId());
            }
            op.setOperation(writeOperation);
            if (inResponse) {
                LinkedHashMap<String, Splittable> propertyMap = new LinkedHashMap<String, Splittable>();
                Map<String, Object> diff = AutoBeanUtils.getAllProperties(bean);
                for (Map.Entry<String, Object> d : diff.entrySet()) {
                    Object value = d.getValue();
                    if (value == null) continue;
                    propertyMap.put(d.getKey(), EntityCodex.encode(returnState, value));
                }
                op.setPropertyMap(propertyMap);
            }
            if (!id.isEphemeral() && !id.isSynthetic()) {
                op.setServerId(SimpleRequestProcessor.toBase64(id.getServerId()));
            }
            if (id.isSynthetic()) {
                op.setStrength(IdMessage.Strength.SYNTHETIC);
                op.setSyntheticId(id.getSyntheticId());
            } else if (id.isEphemeral()) {
                op.setStrength(IdMessage.Strength.EPHEMERAL);
            }
            op.setTypeToken(this.service.resolveTypeToken(id.getProxyClass()));
            if (version != null) {
                op.setVersion(SimpleRequestProcessor.toBase64(version.getPayload()));
            }
            operations.add(op);
        }
    }

    private List<Object> decodeInvocationArguments(RequestState source, InvocationMessage invocation, Method contextMethod) {
        boolean isStatic = Request.class.isAssignableFrom(contextMethod.getReturnType());
        int baseLength = contextMethod.getParameterTypes().length;
        int length = baseLength + (isStatic ? 0 : 1);
        int offset = isStatic ? 0 : 1;
        Class[] contextArgs = new Class[length];
        Type[] genericArgs = new Type[length];
        if (!isStatic) {
            genericArgs[0] = TypeUtils.getSingleParameterization(InstanceRequest.class, contextMethod.getGenericReturnType());
            contextArgs[0] = TypeUtils.ensureBaseType(genericArgs[0]);
        }
        System.arraycopy(contextMethod.getParameterTypes(), 0, contextArgs, offset, baseLength);
        System.arraycopy(contextMethod.getGenericParameterTypes(), 0, genericArgs, offset, baseLength);
        List<Object> args = this.decodeInvocationArguments(source, invocation.getParameters(), contextArgs, genericArgs);
        return args;
    }

    private List<Object> decodeInvocationArguments(RequestState source, List<Splittable> parameters, Class<?>[] contextArgs, Type[] genericArgs) {
        if (parameters == null) {
            return new ArrayList<Object>();
        }
        assert (parameters.size() == contextArgs.length);
        ArrayList<Object> args = new ArrayList<Object>(contextArgs.length);
        int j = contextArgs.length;
        for (int i = 0; i < j; ++i) {
            Splittable split;
            Class<?> type = contextArgs[i];
            Class<?> elementType = null;
            if (Collection.class.isAssignableFrom(type)) {
                elementType = TypeUtils.ensureBaseType(TypeUtils.getSingleParameterization(Collection.class, genericArgs[i]));
                split = parameters.get(i);
            } else {
                split = parameters.get(i);
            }
            Object arg = EntityCodex.decode((EntityCodex.EntitySource)source, type, elementType, split);
            arg = source.getResolver().resolveDomainValue(arg, !EntityProxyId.class.equals(contextArgs[i]));
            args.add(arg);
        }
        return args;
    }

    private void processInvocationMessages(RequestState state, RequestMessage req, List<Splittable> results, List<Boolean> success, RequestState returnState) {
        List<InvocationMessage> invocations = req.getInvocations();
        if (invocations == null) {
            return;
        }
        ArrayList<Method> contextMethods = new ArrayList<Method>(invocations.size());
        ArrayList<Splittable> invocationResults = new ArrayList<Splittable>(invocations.size());
        HashMap<Object, TreeSet<String>> allPropertyRefs = new HashMap<Object, TreeSet<String>>();
        for (InvocationMessage invocation : invocations) {
            boolean ok;
            Object domainReturnValue;
            try {
                String operation = invocation.getOperation();
                Method contextMethod = this.service.resolveRequestContextMethod(operation);
                if (contextMethod == null) {
                    String string = String.valueOf(invocation.getOperation());
                    throw new UnexpectedException(string.length() != 0 ? "Cannot resolve operation ".concat(string) : new String("Cannot resolve operation "), null);
                }
                contextMethods.add(contextMethod);
                Method domainMethod = this.service.resolveDomainMethod(operation);
                if (domainMethod == null) {
                    String string = String.valueOf(invocation.getOperation());
                    throw new UnexpectedException(string.length() != 0 ? "Cannot resolve domain method ".concat(string) : new String("Cannot resolve domain method "), null);
                }
                List<Object> args = this.decodeInvocationArguments(state, invocation, contextMethod);
                if (this.service.requiresServiceLocator(contextMethod, domainMethod)) {
                    Class<? extends RequestContext> requestContext = this.service.resolveRequestContext(operation);
                    Object serviceInstance = this.service.createServiceInstance(requestContext);
                    args.add(0, serviceInstance);
                }
                domainReturnValue = this.service.invoke(domainMethod, args.toArray());
                if (invocation.getPropertyRefs() != null) {
                    TreeSet<String> paths = (TreeSet<String>)allPropertyRefs.get(domainReturnValue);
                    if (paths == null) {
                        paths = new TreeSet<String>();
                        allPropertyRefs.put(domainReturnValue, paths);
                    }
                    paths.addAll(invocation.getPropertyRefs());
                }
                ok = true;
            }
            catch (ReportableException e) {
                domainReturnValue = AutoBeanCodex.encode(this.createFailureMessage(e));
                ok = false;
            }
            invocationResults.add((Splittable)domainReturnValue);
            success.add(ok);
        }
        Iterator contextMethodIt = contextMethods.iterator();
        Iterator objects = invocationResults.iterator();
        Iterator<Boolean> successes = success.iterator();
        while (successes.hasNext()) {
            assert (contextMethodIt.hasNext());
            assert (objects.hasNext());
            Method contextMethod = (Method)contextMethodIt.next();
            Object returnValue = objects.next();
            if (successes.next().booleanValue()) {
                Type requestReturnType = this.service.getRequestReturnType(contextMethod);
                returnValue = state.getResolver().resolveClientValue(returnValue, requestReturnType, (Set)allPropertyRefs.get(returnValue));
                results.add(EntityCodex.encode(returnState, returnValue));
                continue;
            }
            results.add((Splittable)returnValue);
        }
    }

    private void processOperationMessages(final RequestState state, RequestMessage req) {
        List<OperationMessage> operations = req.getOperations();
        if (operations == null) {
            return;
        }
        List<AutoBean<? extends BaseProxy>> beans = state.getBeansForPayload(operations);
        assert (operations.size() == beans.size());
        Iterator<OperationMessage> itOp = operations.iterator();
        for (AutoBean<? extends BaseProxy> bean : beans) {
            Map<String, Splittable> flatValueMap;
            OperationMessage operation = itOp.next();
            bean.setTag("version", operation.getVersion());
            final Object domain = bean.getTag("domainObject");
            if (domain == null || (flatValueMap = operation.getPropertyMap()) == null) continue;
            bean.accept(new AutoBeanVisitor(){

                @Override
                public boolean visitReferenceProperty(String propertyName, AutoBean<?> value, AutoBeanVisitor.PropertyContext ctx) {
                    if (flatValueMap.containsKey(propertyName)) {
                        Object resolved = null;
                        if (ctx.getType() == Map.class) {
                            AutoBeanVisitor.MapPropertyContext mapCtx = (AutoBeanVisitor.MapPropertyContext)ctx;
                            Class<?> keyType = mapCtx.getKeyType();
                            Class<?> valueType = mapCtx.getValueType();
                            Object newValue = EntityCodex.decode(state, mapCtx.getType(), keyType, valueType, (Splittable)flatValueMap.get(propertyName));
                            resolved = state.getResolver().resolveDomainValue(newValue, false);
                        } else {
                            Class<?> elementType = ctx instanceof AutoBeanVisitor.CollectionPropertyContext ? ((AutoBeanVisitor.CollectionPropertyContext)ctx).getElementType() : null;
                            Object newValue = EntityCodex.decode((EntityCodex.EntitySource)state, ctx.getType(), elementType, (Splittable)flatValueMap.get(propertyName));
                            resolved = state.getResolver().resolveDomainValue(newValue, false);
                        }
                        SimpleRequestProcessor.this.service.setProperty(domain, propertyName, SimpleRequestProcessor.this.service.resolveDomainClass(ctx.getType()), resolved);
                    }
                    return false;
                }

                @Override
                public boolean visitValueProperty(String propertyName, Object value, AutoBeanVisitor.PropertyContext ctx) {
                    if (flatValueMap.containsKey(propertyName)) {
                        Splittable split = (Splittable)flatValueMap.get(propertyName);
                        Object newValue = ValueCodex.decode(ctx.getType(), split);
                        Object resolved = state.getResolver().resolveDomainValue(newValue, false);
                        SimpleRequestProcessor.this.service.setProperty(domain, propertyName, ctx.getType(), resolved);
                    }
                    return false;
                }
            });
        }
    }

    private List<ViolationMessage> validateEntities(RequestState source) {
        ArrayList<ViolationMessage> errorMessages = new ArrayList<ViolationMessage>();
        for (Map.Entry entry : source.beans.entrySet()) {
            Set errors;
            AutoBean bean = (AutoBean)entry.getValue();
            Object domainObject = bean.getTag("domainObject");
            if (domainObject == null || (errors = this.service.validate(domainObject)) == null || errors.isEmpty()) continue;
            SimpleProxyId id = (SimpleProxyId)entry.getKey();
            for (ConstraintViolation error : errors) {
                SimpleProxyId<?> stableId;
                IdMessage rootId = FACTORY.id().as();
                rootId.setClientId(id.getClientId());
                rootId.setTypeToken(this.service.resolveTypeToken(id.getProxyClass()));
                if (id.isEphemeral()) {
                    rootId.setStrength(IdMessage.Strength.EPHEMERAL);
                } else {
                    rootId.setServerId(SimpleRequestProcessor.toBase64(id.getServerId()));
                }
                IdMessage leafId = null;
                if (error.getLeafBean() != null && (stableId = source.getStableId(error.getLeafBean())) != null) {
                    leafId = FACTORY.id().as();
                    leafId.setClientId(stableId.getClientId());
                    leafId.setTypeToken(this.service.resolveTypeToken(stableId.getProxyClass()));
                    if (stableId.isEphemeral()) {
                        leafId.setStrength(IdMessage.Strength.EPHEMERAL);
                    } else {
                        leafId.setServerId(SimpleRequestProcessor.toBase64(stableId.getServerId()));
                    }
                }
                ViolationMessage message = FACTORY.violation().as();
                message.setLeafBeanId(leafId);
                message.setMessage(error.getMessage());
                message.setMessageTemplate(error.getMessageTemplate());
                message.setPath(error.getPropertyPath().toString());
                message.setRootBeanId(rootId);
                errorMessages.add(message);
            }
        }
        return errorMessages;
    }

    static class IdToEntityMap
    extends HashMap<SimpleProxyId<?>, AutoBean<? extends BaseProxy>> {
        IdToEntityMap() {
        }
    }
}

