/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.converter;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.resources.converter.Css2GssConversionException;
import com.google.gwt.resources.converter.SimpleValue;
import com.google.gwt.resources.css.ast.Context;
import com.google.gwt.resources.css.ast.CssProperty;
import com.google.gwt.resources.css.ast.CssRule;
import com.google.gwt.resources.css.ast.CssVisitor;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UndefinedConstantVisitor
extends CssVisitor {
    private final Set<String> gssContantNames;
    private final Pattern pattern = Pattern.compile("[A-Z][A-Z_0-9]+");
    private final Set<String> propertyNamesToSkip = Sets.newHashSet("filter", "-ms-filter", "font-family");
    private final boolean lenient;
    private final TreeLogger treeLogger;

    public UndefinedConstantVisitor(Set<String> gssContantNames, boolean lenient, TreeLogger treeLogger) {
        this.gssContantNames = gssContantNames;
        this.lenient = lenient;
        this.treeLogger = treeLogger;
    }

    @Override
    public boolean visit(CssRule x, Context ctx) {
        List<CssProperty> properties = x.getProperties();
        for (CssProperty cssProperty : properties) {
            if (this.propertyNamesToSkip.contains(cssProperty.getName())) continue;
            String cssPropertyString = cssProperty.getValues().toCss();
            Matcher matcher = this.pattern.matcher(cssPropertyString);
            boolean needsUpdate = false;
            while (matcher.find()) {
                String upperCaseString = matcher.group();
                if (this.gssContantNames.contains(upperCaseString)) continue;
                this.treeLogger.log(TreeLogger.Type.WARN, "Property '" + cssProperty.getName() + "' from rule '" + x.getSelectors().toString() + "' uses an undefined constant: " + upperCaseString);
                if (this.lenient) {
                    this.treeLogger.log(TreeLogger.Type.WARN, "turning '" + upperCaseString + "' to lower case. This is probably not what you wanted here in the " + "first place!");
                    cssPropertyString = cssPropertyString.replace(upperCaseString, upperCaseString.toLowerCase());
                    needsUpdate = true;
                    continue;
                }
                throw new Css2GssConversionException("Found undefined constant in input. " + cssProperty.getName() + "' from rule '" + x.getSelectors().toString() + "' undefined constant: " + upperCaseString);
            }
            if (!needsUpdate) continue;
            cssProperty.setValue(new SimpleValue(cssPropertyString));
        }
        return false;
    }
}

