/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.client.prefetch;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.impl.AsyncFragmentLoader;
import com.google.gwt.core.client.prefetch.PrefetchableResource;
import com.google.gwt.core.client.prefetch.RunAsyncCode;
import java.util.Arrays;

public class Prefetcher {
    public static void prefetch(Iterable<? extends PrefetchableResource> resources) {
        if (!GWT.isScript()) {
            return;
        }
        int[] runAsyncSplitPoints = new int[]{};
        int i = 0;
        for (PrefetchableResource prefetchableResource : resources) {
            if (prefetchableResource instanceof RunAsyncCode) {
                RunAsyncCode resourceRunAsync = (RunAsyncCode)prefetchableResource;
                int splitPoint = resourceRunAsync.getSplitPoint();
                if (splitPoint < 0) continue;
                runAsyncSplitPoints[i++] = splitPoint;
                continue;
            }
            String string = String.valueOf(prefetchableResource.getClass());
            throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(string).length()).append("Unknown resource type: ").append(string).toString());
        }
        AsyncFragmentLoader.BROWSER_LOADER.setPrefetchQueue(runAsyncSplitPoints);
    }

    public static void prefetch(PrefetchableResource resource) {
        Prefetcher.prefetch(Arrays.asList(resource));
    }

    public static void start() {
        if (!GWT.isScript()) {
            return;
        }
        AsyncFragmentLoader.BROWSER_LOADER.startPrefetching();
    }

    public static void stop() {
        if (!GWT.isScript()) {
            return;
        }
        AsyncFragmentLoader.BROWSER_LOADER.stopPrefetching();
    }
}

