/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.editor.ui.client.adapters;

import com.google.gwt.editor.client.EditorDelegate;
import com.google.gwt.editor.client.HasEditorDelegate;
import com.google.gwt.editor.client.adapters.TakesValueEditor;
import com.google.gwt.user.client.ui.ValueBoxBase;
import java.text.ParseException;

public class ValueBoxEditor<T>
extends TakesValueEditor<T>
implements HasEditorDelegate<T> {
    private EditorDelegate<T> delegate;
    private final ValueBoxBase<T> peer;
    private T value;

    public static <T> ValueBoxEditor<T> of(ValueBoxBase<T> valueBox) {
        return new ValueBoxEditor<T>(valueBox);
    }

    protected ValueBoxEditor(ValueBoxBase<T> peer) {
        super(peer);
        this.peer = peer;
    }

    public EditorDelegate<T> getDelegate() {
        return this.delegate;
    }

    @Override
    public T getValue() {
        try {
            this.value = this.peer.getValueOrThrow();
        }
        catch (ParseException e) {
            String string = this.peer.getText();
            this.getDelegate().recordError(new StringBuilder(12 + String.valueOf(string).length()).append("Bad value (").append(string).append(")").toString(), this.peer.getText(), e);
        }
        return this.value;
    }

    @Override
    public void setDelegate(EditorDelegate<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
        this.peer.setValue(this.value);
    }
}

