/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.logging.impl;

import com.google.gwt.core.client.GWT;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class DevModeLoggingFixes {
    private static Logger root = null;

    public static String getLoggerName(LogRecord record) {
        if (record.getLoggerName() != null) {
            return DevModeLoggingFixes.removeLoggerPrefix(record.getLoggerName());
        }
        return null;
    }

    public static String getName(Logger logger) {
        if (logger.getName() != null) {
            return DevModeLoggingFixes.removeLoggerPrefix(logger.getName());
        }
        return null;
    }

    public static Logger loggerGetLogger(String name) {
        if (root == null) {
            root = Logger.getLogger(DevModeLoggingFixes.getPrefixName());
            root.setUseParentHandlers(false);
        }
        return Logger.getLogger(DevModeLoggingFixes.addLoggerPrefix(name));
    }

    public static Logger logManagerGetLogger(LogManager manager, String name) {
        return manager.getLogger(DevModeLoggingFixes.addLoggerPrefix(name));
    }

    public static Enumeration<String> logManagerGetLoggerNames(LogManager manager) {
        Enumeration<String> loggerList = manager.getLoggerNames();
        ArrayList<String> newList = new ArrayList<String>();
        while (loggerList.hasMoreElements()) {
            String name = loggerList.nextElement();
            if (!DevModeLoggingFixes.startsWithLoggerPrefix(name)) continue;
            newList.add(DevModeLoggingFixes.removeLoggerPrefix(name));
        }
        return Collections.enumeration(newList);
    }

    private static String addLoggerPrefix(String name) {
        String string = String.valueOf(DevModeLoggingFixes.getLoggerPrefix());
        String string2 = String.valueOf(name);
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    private static String getLoggerPrefix() {
        return String.valueOf(DevModeLoggingFixes.getPrefixName()).concat(".");
    }

    private static String getPrefixName() {
        return GWT.getUniqueThreadId();
    }

    private static String removeLoggerPrefix(String name) {
        String string = String.valueOf(DevModeLoggingFixes.getLoggerPrefix());
        return name.replaceFirst(string.length() != 0 ? "^".concat(string) : new String("^"), "");
    }

    private static boolean startsWithLoggerPrefix(String name) {
        return name.startsWith(DevModeLoggingFixes.getLoggerPrefix());
    }
}

