/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.validation.client.impl;

import com.google.gwt.validation.client.impl.ConstraintDescriptorImpl;
import com.google.gwt.validation.client.impl.ConstraintValidatorContextImpl;
import com.google.gwt.validation.client.impl.ConstraintViolationImpl;
import com.google.gwt.validation.client.impl.Group;
import com.google.gwt.validation.client.impl.GroupChain;
import com.google.gwt.validation.client.impl.GroupChainGenerator;
import com.google.gwt.validation.client.impl.GroupValidator;
import com.google.gwt.validation.client.impl.GwtSpecificValidator;
import com.google.gwt.validation.client.impl.GwtValidationContext;
import com.google.gwt.validation.client.impl.MessageInterpolatorContextImpl;
import com.google.gwt.validation.client.impl.metadata.BeanMetadata;
import com.google.gwt.validation.client.impl.metadata.MessageAndPath;
import com.google.gwt.validation.client.impl.metadata.ValidationGroupsMetadata;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.ValidationException;
import javax.validation.groups.Default;

public abstract class AbstractGwtSpecificValidator<G>
implements GwtSpecificValidator<G> {
    public static AttributeBuilder attributeBuilder() {
        return new AttributeBuilder();
    }

    protected static Class<?>[] groupsToClasses(Group ... groups) {
        int numGroups = groups.length;
        Class[] array = new Class[numGroups];
        for (int i = 0; i < numGroups; ++i) {
            array[i] = groups[i].getGroup();
        }
        return array;
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validate(GwtValidationContext<T> context, G object, Class<?> ... groups) {
        context.addValidatedObject(object);
        try {
            ClassGroupValidator classGroupValidator = new ClassGroupValidator(object);
            GroupChain groupChain = this.createGroupChainFromGroups(context, groups);
            BeanMetadata beanMetadata = this.getBeanMetadata();
            List<Class<?>> defaultGroupSeq = beanMetadata.getDefaultGroupSequence();
            if (beanMetadata.defaultGroupSequenceIsRedefined()) {
                groupChain.checkDefaultGroupSequenceIsExpandable(defaultGroupSeq);
            }
            return this.validateGroups(context, classGroupValidator, groupChain);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            String string = String.valueOf(object.getClass());
            throw new ValidationException(new StringBuilder(17 + String.valueOf(string).length()).append("Error validating ").append(string).toString(), (Throwable)e);
        }
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateProperty(GwtValidationContext<T> context, G object, String propertyName, Class<?> ... groups) throws ValidationException {
        try {
            PropertyGroupValidator propertyGroupValidator = new PropertyGroupValidator(object, propertyName);
            GroupChain groupChain = this.createGroupChainFromGroups(context, groups);
            return this.validateGroups(context, propertyGroupValidator, groupChain);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            String string = String.valueOf(object.getClass());
            throw new ValidationException(new StringBuilder(30 + String.valueOf(propertyName).length() + String.valueOf(string).length()).append("Error validating property ").append(propertyName).append(" of ").append(string).toString(), (Throwable)e);
        }
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateValue(GwtValidationContext<T> context, Class<G> beanType, String propertyName, Object value, Class<?> ... groups) throws ValidationException {
        try {
            ValueGroupValidator valueGroupValidator = new ValueGroupValidator(beanType, propertyName, value);
            GroupChain groupChain = this.createGroupChainFromGroups(context, groups);
            return this.validateGroups(context, valueGroupValidator, groupChain);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            String string = String.valueOf(value);
            String string2 = String.valueOf(beanType);
            throw new ValidationException(new StringBuilder(42 + String.valueOf(propertyName).length() + String.valueOf(string).length() + String.valueOf(string2).length()).append("Error validating property ").append(propertyName).append(" with value ").append(string).append(" of ").append(string2).toString(), (Throwable)e);
        }
    }

    protected List<Class<?>> addDefaultGroupWhenEmpty(List<Class<?>> groups) {
        if (groups.isEmpty()) {
            groups = new ArrayList();
            groups.add(Default.class);
        }
        return groups;
    }

    protected <V, T, A extends Annotation> void addSingleViolation(GwtValidationContext<T> context, Set<ConstraintViolation<T>> violations, G object, V value, ConstraintDescriptorImpl<A> constraintDescriptor) {
        ConstraintValidatorContextImpl constraintValidatorContext = context.createConstraintValidatorContext(constraintDescriptor);
        this.addViolations(context, violations, object, value, constraintDescriptor, constraintValidatorContext);
    }

    protected <A extends Annotation, T, V> boolean validate(GwtValidationContext<T> context, Set<ConstraintViolation<T>> violations, G object, V value, ConstraintValidator<A, ? super V> validator, ConstraintDescriptorImpl<A> constraintDescriptor, Class<?> ... groups) {
        validator.initialize(constraintDescriptor.getAnnotation());
        ConstraintValidatorContextImpl constraintValidatorContext = context.createConstraintValidatorContext(constraintDescriptor);
        List<Class<?>> groupsList = Arrays.asList(groups);
        ValidationGroupsMetadata validationGroupsMetadata = context.getValidator().getValidationGroupsMetadata();
        Set<Class<?>> constraintGroups = constraintDescriptor.getGroups();
        if (!this.containsAny(groupsList, constraintGroups) && !groupsList.contains(this.getConstraints(validationGroupsMetadata).getElementClass())) {
            return false;
        }
        if (!validator.isValid(value, constraintValidatorContext)) {
            this.addViolations(context, violations, object, value, constraintDescriptor, constraintValidatorContext);
            return true;
        }
        return false;
    }

    private <V, T, A extends Annotation> void addViolations(GwtValidationContext<T> context, Set<ConstraintViolation<T>> violations, G object, V value, ConstraintDescriptorImpl<A> constraintDescriptor, ConstraintValidatorContextImpl<A, V> constraintValidatorContext) {
        Set<MessageAndPath> mps = constraintValidatorContext.getMessageAndPaths();
        for (MessageAndPath messageAndPath : mps) {
            ConstraintViolation<T> violation = this.createConstraintViolation(context, object, value, constraintDescriptor, messageAndPath);
            violations.add(violation);
        }
    }

    private <T> boolean containsAny(Collection<T> left, Collection<T> right) {
        for (T t : left) {
            if (!right.contains(t)) continue;
            return true;
        }
        return false;
    }

    private <T, V, A extends Annotation> ConstraintViolation<T> createConstraintViolation(GwtValidationContext<T> context, G object, V value, ConstraintDescriptorImpl<A> constraintDescriptor, MessageAndPath messageAndPath) {
        MessageInterpolator messageInterpolator = context.getMessageInterpolator();
        MessageInterpolatorContextImpl messageContext = new MessageInterpolatorContextImpl(constraintDescriptor, value);
        String message = messageInterpolator.interpolate(messageAndPath.getMessage(), (MessageInterpolator.Context)messageContext);
        ConstraintViolationImpl violation = ConstraintViolationImpl.builder().setConstraintDescriptor(constraintDescriptor).setInvalidValue(value).setLeafBean(object).setMessage(message).setMessageTemplate(messageAndPath.getMessage()).setPropertyPath(messageAndPath.getPath()).setRootBean(context.getRootBean()).setRootBeanClass(context.getRootBeanClass()).setElementType(constraintDescriptor.getElementType()).build();
        return violation;
    }

    private <T> GroupChain createGroupChainFromGroups(GwtValidationContext<T> context, Class<?> ... groups) {
        List<Class<?>> groupsList = this.addDefaultGroupWhenEmpty(Arrays.asList(groups));
        ValidationGroupsMetadata validationGroupsMetadata = context.getValidator().getValidationGroupsMetadata();
        return new GroupChainGenerator(validationGroupsMetadata).getGroupChainFor(groupsList);
    }

    private <T> Set<ConstraintViolation<T>> validateGroups(GwtValidationContext<T> context, GroupValidator groupValidator, GroupChain groupChain) {
        HashSet violations = new HashSet();
        Collection<Group> allGroups = groupChain.getAllGroups();
        Group[] allGroupsArray = allGroups.toArray(new Group[allGroups.size()]);
        groupValidator.validateGroups(context, violations, allGroupsArray);
        Iterator<List<Group>> sequenceIterator = groupChain.getSequenceIterator();
        block0: while (sequenceIterator.hasNext()) {
            List<Group> sequence = sequenceIterator.next();
            for (Group group : sequence) {
                int numberOfViolations = violations.size();
                groupValidator.validateGroups(context, violations, group);
                if (violations.size() <= numberOfViolations) continue;
                continue block0;
            }
        }
        return violations;
    }

    private class ValueGroupValidator
    implements GroupValidator {
        private final Class<G> beanType;
        private final String propertyName;
        private final Object value;

        public ValueGroupValidator(Class<G> beanType, String propertyName, Object value) {
            this.beanType = beanType;
            this.propertyName = propertyName;
            this.value = value;
        }

        @Override
        public <T> void validateGroups(GwtValidationContext<T> context, Set<ConstraintViolation<T>> violations, Group ... groups) {
            AbstractGwtSpecificValidator.this.expandDefaultAndValidateValueGroups(context, this.beanType, this.propertyName, this.value, violations, groups);
        }
    }

    private class PropertyGroupValidator
    implements GroupValidator {
        private final G object;
        private final String propertyName;

        public PropertyGroupValidator(G object, String propertyName) {
            this.object = object;
            this.propertyName = propertyName;
        }

        @Override
        public <T> void validateGroups(GwtValidationContext<T> context, Set<ConstraintViolation<T>> violations, Group ... groups) {
            AbstractGwtSpecificValidator.this.expandDefaultAndValidatePropertyGroups(context, this.object, this.propertyName, violations, groups);
        }
    }

    private class ClassGroupValidator
    implements GroupValidator {
        private final G object;

        public ClassGroupValidator(G object) {
            this.object = object;
        }

        @Override
        public <T> void validateGroups(GwtValidationContext<T> context, Set<ConstraintViolation<T>> violations, Group ... groups) {
            AbstractGwtSpecificValidator.this.expandDefaultAndValidateClassGroups(context, this.object, violations, groups);
        }
    }

    public static final class AttributeBuilder {
        private final HashMap<String, Object> tempMap = new HashMap();

        private AttributeBuilder() {
        }

        public Map<String, Object> build() {
            return Collections.unmodifiableMap(this.tempMap);
        }

        public AttributeBuilder put(String key, Object value) {
            this.tempMap.put(key, value);
            return this;
        }
    }
}

