/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "nus" locale.
 */
public class LocalizedNamesImpl_nus extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AC",
        "AZ",
        "AE",
        "AL",
        "DZ",
        "AS",
        "AD",
        "AG",
        "AQ",
        "AW",
        "AT",
        "AU",
        "AX",
        "AO",
        "AI",
        "AR",
        "AM",
        "BS",
        "BR",
        "BB",
        "BH",
        "BE",
        "BY",
        "BD",
        "BJ",
        "BM",
        "BZ",
        "BL",
        "BW",
        "BA",
        "BQ",
        "BG",
        "BO",
        "BF",
        "BI",
        "BN",
        "VG",
        "IO",
        "BT",
        "BV",
        "TD",
        "CN",
        "CC",
        "CD",
        "CH",
        "CL",
        "CP",
        "CU",
        "CW",
        "CX",
        "CY",
        "CZ",
        "CF",
        "DE",
        "DG",
        "DJ",
        "DK",
        "DM",
        "DO",
        "EA",
        "EC",
        "EE",
        "EG",
        "EH",
        "ER",
        "ES",
        "ET",
        "EU",
        "FI",
        "FJ",
        "FK",
        "FM",
        "FO",
        "FR",
        "GA",
        "GB",
        "GD",
        "GE",
        "GF",
        "GG",
        "GH",
        "GI",
        "GL",
        "GM",
        "GN",
        "GP",
        "GQ",
        "GR",
        "GS",
        "GT",
        "GU",
        "GW",
        "GY",
        "HK",
        "HM",
        "HN",
        "HT",
        "HU",
        "IC",
        "ID",
        "IE",
        "IL",
        "IM",
        "IN",
        "IQ",
        "IR",
        "IS",
        "IT",
        "JE",
        "JM",
        "JO",
        "JP",
        "CA",
        "KY",
        "KE",
        "KG",
        "KI",
        "KN",
        "CI",
        "CO",
        "KH",
        "KM",
        "HR",
        "CR",
        "KP",
        "KR",
        "CK",
        "KW",
        "KZ",
        "CG",
        "CM",
        "CV",
        "LA",
        "LB",
        "LC",
        "LI",
        "LK",
        "LR",
        "LS",
        "LT",
        "LU",
        "LV",
        "LY",
        "MA",
        "MC",
        "MD",
        "ME",
        "MF",
        "MG",
        "MH",
        "MK",
        "ML",
        "MM",
        "MN",
        "MO",
        "MP",
        "MQ",
        "MR",
        "MS",
        "MT",
        "MU",
        "MV",
        "MW",
        "MX",
        "MY",
        "MZ",
        "NA",
        "NC",
        "NE",
        "NF",
        "NG",
        "NI",
        "NL",
        "NO",
        "NP",
        "NR",
        "NU",
        "NZ",
        "OM",
        "PA",
        "PE",
        "PF",
        "PG",
        "PH",
        "PK",
        "PL",
        "PM",
        "PN",
        "PR",
        "PS",
        "PT",
        "PW",
        "PY",
        "QA",
        "QO",
        "RE",
        "RO",
        "RS",
        "RU",
        "RW",
        "SA",
        "SB",
        "SC",
        "SE",
        "SG",
        "SH",
        "SI",
        "SJ",
        "SK",
        "SL",
        "SM",
        "SN",
        "SO",
        "SR",
        "SS",
        "ST",
        "SD",
        "SV",
        "SX",
        "SY",
        "SZ",
        "TA",
        "TC",
        "TF",
        "TG",
        "TH",
        "TJ",
        "TK",
        "TL",
        "TM",
        "TN",
        "TO",
        "TR",
        "TT",
        "TV",
        "TW",
        "TZ",
        "UA",
        "UG",
        "UM",
        "US",
        "UY",
        "UZ",
        "VA",
        "VC",
        "VE",
        "VI",
        "VN",
        "VU",
        "WF",
        "WS",
        "XK",
        "YE",
        "YT",
        "ZA",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "Andora");
    namesMap.put("AF", "Abganithtan");
    namesMap.put("AG", "Antiguaa kɛnɛ Barbuda");
    namesMap.put("AI", "Aŋguɛla");
    namesMap.put("AL", "Albänia");
    namesMap.put("AM", "Aɛrmänia");
    namesMap.put("AO", "Aŋgola");
    namesMap.put("AR", "Aɛrgentin");
    namesMap.put("AS", "Amerika thamow");
    namesMap.put("AT", "Athtɛria");
    namesMap.put("AU", "Athɔra̱lia");
    namesMap.put("AZ", "Adhe̱rbe̱ja̱n");
    namesMap.put("BA", "Bothnia kɛnɛ ɣärgobinia");
    namesMap.put("BB", "Bärbadoth");
    namesMap.put("BD", "Bengeladiec");
    namesMap.put("BE", "Be̱lgim");
    namesMap.put("BF", "Burkinɛ pa̱thu");
    namesMap.put("BG", "Bulga̱a̱ria");
    namesMap.put("BH", "Ba̱reen");
    namesMap.put("BJ", "Be̱ni̱n");
    namesMap.put("BM", "Be̱rmudaa");
    namesMap.put("BN", "Burunɛy");
    namesMap.put("BO", "Bulibia");
    namesMap.put("BR", "Bäraadhiil");
    namesMap.put("BS", "Bämuɔth");
    namesMap.put("BT", "Buta̱n");
    namesMap.put("BW", "Bothiwaana");
    namesMap.put("BY", "Be̱lɛruth");
    namesMap.put("BZ", "Bilidha");
    namesMap.put("CA", "Känɛda");
    namesMap.put("CF", "Cɛntrɔl aprika repuɔblic");
    namesMap.put("CG", "Kɔŋgɔ");
    namesMap.put("CI", "Kodibo̱o̱");
    namesMap.put("CK", "Kuk ɣa̱ylɛn");
    namesMap.put("CL", "Cili̱");
    namesMap.put("CM", "Kɛmɛrun");
    namesMap.put("CN", "Cayna");
    namesMap.put("CO", "Kolombia");
    namesMap.put("CR", "Kothtirika");
    namesMap.put("CV", "Kɛp bedi ɣa̱ylɛn");
    namesMap.put("HR", "Korwaatia");
    namesMap.put("IO", "Burutic ɣe̱ndian oce̱n");
    namesMap.put("KH", "Kombodia");
    namesMap.put("KM", "Komruth");
    namesMap.put("KY", "Kaymɛn ɣa̱ylɛn");
    namesMap.put("TD", "Ca̱d");
    namesMap.put("VG", "Burutic dhuɔ̱ɔ̱l be̱rgin");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "Andora",
        "AF": "Abganithtan",
        "AG": "Antiguaa kɛnɛ Barbuda",
        "AI": "Aŋguɛla",
        "AL": "Albänia",
        "AM": "Aɛrmänia",
        "AO": "Aŋgola",
        "AR": "Aɛrgentin",
        "AS": "Amerika thamow",
        "AT": "Athtɛria",
        "AU": "Athɔra̱lia",
        "AZ": "Adhe̱rbe̱ja̱n",
        "BA": "Bothnia kɛnɛ ɣärgobinia",
        "BB": "Bärbadoth",
        "BD": "Bengeladiec",
        "BE": "Be̱lgim",
        "BF": "Burkinɛ pa̱thu",
        "BG": "Bulga̱a̱ria",
        "BH": "Ba̱reen",
        "BJ": "Be̱ni̱n",
        "BM": "Be̱rmudaa",
        "BN": "Burunɛy",
        "BO": "Bulibia",
        "BR": "Bäraadhiil",
        "BS": "Bämuɔth",
        "BT": "Buta̱n",
        "BW": "Bothiwaana",
        "BY": "Be̱lɛruth",
        "BZ": "Bilidha",
        "CA": "Känɛda",
        "CF": "Cɛntrɔl aprika repuɔblic",
        "CG": "Kɔŋgɔ",
        "CI": "Kodibo̱o̱",
        "CK": "Kuk ɣa̱ylɛn",
        "CL": "Cili̱",
        "CM": "Kɛmɛrun",
        "CN": "Cayna",
        "CO": "Kolombia",
        "CR": "Kothtirika",
        "CV": "Kɛp bedi ɣa̱ylɛn",
        "HR": "Korwaatia",
        "IO": "Burutic ɣe̱ndian oce̱n",
        "KH": "Kombodia",
        "KM": "Komruth",
        "KY": "Kaymɛn ɣa̱ylɛn",
        "TD": "Ca̱d",
        "VG": "Burutic dhuɔ̱ɔ̱l be̱rgin"
    };
  }-*/;
}
