/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.server;

import com.google.gwt.i18n.server.Message;
import com.google.gwt.i18n.server.MessageFormVisitor;
import com.google.gwt.i18n.server.MessageProcessingException;
import com.google.gwt.i18n.server.Parameter;
import java.util.List;

public class FormVisitorDriver {
    private int numSelectors;
    private MessageFormVisitor[] formVisitors;
    private String[] lastForm;
    private int[] selectorParams;
    private List<Parameter> params;

    public void endMessage(Message msg) throws MessageProcessingException {
        int i = this.numSelectors;
        while (i-- > 0) {
            if (this.lastForm[i] == null || this.formVisitors[i] == null) continue;
            this.formVisitors[i].endForm(i, this.lastForm[i]);
            this.formVisitors[i].endSelector(i, this.getSelectorParam(i));
        }
        this.formVisitors = null;
        this.lastForm = null;
    }

    public void initialize(Message msg) {
        this.initialize(msg, null);
    }

    public void initialize(Message msg, MessageFormVisitor formVisitor) {
        this.selectorParams = msg.getSelectorParameterIndices();
        this.numSelectors = this.selectorParams.length;
        this.formVisitors = new MessageFormVisitor[this.numSelectors];
        this.lastForm = new String[this.numSelectors];
        this.params = msg.getParameters();
        if (formVisitor != null) {
            for (int i = 0; i < this.numSelectors; ++i) {
                this.formVisitors[i] = formVisitor;
            }
        }
    }

    public void setFormVisitor(int level, MessageFormVisitor visitor) {
        this.formVisitors[level] = visitor;
    }

    public void visitForms(String[] formNames) throws MessageProcessingException {
        int firstDifferent;
        for (firstDifferent = 0; firstDifferent < this.numSelectors && formNames[firstDifferent].equals(this.lastForm[firstDifferent]); ++firstDifferent) {
        }
        int i = this.numSelectors;
        while (i-- > firstDifferent) {
            if (this.lastForm[i] == null || this.formVisitors[i] == null) continue;
            this.formVisitors[i].endForm(i, this.lastForm[i]);
            if (i <= firstDifferent) continue;
            this.formVisitors[i].endSelector(i, this.getSelectorParam(i));
        }
        for (i = firstDifferent; i < this.numSelectors; ++i) {
            if ((i > firstDifferent || this.lastForm[i] == null) && this.formVisitors[i] != null) {
                this.formVisitors[i].beginSelector(i, this.getSelectorParam(i));
            }
            this.lastForm[i] = formNames[i];
            if (this.formVisitors[i] == null) continue;
            this.formVisitors[i].beginForm(i, this.lastForm[i]);
        }
    }

    private Parameter getSelectorParam(int i) {
        int index = this.selectorParams[i];
        return index < 0 ? null : this.params.get(index);
    }
}

