/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.css;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.css.ast.Context;
import com.google.gwt.resources.css.ast.CssCompilerException;
import com.google.gwt.resources.css.ast.CssDef;
import com.google.gwt.resources.css.ast.CssSelector;
import com.google.gwt.resources.css.ast.CssStylesheet;
import com.google.gwt.resources.css.ast.CssVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;

public class ClassRenamer
extends CssVisitor {
    private static final Replacement UNREFERENCED_EXTERNAL = new Replacement(null, null);
    private final Map<JMethod, String> actualReplacements = new IdentityHashMap<JMethod, String>();
    private final Map<String, Map<JMethod, String>> classReplacementsWithPrefix;
    private final Set<String> cssDefs = new HashSet<String>();
    private final Set<String> externalClasses;
    private final TreeLogger logger;
    private final Set<JMethod> missingClasses;
    private final boolean strict;
    private final Set<String> unknownClasses = new HashSet<String>();

    public ClassRenamer(TreeLogger logger, Map<String, Map<JMethod, String>> classReplacementsWithPrefix, boolean strict, Set<String> externalClasses) {
        this.logger = logger.branch(TreeLogger.DEBUG, "Replacing CSS class names");
        this.classReplacementsWithPrefix = classReplacementsWithPrefix;
        this.strict = strict;
        this.externalClasses = externalClasses;
        assert (classReplacementsWithPrefix.containsKey(""));
        this.missingClasses = new HashSet<JMethod>(classReplacementsWithPrefix.get("").keySet());
    }

    @Override
    public void endVisit(CssDef x, Context ctx) {
        this.cssDefs.add(x.getKey());
    }

    @Override
    public void endVisit(CssSelector x, Context ctx) {
        Map<String, Replacement> potentialReplacements = this.computeReplacements(this.classReplacementsWithPrefix, this.externalClasses);
        String sel = x.getSelector();
        int originalLength = sel.length();
        Matcher ma = CssSelector.CLASS_SELECTOR_PATTERN.matcher(sel);
        StringBuilder sb = new StringBuilder(originalLength);
        int start = 0;
        while (ma.find()) {
            String sourceClassName = ma.group(1);
            Replacement entry = potentialReplacements.get(sourceClassName);
            if (entry == null) {
                this.unknownClasses.add(sourceClassName);
                continue;
            }
            if (entry == UNREFERENCED_EXTERNAL) continue;
            JMethod method = entry.getMethod();
            String obfuscatedClassName = entry.getObfuscatedClassName();
            sb.append(sel.subSequence(start, ma.start(1)));
            sb.append(obfuscatedClassName);
            start = ma.end(1);
            this.actualReplacements.put(method, obfuscatedClassName);
            this.missingClasses.remove(method);
        }
        if (start != 0) {
            sb.append(sel.subSequence(start, originalLength));
            x.setSelector(sb.toString());
        }
    }

    @Override
    public void endVisit(CssStylesheet x, Context ctx) {
        TreeLogger errorLogger;
        boolean stop = false;
        ArrayList<JMethod> toRemove = new ArrayList<JMethod>();
        for (JMethod method : this.missingClasses) {
            if (!this.cssDefs.contains(method.getName())) continue;
            toRemove.add(method);
        }
        for (JMethod method : toRemove) {
            this.missingClasses.remove(method);
        }
        if (!this.missingClasses.isEmpty()) {
            stop = true;
            errorLogger = this.logger.branch(TreeLogger.INFO, "The following obfuscated style classes were missing from the source CSS file:");
            for (JMethod m : this.missingClasses) {
                String name = m.getName();
                CssResource.ClassName className = (CssResource.ClassName)m.getAnnotation(CssResource.ClassName.class);
                if (className != null) {
                    name = className.value();
                }
                errorLogger.log(TreeLogger.ERROR, name + ": Fix by adding ." + name + "{}");
            }
        }
        if (this.strict && !this.unknownClasses.isEmpty()) {
            stop = true;
            errorLogger = this.logger.branch(TreeLogger.ERROR, "The following unobfuscated classes were present in a strict CssResource:");
            for (String s : this.unknownClasses) {
                errorLogger.log(TreeLogger.ERROR, s);
            }
            if (errorLogger.isLoggable(TreeLogger.INFO)) {
                errorLogger.log(TreeLogger.INFO, "Fix by adding String accessor method(s) to the CssResource interface for obfuscated classes, or using an @external declaration for unobfuscated classes.");
            }
        }
        if (stop) {
            throw new CssCompilerException("Missing a CSS replacement");
        }
    }

    public Map<JMethod, String> getReplacements() {
        return this.actualReplacements;
    }

    private Map<String, Replacement> computeReplacements(Map<String, Map<JMethod, String>> classReplacementsWithPrefix, Set<String> externalClasses) {
        HashMap<String, Replacement> toReturn = new HashMap<String, Replacement>();
        for (String string : externalClasses) {
            toReturn.put(string, UNREFERENCED_EXTERNAL);
        }
        for (Map.Entry entry : classReplacementsWithPrefix.entrySet()) {
            String prefix = (String)entry.getKey();
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                JMethod method = (JMethod)entry2.getKey();
                String sourceClassName = method.getName();
                String obfuscatedClassName = (String)entry2.getValue();
                if (this.cssDefs.contains(sourceClassName)) continue;
                CssResource.ClassName className = (CssResource.ClassName)method.getAnnotation(CssResource.ClassName.class);
                if (className != null) {
                    sourceClassName = className.value();
                }
                if (externalClasses.contains(sourceClassName = prefix + sourceClassName)) {
                    obfuscatedClassName = sourceClassName;
                }
                toReturn.put(sourceClassName, new Replacement(method, obfuscatedClassName));
            }
        }
        return Collections.unmodifiableMap(toReturn);
    }

    private static class Replacement {
        private JMethod method;
        private String obfuscatedClassName;

        public Replacement(JMethod method, String obfuscatedClassName) {
            this.method = method;
            this.obfuscatedClassName = obfuscatedClassName;
        }

        public JMethod getMethod() {
            return this.method;
        }

        public String getObfuscatedClassName() {
            return this.obfuscatedClassName;
        }

        public String toString() {
            if (this == UNREFERENCED_EXTERNAL) {
                return "Unreferenced external class name";
            }
            return this.method.getName() + "=" + this.obfuscatedClassName;
        }
    }
}

